-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local FibreChannel = {}

---@class FibreChannel.SpeedGbps
---@field SpeedGbps integer
local TSpeedGbps = {}
TSpeedGbps.__index = TSpeedGbps
TSpeedGbps.group = {}

local function TSpeedGbps_from_obj(obj)
    return setmetatable(obj, TSpeedGbps)
end

function TSpeedGbps.new(SpeedGbps)
    return TSpeedGbps_from_obj({SpeedGbps = SpeedGbps})
end
---@param obj FibreChannel.SpeedGbps
function TSpeedGbps:init_from_obj(obj)
    self.SpeedGbps = obj.SpeedGbps
end

function TSpeedGbps:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSpeedGbps.group)
end

TSpeedGbps.from_obj = TSpeedGbps_from_obj

TSpeedGbps.proto_property = {'SpeedGbps'}

TSpeedGbps.default = {0}

TSpeedGbps.struct = {{name = 'SpeedGbps', is_array = false, struct = nil}}

function TSpeedGbps:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SpeedGbps', self.SpeedGbps, 'uint32', true, errs, need_convert)

    TSpeedGbps:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSpeedGbps.proto_property, errs, need_convert)
    return self
end

function TSpeedGbps:unpack(_)
    return self.SpeedGbps
end

FibreChannel.SpeedGbps = TSpeedGbps

---@class FibreChannel.PermanentWWPN
---@field PermanentWWPN string
local TPermanentWWPN = {}
TPermanentWWPN.__index = TPermanentWWPN
TPermanentWWPN.group = {}

local function TPermanentWWPN_from_obj(obj)
    return setmetatable(obj, TPermanentWWPN)
end

function TPermanentWWPN.new(PermanentWWPN)
    return TPermanentWWPN_from_obj({PermanentWWPN = PermanentWWPN})
end
---@param obj FibreChannel.PermanentWWPN
function TPermanentWWPN:init_from_obj(obj)
    self.PermanentWWPN = obj.PermanentWWPN
end

function TPermanentWWPN:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPermanentWWPN.group)
end

TPermanentWWPN.from_obj = TPermanentWWPN_from_obj

TPermanentWWPN.proto_property = {'PermanentWWPN'}

TPermanentWWPN.default = {''}

TPermanentWWPN.struct = {{name = 'PermanentWWPN', is_array = false, struct = nil}}

function TPermanentWWPN:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PermanentWWPN', self.PermanentWWPN, 'string', true, errs, need_convert)

    TPermanentWWPN:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPermanentWWPN.proto_property, errs, need_convert)
    return self
end

function TPermanentWWPN:unpack(_)
    return self.PermanentWWPN
end

FibreChannel.PermanentWWPN = TPermanentWWPN

---@class FibreChannel.WWPN
---@field WWPN string
local TWWPN = {}
TWWPN.__index = TWWPN
TWWPN.group = {}

local function TWWPN_from_obj(obj)
    return setmetatable(obj, TWWPN)
end

function TWWPN.new(WWPN)
    return TWWPN_from_obj({WWPN = WWPN})
end
---@param obj FibreChannel.WWPN
function TWWPN:init_from_obj(obj)
    self.WWPN = obj.WWPN
end

function TWWPN:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWWPN.group)
end

TWWPN.from_obj = TWWPN_from_obj

TWWPN.proto_property = {'WWPN'}

TWWPN.default = {''}

TWWPN.struct = {{name = 'WWPN', is_array = false, struct = nil}}

function TWWPN:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'WWPN', self.WWPN, 'string', true, errs, need_convert)

    TWWPN:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWWPN.proto_property, errs, need_convert)
    return self
end

function TWWPN:unpack(_)
    return self.WWPN
end

FibreChannel.WWPN = TWWPN

---@class FibreChannel.PermanentWWNN
---@field PermanentWWNN string
local TPermanentWWNN = {}
TPermanentWWNN.__index = TPermanentWWNN
TPermanentWWNN.group = {}

local function TPermanentWWNN_from_obj(obj)
    return setmetatable(obj, TPermanentWWNN)
end

function TPermanentWWNN.new(PermanentWWNN)
    return TPermanentWWNN_from_obj({PermanentWWNN = PermanentWWNN})
end
---@param obj FibreChannel.PermanentWWNN
function TPermanentWWNN:init_from_obj(obj)
    self.PermanentWWNN = obj.PermanentWWNN
end

function TPermanentWWNN:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPermanentWWNN.group)
end

TPermanentWWNN.from_obj = TPermanentWWNN_from_obj

TPermanentWWNN.proto_property = {'PermanentWWNN'}

TPermanentWWNN.default = {''}

TPermanentWWNN.struct = {{name = 'PermanentWWNN', is_array = false, struct = nil}}

function TPermanentWWNN:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PermanentWWNN', self.PermanentWWNN, 'string', true, errs, need_convert)

    TPermanentWWNN:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPermanentWWNN.proto_property, errs, need_convert)
    return self
end

function TPermanentWWNN:unpack(_)
    return self.PermanentWWNN
end

FibreChannel.PermanentWWNN = TPermanentWWNN

---@class FibreChannel.WWNN
---@field WWNN string
local TWWNN = {}
TWWNN.__index = TWWNN
TWWNN.group = {}

local function TWWNN_from_obj(obj)
    return setmetatable(obj, TWWNN)
end

function TWWNN.new(WWNN)
    return TWWNN_from_obj({WWNN = WWNN})
end
---@param obj FibreChannel.WWNN
function TWWNN:init_from_obj(obj)
    self.WWNN = obj.WWNN
end

function TWWNN:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWWNN.group)
end

TWWNN.from_obj = TWWNN_from_obj

TWWNN.proto_property = {'WWNN'}

TWWNN.default = {''}

TWWNN.struct = {{name = 'WWNN', is_array = false, struct = nil}}

function TWWNN:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'WWNN', self.WWNN, 'string', true, errs, need_convert)

    TWWNN:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWWNN.proto_property, errs, need_convert)
    return self
end

function TWWNN:unpack(_)
    return self.WWNN
end

FibreChannel.WWNN = TWWNN

---@class FibreChannel.FCId
---@field FCId string
local TFCId = {}
TFCId.__index = TFCId
TFCId.group = {}

local function TFCId_from_obj(obj)
    return setmetatable(obj, TFCId)
end

function TFCId.new(FCId)
    return TFCId_from_obj({FCId = FCId})
end
---@param obj FibreChannel.FCId
function TFCId:init_from_obj(obj)
    self.FCId = obj.FCId
end

function TFCId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFCId.group)
end

TFCId.from_obj = TFCId_from_obj

TFCId.proto_property = {'FCId'}

TFCId.default = {''}

TFCId.struct = {{name = 'FCId', is_array = false, struct = nil}}

function TFCId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FCId', self.FCId, 'string', true, errs, need_convert)

    TFCId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFCId.proto_property, errs, need_convert)
    return self
end

function TFCId:unpack(_)
    return self.FCId
end

FibreChannel.FCId = TFCId

FibreChannel.interface = mdb.register_interface('bmc.kepler.Systems.NetworkPort.FibreChannel', {
    FCId = {'s', nil, true, nil, false},
    WWNN = {'s', nil, true, nil, false},
    PermanentWWNN = {'s', nil, true, nil, false},
    WWPN = {'s', nil, true, nil, false},
    PermanentWWPN = {'s', nil, true, nil, false},
    SpeedGbps = {'u', {'VOLATILE'}, true, nil, false}
}, {}, {})

return FibreChannel
