-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:http://license.coscl.org.cn/MulanPSL2     
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local EthDevice = {}

---@class EthDevice.PortFunctionId
---@field PortFunctionId integer
local TPortFunctionId = {}
TPortFunctionId.__index = TPortFunctionId
TPortFunctionId.group = {}

local function TPortFunctionId_from_obj(obj)
    return setmetatable(obj, TPortFunctionId)
end

function TPortFunctionId.new(PortFunctionId)
    return TPortFunctionId_from_obj({PortFunctionId = PortFunctionId})
end
---@param obj EthDevice.PortFunctionId
function TPortFunctionId:init_from_obj(obj)
    self.PortFunctionId = obj.PortFunctionId
end

function TPortFunctionId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPortFunctionId.group)
end

TPortFunctionId.from_obj = TPortFunctionId_from_obj

TPortFunctionId.proto_property = {'PortFunctionId'}

TPortFunctionId.default = {0}

TPortFunctionId.struct = {{name = 'PortFunctionId', is_array = false, struct = nil}}

function TPortFunctionId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PortFunctionId', self.PortFunctionId, 'uint8', true, errs, need_convert)

    TPortFunctionId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPortFunctionId.proto_property, errs, need_convert)
    return self
end

function TPortFunctionId:unpack(_)
    return self.PortFunctionId
end

EthDevice.PortFunctionId = TPortFunctionId

---@class EthDevice.Function
---@field Function integer
local TFunction = {}
TFunction.__index = TFunction
TFunction.group = {}

local function TFunction_from_obj(obj)
    return setmetatable(obj, TFunction)
end

function TFunction.new(Function)
    return TFunction_from_obj({Function = Function})
end
---@param obj EthDevice.Function
function TFunction:init_from_obj(obj)
    self.Function = obj.Function
end

function TFunction:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFunction.group)
end

TFunction.from_obj = TFunction_from_obj

TFunction.proto_property = {'Function'}

TFunction.default = {0}

TFunction.struct = {{name = 'Function', is_array = false, struct = nil}}

function TFunction:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Function', self.Function, 'uint8', true, errs, need_convert)

    TFunction:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFunction.proto_property, errs, need_convert)
    return self
end

function TFunction:unpack(_)
    return self.Function
end

EthDevice.Function = TFunction

---@class EthDevice.Device
---@field Device integer
local TDevice = {}
TDevice.__index = TDevice
TDevice.group = {}

local function TDevice_from_obj(obj)
    return setmetatable(obj, TDevice)
end

function TDevice.new(Device)
    return TDevice_from_obj({Device = Device})
end
---@param obj EthDevice.Device
function TDevice:init_from_obj(obj)
    self.Device = obj.Device
end

function TDevice:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDevice.group)
end

TDevice.from_obj = TDevice_from_obj

TDevice.proto_property = {'Device'}

TDevice.default = {0}

TDevice.struct = {{name = 'Device', is_array = false, struct = nil}}

function TDevice:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Device', self.Device, 'uint8', true, errs, need_convert)

    TDevice:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDevice.proto_property, errs, need_convert)
    return self
end

function TDevice:unpack(_)
    return self.Device
end

EthDevice.Device = TDevice

---@class EthDevice.Bus
---@field Bus integer
local TBus = {}
TBus.__index = TBus
TBus.group = {}

local function TBus_from_obj(obj)
    return setmetatable(obj, TBus)
end

function TBus.new(Bus)
    return TBus_from_obj({Bus = Bus})
end
---@param obj EthDevice.Bus
function TBus:init_from_obj(obj)
    self.Bus = obj.Bus
end

function TBus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBus.group)
end

TBus.from_obj = TBus_from_obj

TBus.proto_property = {'Bus'}

TBus.default = {0}

TBus.struct = {{name = 'Bus', is_array = false, struct = nil}}

function TBus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Bus', self.Bus, 'uint8', true, errs, need_convert)

    TBus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBus.proto_property, errs, need_convert)
    return self
end

function TBus:unpack(_)
    return self.Bus
end

EthDevice.Bus = TBus

---@class EthDevice.ControllerIndex
---@field ControllerIndex integer
local TControllerIndex = {}
TControllerIndex.__index = TControllerIndex
TControllerIndex.group = {}

local function TControllerIndex_from_obj(obj)
    return setmetatable(obj, TControllerIndex)
end

function TControllerIndex.new(ControllerIndex)
    return TControllerIndex_from_obj({ControllerIndex = ControllerIndex})
end
---@param obj EthDevice.ControllerIndex
function TControllerIndex:init_from_obj(obj)
    self.ControllerIndex = obj.ControllerIndex
end

function TControllerIndex:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TControllerIndex.group)
end

TControllerIndex.from_obj = TControllerIndex_from_obj

TControllerIndex.proto_property = {'ControllerIndex'}

TControllerIndex.default = {0}

TControllerIndex.struct = {{name = 'ControllerIndex', is_array = false, struct = nil}}

function TControllerIndex:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ControllerIndex', self.ControllerIndex, 'uint8', true, errs, need_convert)

    TControllerIndex:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TControllerIndex.proto_property, errs, need_convert)
    return self
end

function TControllerIndex:unpack(_)
    return self.ControllerIndex
end

EthDevice.ControllerIndex = TControllerIndex

---@class EthDevice.SocketID
---@field SocketID integer
local TSocketID = {}
TSocketID.__index = TSocketID
TSocketID.group = {}

local function TSocketID_from_obj(obj)
    return setmetatable(obj, TSocketID)
end

function TSocketID.new(SocketID)
    return TSocketID_from_obj({SocketID = SocketID})
end
---@param obj EthDevice.SocketID
function TSocketID:init_from_obj(obj)
    self.SocketID = obj.SocketID
end

function TSocketID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSocketID.group)
end

TSocketID.from_obj = TSocketID_from_obj

TSocketID.proto_property = {'SocketID'}

TSocketID.default = {0}

TSocketID.struct = {{name = 'SocketID', is_array = false, struct = nil}}

function TSocketID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SocketID', self.SocketID, 'uint8', true, errs, need_convert)

    TSocketID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSocketID.proto_property, errs, need_convert)
    return self
end

function TSocketID:unpack(_)
    return self.SocketID
end

EthDevice.SocketID = TSocketID

---@class EthDevice.Segment
---@field Segment integer
local TSegment = {}
TSegment.__index = TSegment
TSegment.group = {}

local function TSegment_from_obj(obj)
    return setmetatable(obj, TSegment)
end

function TSegment.new(Segment)
    return TSegment_from_obj({Segment = Segment})
end
---@param obj EthDevice.Segment
function TSegment:init_from_obj(obj)
    self.Segment = obj.Segment
end

function TSegment:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSegment.group)
end

TSegment.from_obj = TSegment_from_obj

TSegment.proto_property = {'Segment'}

TSegment.default = {0}

TSegment.struct = {{name = 'Segment', is_array = false, struct = nil}}

function TSegment:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Segment', self.Segment, 'uint8', true, errs, need_convert)

    TSegment:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSegment.proto_property, errs, need_convert)
    return self
end

function TSegment:unpack(_)
    return self.Segment
end

EthDevice.Segment = TSegment

---@class EthDevice.LaneId
---@field LaneId integer
local TLaneId = {}
TLaneId.__index = TLaneId
TLaneId.group = {}

local function TLaneId_from_obj(obj)
    return setmetatable(obj, TLaneId)
end

function TLaneId.new(LaneId)
    return TLaneId_from_obj({LaneId = LaneId})
end
---@param obj EthDevice.LaneId
function TLaneId:init_from_obj(obj)
    self.LaneId = obj.LaneId
end

function TLaneId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLaneId.group)
end

TLaneId.from_obj = TLaneId_from_obj

TLaneId.proto_property = {'LaneId'}

TLaneId.default = {0}

TLaneId.struct = {{name = 'LaneId', is_array = false, struct = nil}}

function TLaneId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LaneId', self.LaneId, 'uint8', true, errs, need_convert)

    TLaneId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLaneId.proto_property, errs, need_convert)
    return self
end

function TLaneId:unpack(_)
    return self.LaneId
end

EthDevice.LaneId = TLaneId

---@class EthDevice.PortId
---@field PortId integer
local TPortId = {}
TPortId.__index = TPortId
TPortId.group = {}

local function TPortId_from_obj(obj)
    return setmetatable(obj, TPortId)
end

function TPortId.new(PortId)
    return TPortId_from_obj({PortId = PortId})
end
---@param obj EthDevice.PortId
function TPortId:init_from_obj(obj)
    self.PortId = obj.PortId
end

function TPortId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPortId.group)
end

TPortId.from_obj = TPortId_from_obj

TPortId.proto_property = {'PortId'}

TPortId.default = {0}

TPortId.struct = {{name = 'PortId', is_array = false, struct = nil}}

function TPortId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PortId', self.PortId, 'uint8', true, errs, need_convert)

    TPortId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPortId.proto_property, errs, need_convert)
    return self
end

function TPortId:unpack(_)
    return self.PortId
end

EthDevice.PortId = TPortId

EthDevice.interface = mdb.register_interface('bmc.kepler.Systems.PCIeDevices.EthDevice', {
    PortId = {'y', nil, true, nil, false},
    LaneId = {'y', nil, true, nil, false},
    Segment = {'y', nil, true, nil, false},
    SocketID = {'y', nil, true, nil, false},
    ControllerIndex = {'y', nil, true, nil, false},
    Bus = {'y', nil, true, nil, false},
    Device = {'y', nil, true, nil, false},
    Function = {'y', nil, true, nil, false},
    PortFunctionId = {'y', nil, true, nil, false}
}, {}, {})

return EthDevice
