-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local DataCenterBridging = {}

---@class DataCenterBridging.Pfcmap
---@field Pfcmap integer
local TPfcmap = {}
TPfcmap.__index = TPfcmap
TPfcmap.group = {}

local function TPfcmap_from_obj(obj)
    return setmetatable(obj, TPfcmap)
end

function TPfcmap.new(Pfcmap)
    return TPfcmap_from_obj({Pfcmap = Pfcmap})
end
---@param obj DataCenterBridging.Pfcmap
function TPfcmap:init_from_obj(obj)
    self.Pfcmap = obj.Pfcmap
end

function TPfcmap:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPfcmap.group)
end

TPfcmap.from_obj = TPfcmap_from_obj

TPfcmap.proto_property = {'Pfcmap'}

TPfcmap.default = {0}

TPfcmap.struct = {{name = 'Pfcmap', is_array = false, struct = nil}}

function TPfcmap:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Pfcmap', self.Pfcmap, 'uint8', true, errs, need_convert)

    TPfcmap:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPfcmap.proto_property, errs, need_convert)
    return self
end

function TPfcmap:unpack(_)
    return self.Pfcmap
end

DataCenterBridging.Pfcmap = TPfcmap

---@class DataCenterBridging.PgStrict
---@field PgStrict integer[]
local TPgStrict = {}
TPgStrict.__index = TPgStrict
TPgStrict.group = {}

local function TPgStrict_from_obj(obj)
    return setmetatable(obj, TPgStrict)
end

function TPgStrict.new(PgStrict)
    return TPgStrict_from_obj({PgStrict = PgStrict})
end
---@param obj DataCenterBridging.PgStrict
function TPgStrict:init_from_obj(obj)
    self.PgStrict = obj.PgStrict
end

function TPgStrict:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPgStrict.group)
end

TPgStrict.from_obj = TPgStrict_from_obj

TPgStrict.proto_property = {'PgStrict'}

TPgStrict.default = {{}}

TPgStrict.struct = {{name = 'PgStrict', is_array = true, struct = nil}}

function TPgStrict:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'PgStrict', self.PgStrict, 'uint8', true, errs, need_convert)

    TPgStrict:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPgStrict.proto_property, errs, need_convert)
    return self
end

function TPgStrict:unpack(_)
    return self.PgStrict
end

DataCenterBridging.PgStrict = TPgStrict

---@class DataCenterBridging.Pgpct
---@field Pgpct integer[]
local TPgpct = {}
TPgpct.__index = TPgpct
TPgpct.group = {}

local function TPgpct_from_obj(obj)
    return setmetatable(obj, TPgpct)
end

function TPgpct.new(Pgpct)
    return TPgpct_from_obj({Pgpct = Pgpct})
end
---@param obj DataCenterBridging.Pgpct
function TPgpct:init_from_obj(obj)
    self.Pgpct = obj.Pgpct
end

function TPgpct:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPgpct.group)
end

TPgpct.from_obj = TPgpct_from_obj

TPgpct.proto_property = {'Pgpct'}

TPgpct.default = {{}}

TPgpct.struct = {{name = 'Pgpct', is_array = true, struct = nil}}

function TPgpct:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'Pgpct', self.Pgpct, 'uint8', true, errs, need_convert)

    TPgpct:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPgpct.proto_property, errs, need_convert)
    return self
end

function TPgpct:unpack(_)
    return self.Pgpct
end

DataCenterBridging.Pgpct = TPgpct

---@class DataCenterBridging.Uppgid
---@field Uppgid integer[]
local TUppgid = {}
TUppgid.__index = TUppgid
TUppgid.group = {}

local function TUppgid_from_obj(obj)
    return setmetatable(obj, TUppgid)
end

function TUppgid.new(Uppgid)
    return TUppgid_from_obj({Uppgid = Uppgid})
end
---@param obj DataCenterBridging.Uppgid
function TUppgid:init_from_obj(obj)
    self.Uppgid = obj.Uppgid
end

function TUppgid:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUppgid.group)
end

TUppgid.from_obj = TUppgid_from_obj

TUppgid.proto_property = {'Uppgid'}

TUppgid.default = {{}}

TUppgid.struct = {{name = 'Uppgid', is_array = true, struct = nil}}

function TUppgid:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'Uppgid', self.Uppgid, 'uint8', true, errs, need_convert)

    TUppgid:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUppgid.proto_property, errs, need_convert)
    return self
end

function TUppgid:unpack(_)
    return self.Uppgid
end

DataCenterBridging.Uppgid = TUppgid

---@class DataCenterBridging.Up2cos
---@field Up2cos integer[]
local TUp2cos = {}
TUp2cos.__index = TUp2cos
TUp2cos.group = {}

local function TUp2cos_from_obj(obj)
    return setmetatable(obj, TUp2cos)
end

function TUp2cos.new(Up2cos)
    return TUp2cos_from_obj({Up2cos = Up2cos})
end
---@param obj DataCenterBridging.Up2cos
function TUp2cos:init_from_obj(obj)
    self.Up2cos = obj.Up2cos
end

function TUp2cos:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUp2cos.group)
end

TUp2cos.from_obj = TUp2cos_from_obj

TUp2cos.proto_property = {'Up2cos'}

TUp2cos.default = {{}}

TUp2cos.struct = {{name = 'Up2cos', is_array = true, struct = nil}}

function TUp2cos:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'Up2cos', self.Up2cos, 'uint8', true, errs, need_convert)

    TUp2cos:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUp2cos.proto_property, errs, need_convert)
    return self
end

function TUp2cos:unpack(_)
    return self.Up2cos
end

DataCenterBridging.Up2cos = TUp2cos

DataCenterBridging.interface = mdb.register_interface('bmc.kepler.Systems.NetworkPort.DataCenterBridging', {
    Up2cos = {'ay', nil, true, nil, false},
    Uppgid = {'ay', nil, true, nil, false},
    Pgpct = {'ay', nil, true, nil, false},
    PgStrict = {'ay', nil, true, nil, false},
    Pfcmap = {'y', nil, true, nil, false}
}, {}, {})

return DataCenterBridging
