-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local BlockIO = {}

---@class BlockIO.PluginControlParams
---@field key string
---@field value string
local TPluginControlParams = {}
TPluginControlParams.__index = TPluginControlParams
TPluginControlParams.group = {}

local function TPluginControlParams_from_obj(obj)
    return setmetatable(obj, TPluginControlParams)
end

function TPluginControlParams.new(dict)
    return TPluginControlParams_from_obj(dict)
end

---@param obj BlockIO.PluginControlParams
function TPluginControlParams:init_from_obj(obj)
    self = obj
end

function TPluginControlParams:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPluginControlParams.group)
end

TPluginControlParams.from_obj = TPluginControlParams_from_obj

TPluginControlParams.proto_property = {}

TPluginControlParams.default = {}

TPluginControlParams.struct = {}

function TPluginControlParams:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for k, v in pairs(self) do

        validate.Optional(prefix .. 'key', k, 'string', false, errs, need_convert)

        validate.Optional(prefix .. 'value', v, 'string', false, errs, need_convert)

    end

    TPluginControlParams:remove_error_props(errs, self)
    return self
end

function TPluginControlParams:unpack(_)
    return self
end

BlockIO.PluginControlParams = TPluginControlParams

---@class BlockIO.SingleWriteData
---@field Offset integer
---@field InData integer[]
local TSingleWriteData = {}
TSingleWriteData.__index = TSingleWriteData
TSingleWriteData.group = {}

local function TSingleWriteData_from_obj(obj)
    return setmetatable(obj, TSingleWriteData)
end

function TSingleWriteData.new(Offset, InData)
    return TSingleWriteData_from_obj({Offset = Offset, InData = InData})
end
---@param obj BlockIO.SingleWriteData
function TSingleWriteData:init_from_obj(obj)
    self.Offset = obj.Offset
    self.InData = obj.InData
end

function TSingleWriteData:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSingleWriteData.group)
end

TSingleWriteData.from_obj = TSingleWriteData_from_obj

TSingleWriteData.proto_property = {'Offset', 'InData'}

TSingleWriteData.default = {0, {}}

TSingleWriteData.struct = {
    {name = 'Offset', is_array = false, struct = nil}, {name = 'InData', is_array = true, struct = nil}
}

function TSingleWriteData:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Offset', self.Offset, 'uint32', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'InData', self.InData, 'uint8', false, errs, need_convert)

    TSingleWriteData:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSingleWriteData.proto_property, errs, need_convert)
    return self
end

function TSingleWriteData:unpack(_)
    return self.Offset, self.InData
end

BlockIO.SingleWriteData = TSingleWriteData

---@class BlockIO.WriteReadByProtocolRsp
---@field OutData integer[]
local TWriteReadByProtocolRsp = {}
TWriteReadByProtocolRsp.__index = TWriteReadByProtocolRsp
TWriteReadByProtocolRsp.group = {}

local function TWriteReadByProtocolRsp_from_obj(obj)
    return setmetatable(obj, TWriteReadByProtocolRsp)
end

function TWriteReadByProtocolRsp.new(OutData)
    return TWriteReadByProtocolRsp_from_obj({OutData = OutData})
end
---@param obj BlockIO.WriteReadByProtocolRsp
function TWriteReadByProtocolRsp:init_from_obj(obj)
    self.OutData = obj.OutData
end

function TWriteReadByProtocolRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWriteReadByProtocolRsp.group)
end

TWriteReadByProtocolRsp.from_obj = TWriteReadByProtocolRsp_from_obj

TWriteReadByProtocolRsp.proto_property = {'OutData'}

TWriteReadByProtocolRsp.default = {{}}

TWriteReadByProtocolRsp.struct = {{name = 'OutData', is_array = true, struct = nil}}

function TWriteReadByProtocolRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'OutData', self.OutData, 'uint8', false, errs, need_convert)

    TWriteReadByProtocolRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWriteReadByProtocolRsp.proto_property, errs, need_convert)
    return self
end

function TWriteReadByProtocolRsp:unpack(_)
    return self.OutData
end

BlockIO.WriteReadByProtocolRsp = TWriteReadByProtocolRsp

---@class BlockIO.WriteReadByProtocolReq
---@field InData integer[]
---@field ReadLength integer
---@field Protocol integer
local TWriteReadByProtocolReq = {}
TWriteReadByProtocolReq.__index = TWriteReadByProtocolReq
TWriteReadByProtocolReq.group = {}

local function TWriteReadByProtocolReq_from_obj(obj)
    return setmetatable(obj, TWriteReadByProtocolReq)
end

function TWriteReadByProtocolReq.new(InData, ReadLength, Protocol)
    return TWriteReadByProtocolReq_from_obj({InData = InData, ReadLength = ReadLength, Protocol = Protocol})
end
---@param obj BlockIO.WriteReadByProtocolReq
function TWriteReadByProtocolReq:init_from_obj(obj)
    self.InData = obj.InData
    self.ReadLength = obj.ReadLength
    self.Protocol = obj.Protocol
end

function TWriteReadByProtocolReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWriteReadByProtocolReq.group)
end

TWriteReadByProtocolReq.from_obj = TWriteReadByProtocolReq_from_obj

TWriteReadByProtocolReq.proto_property = {'InData', 'ReadLength', 'Protocol'}

TWriteReadByProtocolReq.default = {{}, 0, 0}

TWriteReadByProtocolReq.struct = {
    {name = 'InData', is_array = true, struct = nil}, {name = 'ReadLength', is_array = false, struct = nil},
    {name = 'Protocol', is_array = false, struct = nil}
}

function TWriteReadByProtocolReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'InData', self.InData, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadLength', self.ReadLength, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Protocol', self.Protocol, 'uint8', false, errs, need_convert)

    TWriteReadByProtocolReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWriteReadByProtocolReq.proto_property, errs, need_convert)
    return self
end

function TWriteReadByProtocolReq:unpack(_)
    return self.InData, self.ReadLength, self.Protocol
end

BlockIO.WriteReadByProtocolReq = TWriteReadByProtocolReq

---@class BlockIO.PluginRequestExRsp
---@field OutData integer[]
local TPluginRequestExRsp = {}
TPluginRequestExRsp.__index = TPluginRequestExRsp
TPluginRequestExRsp.group = {}

local function TPluginRequestExRsp_from_obj(obj)
    return setmetatable(obj, TPluginRequestExRsp)
end

function TPluginRequestExRsp.new(OutData)
    return TPluginRequestExRsp_from_obj({OutData = OutData})
end
---@param obj BlockIO.PluginRequestExRsp
function TPluginRequestExRsp:init_from_obj(obj)
    self.OutData = obj.OutData
end

function TPluginRequestExRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPluginRequestExRsp.group)
end

TPluginRequestExRsp.from_obj = TPluginRequestExRsp_from_obj

TPluginRequestExRsp.proto_property = {'OutData'}

TPluginRequestExRsp.default = {{}}

TPluginRequestExRsp.struct = {{name = 'OutData', is_array = true, struct = nil}}

function TPluginRequestExRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'OutData', self.OutData, 'uint8', false, errs, need_convert)

    TPluginRequestExRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPluginRequestExRsp.proto_property, errs, need_convert)
    return self
end

function TPluginRequestExRsp:unpack(_)
    return self.OutData
end

BlockIO.PluginRequestExRsp = TPluginRequestExRsp

---@class BlockIO.PluginRequestExReq
---@field PluginName string
---@field Cmd string
---@field Params integer[]
---@field ControlParams BlockIO.PluginControlParams
local TPluginRequestExReq = {}
TPluginRequestExReq.__index = TPluginRequestExReq
TPluginRequestExReq.group = {}

local function TPluginRequestExReq_from_obj(obj)
    return setmetatable(obj, TPluginRequestExReq)
end

function TPluginRequestExReq.new(PluginName, Cmd, Params, ControlParams)
    return TPluginRequestExReq_from_obj({
        PluginName = PluginName,
        Cmd = Cmd,
        Params = Params,
        ControlParams = ControlParams
    })
end
---@param obj BlockIO.PluginRequestExReq
function TPluginRequestExReq:init_from_obj(obj)
    self.PluginName = obj.PluginName
    self.Cmd = obj.Cmd
    self.Params = obj.Params
    self.ControlParams = obj.ControlParams
end

function TPluginRequestExReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPluginRequestExReq.group)
end

TPluginRequestExReq.from_obj = TPluginRequestExReq_from_obj

TPluginRequestExReq.proto_property = {'PluginName', 'Cmd', 'Params', 'ControlParams'}

TPluginRequestExReq.default = {'', '', {}, BlockIO.PluginControlParams.default}

TPluginRequestExReq.struct = {
    {name = 'PluginName', is_array = false, struct = nil}, {name = 'Cmd', is_array = false, struct = nil},
    {name = 'Params', is_array = true, struct = nil},
    {name = 'ControlParams', is_array = false, struct = BlockIO.PluginControlParams.struct}
}

function TPluginRequestExReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    BlockIO.PluginControlParams.new(self.ControlParams):validate(prefix, errs, need_convert)

    validate.Optional(prefix .. 'PluginName', self.PluginName, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Cmd', self.Cmd, 'string', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'Params', self.Params, 'uint8', false, errs, need_convert)

    TPluginRequestExReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPluginRequestExReq.proto_property, errs, need_convert)
    return self
end

function TPluginRequestExReq:unpack(_)
    return self.PluginName, self.Cmd, self.Params, self.ControlParams
end

BlockIO.PluginRequestExReq = TPluginRequestExReq

---@class BlockIO.PluginRequestRsp
---@field OutData integer[]
local TPluginRequestRsp = {}
TPluginRequestRsp.__index = TPluginRequestRsp
TPluginRequestRsp.group = {}

local function TPluginRequestRsp_from_obj(obj)
    return setmetatable(obj, TPluginRequestRsp)
end

function TPluginRequestRsp.new(OutData)
    return TPluginRequestRsp_from_obj({OutData = OutData})
end
---@param obj BlockIO.PluginRequestRsp
function TPluginRequestRsp:init_from_obj(obj)
    self.OutData = obj.OutData
end

function TPluginRequestRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPluginRequestRsp.group)
end

TPluginRequestRsp.from_obj = TPluginRequestRsp_from_obj

TPluginRequestRsp.proto_property = {'OutData'}

TPluginRequestRsp.default = {{}}

TPluginRequestRsp.struct = {{name = 'OutData', is_array = true, struct = nil}}

function TPluginRequestRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'OutData', self.OutData, 'uint8', false, errs, need_convert)

    TPluginRequestRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPluginRequestRsp.proto_property, errs, need_convert)
    return self
end

function TPluginRequestRsp:unpack(_)
    return self.OutData
end

BlockIO.PluginRequestRsp = TPluginRequestRsp

---@class BlockIO.PluginRequestReq
---@field PluginName string
---@field Cmd string
---@field Params integer[]
local TPluginRequestReq = {}
TPluginRequestReq.__index = TPluginRequestReq
TPluginRequestReq.group = {}

local function TPluginRequestReq_from_obj(obj)
    return setmetatable(obj, TPluginRequestReq)
end

function TPluginRequestReq.new(PluginName, Cmd, Params)
    return TPluginRequestReq_from_obj({PluginName = PluginName, Cmd = Cmd, Params = Params})
end
---@param obj BlockIO.PluginRequestReq
function TPluginRequestReq:init_from_obj(obj)
    self.PluginName = obj.PluginName
    self.Cmd = obj.Cmd
    self.Params = obj.Params
end

function TPluginRequestReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPluginRequestReq.group)
end

TPluginRequestReq.from_obj = TPluginRequestReq_from_obj

TPluginRequestReq.proto_property = {'PluginName', 'Cmd', 'Params'}

TPluginRequestReq.default = {'', '', {}}

TPluginRequestReq.struct = {
    {name = 'PluginName', is_array = false, struct = nil}, {name = 'Cmd', is_array = false, struct = nil},
    {name = 'Params', is_array = true, struct = nil}
}

function TPluginRequestReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PluginName', self.PluginName, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Cmd', self.Cmd, 'string', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'Params', self.Params, 'uint8', false, errs, need_convert)

    TPluginRequestReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPluginRequestReq.proto_property, errs, need_convert)
    return self
end

function TPluginRequestReq:unpack(_)
    return self.PluginName, self.Cmd, self.Params
end

BlockIO.PluginRequestReq = TPluginRequestReq

---@class BlockIO.BatchWriteRsp
local TBatchWriteRsp = {}
TBatchWriteRsp.__index = TBatchWriteRsp
TBatchWriteRsp.group = {}

local function TBatchWriteRsp_from_obj(obj)
    return setmetatable(obj, TBatchWriteRsp)
end

function TBatchWriteRsp.new()
    return TBatchWriteRsp_from_obj({})
end
---@param obj BlockIO.BatchWriteRsp
function TBatchWriteRsp:init_from_obj(obj)

end

function TBatchWriteRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBatchWriteRsp.group)
end

TBatchWriteRsp.from_obj = TBatchWriteRsp_from_obj

TBatchWriteRsp.proto_property = {}

TBatchWriteRsp.default = {}

TBatchWriteRsp.struct = {}

function TBatchWriteRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TBatchWriteRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBatchWriteRsp.proto_property, errs, need_convert)
    return self
end

function TBatchWriteRsp:unpack(_)
end

BlockIO.BatchWriteRsp = TBatchWriteRsp

---@class BlockIO.BatchWriteReq
---@field WriteData BlockIO.SingleWriteData[]
local TBatchWriteReq = {}
TBatchWriteReq.__index = TBatchWriteReq
TBatchWriteReq.group = {}

local function TBatchWriteReq_from_obj(obj)
    obj.WriteData = utils.from_obj(BlockIO.SingleWriteData, obj.WriteData, true)
    return setmetatable(obj, TBatchWriteReq)
end

function TBatchWriteReq.new(WriteData)
    return TBatchWriteReq_from_obj({WriteData = WriteData})
end
---@param obj BlockIO.BatchWriteReq
function TBatchWriteReq:init_from_obj(obj)
    self.WriteData = obj.WriteData
end

function TBatchWriteReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBatchWriteReq.group)
end

TBatchWriteReq.from_obj = TBatchWriteReq_from_obj

TBatchWriteReq.proto_property = {'WriteData'}

TBatchWriteReq.default = {{}}

TBatchWriteReq.struct = {{name = 'WriteData', is_array = true, struct = BlockIO.SingleWriteData.struct}}

function TBatchWriteReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.WriteData) do
        BlockIO.SingleWriteData.new(v.Offset, v.InData):validate(prefix, errs, need_convert)
    end

    TBatchWriteReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBatchWriteReq.proto_property, errs, need_convert)
    return self
end

function TBatchWriteReq:unpack(raw)
    return utils.unpack(raw, self.WriteData, true)
end

BlockIO.BatchWriteReq = TBatchWriteReq

---@class BlockIO.ComboWriteReadRsp
---@field OutData integer[]
local TComboWriteReadRsp = {}
TComboWriteReadRsp.__index = TComboWriteReadRsp
TComboWriteReadRsp.group = {}

local function TComboWriteReadRsp_from_obj(obj)
    return setmetatable(obj, TComboWriteReadRsp)
end

function TComboWriteReadRsp.new(OutData)
    return TComboWriteReadRsp_from_obj({OutData = OutData})
end
---@param obj BlockIO.ComboWriteReadRsp
function TComboWriteReadRsp:init_from_obj(obj)
    self.OutData = obj.OutData
end

function TComboWriteReadRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TComboWriteReadRsp.group)
end

TComboWriteReadRsp.from_obj = TComboWriteReadRsp_from_obj

TComboWriteReadRsp.proto_property = {'OutData'}

TComboWriteReadRsp.default = {{}}

TComboWriteReadRsp.struct = {{name = 'OutData', is_array = true, struct = nil}}

function TComboWriteReadRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'OutData', self.OutData, 'uint8', false, errs, need_convert)

    TComboWriteReadRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TComboWriteReadRsp.proto_property, errs, need_convert)
    return self
end

function TComboWriteReadRsp:unpack(_)
    return self.OutData
end

BlockIO.ComboWriteReadRsp = TComboWriteReadRsp

---@class BlockIO.ComboWriteReadReq
---@field WriteOffset integer
---@field InData integer[]
---@field ReadOffset integer
---@field ReadLength integer
local TComboWriteReadReq = {}
TComboWriteReadReq.__index = TComboWriteReadReq
TComboWriteReadReq.group = {}

local function TComboWriteReadReq_from_obj(obj)
    return setmetatable(obj, TComboWriteReadReq)
end

function TComboWriteReadReq.new(WriteOffset, InData, ReadOffset, ReadLength)
    return TComboWriteReadReq_from_obj({
        WriteOffset = WriteOffset,
        InData = InData,
        ReadOffset = ReadOffset,
        ReadLength = ReadLength
    })
end
---@param obj BlockIO.ComboWriteReadReq
function TComboWriteReadReq:init_from_obj(obj)
    self.WriteOffset = obj.WriteOffset
    self.InData = obj.InData
    self.ReadOffset = obj.ReadOffset
    self.ReadLength = obj.ReadLength
end

function TComboWriteReadReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TComboWriteReadReq.group)
end

TComboWriteReadReq.from_obj = TComboWriteReadReq_from_obj

TComboWriteReadReq.proto_property = {'WriteOffset', 'InData', 'ReadOffset', 'ReadLength'}

TComboWriteReadReq.default = {0, {}, 0, 0}

TComboWriteReadReq.struct = {
    {name = 'WriteOffset', is_array = false, struct = nil}, {name = 'InData', is_array = true, struct = nil},
    {name = 'ReadOffset', is_array = false, struct = nil}, {name = 'ReadLength', is_array = false, struct = nil}
}

function TComboWriteReadReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'WriteOffset', self.WriteOffset, 'uint32', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'InData', self.InData, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadOffset', self.ReadOffset, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadLength', self.ReadLength, 'uint32', false, errs, need_convert)

    TComboWriteReadReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TComboWriteReadReq.proto_property, errs, need_convert)
    return self
end

function TComboWriteReadReq:unpack(_)
    return self.WriteOffset, self.InData, self.ReadOffset, self.ReadLength
end

BlockIO.ComboWriteReadReq = TComboWriteReadReq

---@class BlockIO.WriteReadRsp
---@field OutData integer[]
local TWriteReadRsp = {}
TWriteReadRsp.__index = TWriteReadRsp
TWriteReadRsp.group = {}

local function TWriteReadRsp_from_obj(obj)
    return setmetatable(obj, TWriteReadRsp)
end

function TWriteReadRsp.new(OutData)
    return TWriteReadRsp_from_obj({OutData = OutData})
end
---@param obj BlockIO.WriteReadRsp
function TWriteReadRsp:init_from_obj(obj)
    self.OutData = obj.OutData
end

function TWriteReadRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWriteReadRsp.group)
end

TWriteReadRsp.from_obj = TWriteReadRsp_from_obj

TWriteReadRsp.proto_property = {'OutData'}

TWriteReadRsp.default = {{}}

TWriteReadRsp.struct = {{name = 'OutData', is_array = true, struct = nil}}

function TWriteReadRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'OutData', self.OutData, 'uint8', false, errs, need_convert)

    TWriteReadRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWriteReadRsp.proto_property, errs, need_convert)
    return self
end

function TWriteReadRsp:unpack(_)
    return self.OutData
end

BlockIO.WriteReadRsp = TWriteReadRsp

---@class BlockIO.WriteReadReq
---@field InData integer[]
---@field ReadLength integer
local TWriteReadReq = {}
TWriteReadReq.__index = TWriteReadReq
TWriteReadReq.group = {}

local function TWriteReadReq_from_obj(obj)
    return setmetatable(obj, TWriteReadReq)
end

function TWriteReadReq.new(InData, ReadLength)
    return TWriteReadReq_from_obj({InData = InData, ReadLength = ReadLength})
end
---@param obj BlockIO.WriteReadReq
function TWriteReadReq:init_from_obj(obj)
    self.InData = obj.InData
    self.ReadLength = obj.ReadLength
end

function TWriteReadReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWriteReadReq.group)
end

TWriteReadReq.from_obj = TWriteReadReq_from_obj

TWriteReadReq.proto_property = {'InData', 'ReadLength'}

TWriteReadReq.default = {{}, 0}

TWriteReadReq.struct = {
    {name = 'InData', is_array = true, struct = nil}, {name = 'ReadLength', is_array = false, struct = nil}
}

function TWriteReadReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'InData', self.InData, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadLength', self.ReadLength, 'uint32', false, errs, need_convert)

    TWriteReadReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWriteReadReq.proto_property, errs, need_convert)
    return self
end

function TWriteReadReq:unpack(_)
    return self.InData, self.ReadLength
end

BlockIO.WriteReadReq = TWriteReadReq

---@class BlockIO.WriteRsp
local TWriteRsp = {}
TWriteRsp.__index = TWriteRsp
TWriteRsp.group = {}

local function TWriteRsp_from_obj(obj)
    return setmetatable(obj, TWriteRsp)
end

function TWriteRsp.new()
    return TWriteRsp_from_obj({})
end
---@param obj BlockIO.WriteRsp
function TWriteRsp:init_from_obj(obj)

end

function TWriteRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWriteRsp.group)
end

TWriteRsp.from_obj = TWriteRsp_from_obj

TWriteRsp.proto_property = {}

TWriteRsp.default = {}

TWriteRsp.struct = {}

function TWriteRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TWriteRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWriteRsp.proto_property, errs, need_convert)
    return self
end

function TWriteRsp:unpack(_)
end

BlockIO.WriteRsp = TWriteRsp

---@class BlockIO.WriteReq
---@field Offset integer
---@field InData integer[]
local TWriteReq = {}
TWriteReq.__index = TWriteReq
TWriteReq.group = {}

local function TWriteReq_from_obj(obj)
    return setmetatable(obj, TWriteReq)
end

function TWriteReq.new(Offset, InData)
    return TWriteReq_from_obj({Offset = Offset, InData = InData})
end
---@param obj BlockIO.WriteReq
function TWriteReq:init_from_obj(obj)
    self.Offset = obj.Offset
    self.InData = obj.InData
end

function TWriteReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWriteReq.group)
end

TWriteReq.from_obj = TWriteReq_from_obj

TWriteReq.proto_property = {'Offset', 'InData'}

TWriteReq.default = {0, {}}

TWriteReq.struct = {{name = 'Offset', is_array = false, struct = nil}, {name = 'InData', is_array = true, struct = nil}}

function TWriteReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Offset', self.Offset, 'uint32', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'InData', self.InData, 'uint8', false, errs, need_convert)

    TWriteReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWriteReq.proto_property, errs, need_convert)
    return self
end

function TWriteReq:unpack(_)
    return self.Offset, self.InData
end

BlockIO.WriteReq = TWriteReq

---@class BlockIO.ReadRsp
---@field OutData integer[]
local TReadRsp = {}
TReadRsp.__index = TReadRsp
TReadRsp.group = {}

local function TReadRsp_from_obj(obj)
    return setmetatable(obj, TReadRsp)
end

function TReadRsp.new(OutData)
    return TReadRsp_from_obj({OutData = OutData})
end
---@param obj BlockIO.ReadRsp
function TReadRsp:init_from_obj(obj)
    self.OutData = obj.OutData
end

function TReadRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReadRsp.group)
end

TReadRsp.from_obj = TReadRsp_from_obj

TReadRsp.proto_property = {'OutData'}

TReadRsp.default = {{}}

TReadRsp.struct = {{name = 'OutData', is_array = true, struct = nil}}

function TReadRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'OutData', self.OutData, 'uint8', false, errs, need_convert)

    TReadRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReadRsp.proto_property, errs, need_convert)
    return self
end

function TReadRsp:unpack(_)
    return self.OutData
end

BlockIO.ReadRsp = TReadRsp

---@class BlockIO.ReadReq
---@field Offset integer
---@field Length integer
local TReadReq = {}
TReadReq.__index = TReadReq
TReadReq.group = {}

local function TReadReq_from_obj(obj)
    return setmetatable(obj, TReadReq)
end

function TReadReq.new(Offset, Length)
    return TReadReq_from_obj({Offset = Offset, Length = Length})
end
---@param obj BlockIO.ReadReq
function TReadReq:init_from_obj(obj)
    self.Offset = obj.Offset
    self.Length = obj.Length
end

function TReadReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReadReq.group)
end

TReadReq.from_obj = TReadReq_from_obj

TReadReq.proto_property = {'Offset', 'Length'}

TReadReq.default = {0, 0}

TReadReq.struct = {{name = 'Offset', is_array = false, struct = nil}, {name = 'Length', is_array = false, struct = nil}}

function TReadReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Offset', self.Offset, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint32', false, errs, need_convert)

    TReadReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReadReq.proto_property, errs, need_convert)
    return self
end

function TReadReq:unpack(_)
    return self.Offset, self.Length
end

BlockIO.ReadReq = TReadReq

BlockIO.interface = mdb.register_interface('bmc.kepler.Chip.BlockIO', {}, {
    Read = {'a{ss}uu', 'ay', TReadReq, TReadRsp},
    Write = {'a{ss}uay', '', TWriteReq, TWriteRsp},
    WriteRead = {'a{ss}ayu', 'ay', TWriteReadReq, TWriteReadRsp},
    ComboWriteRead = {'a{ss}uayuu', 'ay', TComboWriteReadReq, TComboWriteReadRsp},
    BatchWrite = {'a{ss}a(uay)', '', TBatchWriteReq, TBatchWriteRsp},
    PluginRequest = {'a{ss}ssay', 'ay', TPluginRequestReq, TPluginRequestRsp},
    PluginRequestEx = {'a{ss}ssaya{ss}', 'ay', TPluginRequestExReq, TPluginRequestExRsp},
    WriteReadByProtocol = {'a{ss}ayuy', 'ay', TWriteReadByProtocolReq, TWriteReadByProtocolRsp}
}, {})

return BlockIO
