--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local bs = require 'mc.bitstring'
local enums = require 'ipmi.enums'
local ipmi = require 'ipmi'
local types = require 'ipmi.types'
local privilege = require 'mc.privilege'
local msg = require 'network_adapter.ipmi.ipmi_message'

local CT = enums.ChannelType

local NetworkAdapterIpmiCmds = {}

NetworkAdapterIpmiCmds.WriteMacAddress = {
    name = 'WriteMacAddress',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x90,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[00]=],
    decode = [=[<<0x00:1/unit:8, FruId:1/unit:8, MacId:1/unit:8, I]=] ..
        [=[nterfaceType:1/unit:8, MacAddress1:1/unit:8, MacAd]=] ..
        [=[dress2:1/unit:8, MacAddress3:1/unit:8, MacAddress4]=] ..
        [=[:1/unit:8, MacAddress5:1/unit:8, MacAddress6:1/uni]=] .. [=[t:8>>]=],
    encode = [=[<<0x00:1/unit:8, FruId:1/unit:8>>]=],
    req = msg.WriteMacAddressReq,
    rsp = msg.WriteMacAddressRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

NetworkAdapterIpmiCmds.GetMacAddress = {
    name = 'GetMacAddress',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x90,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[01]=],
    decode = [=[<<0x01:1/unit:8, FruId:1/unit:8, Data/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, FruId:1/unit:8, MacId:1]=] ..
        [=[/unit:8, InterfaceType:1/unit:8, MacAddr/string>>]=],
    req = msg.GetMacAddressReq,
    rsp = msg.GetMacAddressRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

NetworkAdapterIpmiCmds.GetNcsiSlot = {
    name = 'GetNcsiSlot',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,5B,0C,00,00,00]=],
    decode = [=[<<ManuId:3/unit:8, 0x5B:1/unit:8, 0x000C:2/unit:8,]=] .. [=[ 0x0000:2/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManuId:3/unit:8, Slot:1]=] .. [=[/unit:8>>]=],
    req = msg.GetNcsiSlotReq,
    rsp = msg.GetNcsiSlotRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

NetworkAdapterIpmiCmds.GetBusinessPortInfo = {
    name = 'GetBusinessPortInfo',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,5e,*,00]=],
    decode = [=[<<ManuId:3/unit:8, 0x5e:1/unit:8, Reserved:1/unit:]=] .. [=[8, 0x00:1/unit:8, PortNo:2/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] ..
        [=[ PortNo:2/unit:8, TotalLen:1/unit:8, Data/string>>]=],
    req = msg.GetBusinessPortInfoReq,
    rsp = msg.GetBusinessPortInfoRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

NetworkAdapterIpmiCmds.SetIPMCConfiguration = {
    name = 'SetIPMCConfiguration',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,05,19]=],
    decode = [=[<<ManuId:3/unit:8, 0x05:1/unit:8, 0x19:1/unit:8, F]=] ..
        [=[lag:1/unit:1, Reserved:7/unit:1, Offset:1/unit:8, ]=] .. [=[Length:1/unit:8, Data:Length/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetIPMCConfigurationReq,
    rsp = msg.SetIPMCConfigurationRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

NetworkAdapterIpmiCmds.GetIPMCConfiguration = {
    name = 'GetIPMCConfiguration',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,06,19]=],
    decode = [=[<<ManuId:3/unit:8, 0x06:1/unit:8, 0x19:1/unit:8, O]=] .. [=[ffset:1/unit:8, Length:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ 0x00:1/unit:8, Data/string>>]=],
    req = msg.GetIPMCConfigurationReq,
    rsp = msg.GetIPMCConfigurationRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

NetworkAdapterIpmiCmds.GetNetworkAdapterModelByLOM = {
    name = 'GetNetworkAdapterModelByLOM',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,40,4A,05]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x40:1/unit:8, 0x4A:1/u]=] ..
        [=[nit:8, 0x05:1/unit:8, Length:1/unit:8, Data/string]=] .. [=[>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Data/string>>]=],
    req = msg.GetNetworkAdapterModelByLOMReq,
    rsp = msg.GetNetworkAdapterModelByLOMRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

NetworkAdapterIpmiCmds.GetNetworkAdapterModelByOCPCard = {
    name = 'GetNetworkAdapterModelByOCPCard',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,40,53,05]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x40:1/unit:8, 0x53:1/u]=] ..
        [=[nit:8, 0x05:1/unit:8, Length:1/unit:8, Data/string]=] .. [=[>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Data/string>>]=],
    req = msg.GetNetworkAdapterModelByOCPCardReq,
    rsp = msg.GetNetworkAdapterModelByOCPCardRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

NetworkAdapterIpmiCmds.GetDpuOSStartupStatus = {
    name = 'GetDpuOSStartupStatus',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,27,39,ff,c4]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x27:1/unit:8, 0x39:1/un]=] ..
        [=[it:8, 0xff:1/unit:8, 0xc4:1/unit:8, Offset:1/unit:]=] .. [=[8, Length:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] ..
        [=[ EndOfList:1/unit:8, SystemStatus:1/unit:8>>]=],
    req = msg.GetDpuOSStartupStatusReq,
    rsp = msg.GetDpuOSStartupStatusRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

NetworkAdapterIpmiCmds.GetDpuForcePowerOnState = {
    name = 'GetDpuForcePowerOnState',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,27,39,ff,c3]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x27:1/unit:8, 0x39:1/un]=] ..
        [=[it:8, 0xff:1/unit:8, 0xc3:1/unit:8, Offset:1/unit:]=] .. [=[8, Length:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] ..
        [=[ EndOfList:1/unit:8, ForcePowerStatus:1/unit:8>>]=],
    req = msg.GetDpuForcePowerOnStateReq,
    rsp = msg.GetDpuForcePowerOnStateRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

NetworkAdapterIpmiCmds.SetDpuForcePowerOnState = {
    name = 'SetDpuForcePowerOnState',
    prio = types.Priority.Default,
    netfn = 0x3a,
    cmd = 0xf6,
    role = types.Role.Operator,
    privilege = privilege.PowerMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[00]=],
    decode = [=[<<0x00:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.SetDpuForcePowerOnStateReq,
    rsp = msg.SetDpuForcePowerOnStateRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

return NetworkAdapterIpmiCmds
