--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local WriteMacAddress = {}

---@class NetworkAdapterIpmiCmds.WriteMacAddressReq
---@field FruId integer
---@field MacId integer
---@field InterfaceType integer
---@field MacAddress1 integer
---@field MacAddress2 integer
---@field MacAddress3 integer
---@field MacAddress4 integer
---@field MacAddress5 integer
---@field MacAddress6 integer
local TWriteMacAddressReq = {}
TWriteMacAddressReq.__index = TWriteMacAddressReq
TWriteMacAddressReq.group = {}

local function TWriteMacAddressReq_from_obj(obj)
    return setmetatable(obj, TWriteMacAddressReq)
end

function TWriteMacAddressReq.new(FruId, MacId, InterfaceType, MacAddress1, MacAddress2, MacAddress3, MacAddress4,
    MacAddress5, MacAddress6)
    return TWriteMacAddressReq_from_obj({
        FruId = FruId,
        MacId = MacId,
        InterfaceType = InterfaceType,
        MacAddress1 = MacAddress1,
        MacAddress2 = MacAddress2,
        MacAddress3 = MacAddress3,
        MacAddress4 = MacAddress4,
        MacAddress5 = MacAddress5,
        MacAddress6 = MacAddress6
    })
end
---@param obj NetworkAdapterIpmiCmds.WriteMacAddressReq
function TWriteMacAddressReq:init_from_obj(obj)
    self.FruId = obj.FruId
    self.MacId = obj.MacId
    self.InterfaceType = obj.InterfaceType
    self.MacAddress1 = obj.MacAddress1
    self.MacAddress2 = obj.MacAddress2
    self.MacAddress3 = obj.MacAddress3
    self.MacAddress4 = obj.MacAddress4
    self.MacAddress5 = obj.MacAddress5
    self.MacAddress6 = obj.MacAddress6
end

function TWriteMacAddressReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWriteMacAddressReq.group)
end

TWriteMacAddressReq.from_obj = TWriteMacAddressReq_from_obj

TWriteMacAddressReq.proto_property = {
    'FruId', 'MacId', 'InterfaceType', 'MacAddress1', 'MacAddress2', 'MacAddress3', 'MacAddress4', 'MacAddress5',
    'MacAddress6'
}

TWriteMacAddressReq.default = {0, 0, 0, 0, 0, 0, 0, 0, 0}

TWriteMacAddressReq.struct = {
    {name = 'FruId', is_array = false, struct = nil}, {name = 'MacId', is_array = false, struct = nil},
    {name = 'InterfaceType', is_array = false, struct = nil}, {name = 'MacAddress1', is_array = false, struct = nil},
    {name = 'MacAddress2', is_array = false, struct = nil}, {name = 'MacAddress3', is_array = false, struct = nil},
    {name = 'MacAddress4', is_array = false, struct = nil}, {name = 'MacAddress5', is_array = false, struct = nil},
    {name = 'MacAddress6', is_array = false, struct = nil}
}

function TWriteMacAddressReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruId', self.FruId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'MacId', self.MacId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'InterfaceType', self.InterfaceType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'MacAddress1', self.MacAddress1, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'MacAddress2', self.MacAddress2, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'MacAddress3', self.MacAddress3, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'MacAddress4', self.MacAddress4, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'MacAddress5', self.MacAddress5, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'MacAddress6', self.MacAddress6, 'uint8', false, errs, need_convert)

    TWriteMacAddressReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWriteMacAddressReq.proto_property, errs, need_convert)
    return self
end

function TWriteMacAddressReq:unpack(_)
    return self.FruId, self.MacId, self.InterfaceType, self.MacAddress1, self.MacAddress2, self.MacAddress3,
        self.MacAddress4, self.MacAddress5, self.MacAddress6
end

WriteMacAddress.WriteMacAddressReq = TWriteMacAddressReq

---@class NetworkAdapterIpmiCmds.WriteMacAddressRsp
---@field FruId integer
local TWriteMacAddressRsp = {}
TWriteMacAddressRsp.__index = TWriteMacAddressRsp
TWriteMacAddressRsp.group = {}

local function TWriteMacAddressRsp_from_obj(obj)
    return setmetatable(obj, TWriteMacAddressRsp)
end

function TWriteMacAddressRsp.new(FruId)
    return TWriteMacAddressRsp_from_obj({FruId = FruId})
end
---@param obj NetworkAdapterIpmiCmds.WriteMacAddressRsp
function TWriteMacAddressRsp:init_from_obj(obj)
    self.FruId = obj.FruId
end

function TWriteMacAddressRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWriteMacAddressRsp.group)
end

TWriteMacAddressRsp.from_obj = TWriteMacAddressRsp_from_obj

TWriteMacAddressRsp.proto_property = {'FruId'}

TWriteMacAddressRsp.default = {0}

TWriteMacAddressRsp.struct = {{name = 'FruId', is_array = false, struct = nil}}

function TWriteMacAddressRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruId', self.FruId, 'uint8', false, errs, need_convert)

    TWriteMacAddressRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWriteMacAddressRsp.proto_property, errs, need_convert)
    return self
end

function TWriteMacAddressRsp:unpack(_)
    return self.FruId
end

WriteMacAddress.WriteMacAddressRsp = TWriteMacAddressRsp

return WriteMacAddress
