--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetDpuForcePowerOnState = {}

---@class NetworkAdapterIpmiCmds.SetDpuForcePowerOnStateReq
local TSetDpuForcePowerOnStateReq = {}
TSetDpuForcePowerOnStateReq.__index = TSetDpuForcePowerOnStateReq
TSetDpuForcePowerOnStateReq.group = {}

local function TSetDpuForcePowerOnStateReq_from_obj(obj)
    return setmetatable(obj, TSetDpuForcePowerOnStateReq)
end

function TSetDpuForcePowerOnStateReq.new()
    return TSetDpuForcePowerOnStateReq_from_obj({})
end
---@param obj NetworkAdapterIpmiCmds.SetDpuForcePowerOnStateReq
function TSetDpuForcePowerOnStateReq:init_from_obj(obj)

end

function TSetDpuForcePowerOnStateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDpuForcePowerOnStateReq.group)
end

TSetDpuForcePowerOnStateReq.from_obj = TSetDpuForcePowerOnStateReq_from_obj

TSetDpuForcePowerOnStateReq.proto_property = {}

TSetDpuForcePowerOnStateReq.default = {}

TSetDpuForcePowerOnStateReq.struct = {}

function TSetDpuForcePowerOnStateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetDpuForcePowerOnStateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDpuForcePowerOnStateReq.proto_property, errs, need_convert)
    return self
end

function TSetDpuForcePowerOnStateReq:unpack(_)
end

SetDpuForcePowerOnState.SetDpuForcePowerOnStateReq = TSetDpuForcePowerOnStateReq

---@class NetworkAdapterIpmiCmds.SetDpuForcePowerOnStateRsp
---@field CompletionCode integer
local TSetDpuForcePowerOnStateRsp = {}
TSetDpuForcePowerOnStateRsp.__index = TSetDpuForcePowerOnStateRsp
TSetDpuForcePowerOnStateRsp.group = {}

local function TSetDpuForcePowerOnStateRsp_from_obj(obj)
    return setmetatable(obj, TSetDpuForcePowerOnStateRsp)
end

function TSetDpuForcePowerOnStateRsp.new(CompletionCode)
    return TSetDpuForcePowerOnStateRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj NetworkAdapterIpmiCmds.SetDpuForcePowerOnStateRsp
function TSetDpuForcePowerOnStateRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TSetDpuForcePowerOnStateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDpuForcePowerOnStateRsp.group)
end

TSetDpuForcePowerOnStateRsp.from_obj = TSetDpuForcePowerOnStateRsp_from_obj

TSetDpuForcePowerOnStateRsp.proto_property = {'CompletionCode'}

TSetDpuForcePowerOnStateRsp.default = {0}

TSetDpuForcePowerOnStateRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TSetDpuForcePowerOnStateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TSetDpuForcePowerOnStateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDpuForcePowerOnStateRsp.proto_property, errs, need_convert)
    return self
end

function TSetDpuForcePowerOnStateRsp:unpack(_)
    return self.CompletionCode
end

SetDpuForcePowerOnState.SetDpuForcePowerOnStateRsp = TSetDpuForcePowerOnStateRsp

return SetDpuForcePowerOnState
