--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetMacAddress = {}

---@class NetworkAdapterIpmiCmds.GetMacAddressReq
---@field FruId integer
---@field Data string
local TGetMacAddressReq = {}
TGetMacAddressReq.__index = TGetMacAddressReq
TGetMacAddressReq.group = {}

local function TGetMacAddressReq_from_obj(obj)
    return setmetatable(obj, TGetMacAddressReq)
end

function TGetMacAddressReq.new(FruId, Data)
    return TGetMacAddressReq_from_obj({FruId = FruId, Data = Data})
end
---@param obj NetworkAdapterIpmiCmds.GetMacAddressReq
function TGetMacAddressReq:init_from_obj(obj)
    self.FruId = obj.FruId
    self.Data = obj.Data
end

function TGetMacAddressReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetMacAddressReq.group)
end

TGetMacAddressReq.from_obj = TGetMacAddressReq_from_obj

TGetMacAddressReq.proto_property = {'FruId', 'Data'}

TGetMacAddressReq.default = {0, ''}

TGetMacAddressReq.struct = {
    {name = 'FruId', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TGetMacAddressReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruId', self.FruId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetMacAddressReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetMacAddressReq.proto_property, errs, need_convert)
    return self
end

function TGetMacAddressReq:unpack(_)
    return self.FruId, self.Data
end

GetMacAddress.GetMacAddressReq = TGetMacAddressReq

---@class NetworkAdapterIpmiCmds.GetMacAddressRsp
---@field CompletionCode integer
---@field FruId integer
---@field MacId integer
---@field InterfaceType integer
---@field MacAddr string
local TGetMacAddressRsp = {}
TGetMacAddressRsp.__index = TGetMacAddressRsp
TGetMacAddressRsp.group = {}

local function TGetMacAddressRsp_from_obj(obj)
    return setmetatable(obj, TGetMacAddressRsp)
end

function TGetMacAddressRsp.new(CompletionCode, FruId, MacId, InterfaceType, MacAddr)
    return TGetMacAddressRsp_from_obj({
        CompletionCode = CompletionCode,
        FruId = FruId,
        MacId = MacId,
        InterfaceType = InterfaceType,
        MacAddr = MacAddr
    })
end
---@param obj NetworkAdapterIpmiCmds.GetMacAddressRsp
function TGetMacAddressRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.FruId = obj.FruId
    self.MacId = obj.MacId
    self.InterfaceType = obj.InterfaceType
    self.MacAddr = obj.MacAddr
end

function TGetMacAddressRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetMacAddressRsp.group)
end

TGetMacAddressRsp.from_obj = TGetMacAddressRsp_from_obj

TGetMacAddressRsp.proto_property = {'CompletionCode', 'FruId', 'MacId', 'InterfaceType', 'MacAddr'}

TGetMacAddressRsp.default = {0, 0, 0, 0, ''}

TGetMacAddressRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'FruId', is_array = false, struct = nil},
    {name = 'MacId', is_array = false, struct = nil}, {name = 'InterfaceType', is_array = false, struct = nil},
    {name = 'MacAddr', is_array = false, struct = nil}
}

function TGetMacAddressRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FruId', self.FruId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'MacId', self.MacId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'InterfaceType', self.InterfaceType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'MacAddr', self.MacAddr, 'string', false, errs, need_convert)

    TGetMacAddressRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetMacAddressRsp.proto_property, errs, need_convert)
    return self
end

function TGetMacAddressRsp:unpack(_)
    return self.CompletionCode, self.FruId, self.MacId, self.InterfaceType, self.MacAddr
end

GetMacAddress.GetMacAddressRsp = TGetMacAddressRsp

return GetMacAddress
