--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetIPMCConfiguration = {}

---@class NetworkAdapterIpmiCmds.GetIPMCConfigurationReq
---@field ManuId integer
---@field Offset integer
---@field Length integer
local TGetIPMCConfigurationReq = {}
TGetIPMCConfigurationReq.__index = TGetIPMCConfigurationReq
TGetIPMCConfigurationReq.group = {}

local function TGetIPMCConfigurationReq_from_obj(obj)
    return setmetatable(obj, TGetIPMCConfigurationReq)
end

function TGetIPMCConfigurationReq.new(ManuId, Offset, Length)
    return TGetIPMCConfigurationReq_from_obj({ManuId = ManuId, Offset = Offset, Length = Length})
end
---@param obj NetworkAdapterIpmiCmds.GetIPMCConfigurationReq
function TGetIPMCConfigurationReq:init_from_obj(obj)
    self.ManuId = obj.ManuId
    self.Offset = obj.Offset
    self.Length = obj.Length
end

function TGetIPMCConfigurationReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetIPMCConfigurationReq.group)
end

TGetIPMCConfigurationReq.from_obj = TGetIPMCConfigurationReq_from_obj

TGetIPMCConfigurationReq.proto_property = {'ManuId', 'Offset', 'Length'}

TGetIPMCConfigurationReq.default = {0, 0, 0}

TGetIPMCConfigurationReq.struct = {
    {name = 'ManuId', is_array = false, struct = nil}, {name = 'Offset', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}
}

function TGetIPMCConfigurationReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManuId', self.ManuId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)

    TGetIPMCConfigurationReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetIPMCConfigurationReq.proto_property, errs, need_convert)
    return self
end

function TGetIPMCConfigurationReq:unpack(_)
    return self.ManuId, self.Offset, self.Length
end

GetIPMCConfiguration.GetIPMCConfigurationReq = TGetIPMCConfigurationReq

---@class NetworkAdapterIpmiCmds.GetIPMCConfigurationRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Data integer[]
local TGetIPMCConfigurationRsp = {}
TGetIPMCConfigurationRsp.__index = TGetIPMCConfigurationRsp
TGetIPMCConfigurationRsp.group = {}

local function TGetIPMCConfigurationRsp_from_obj(obj)
    return setmetatable(obj, TGetIPMCConfigurationRsp)
end

function TGetIPMCConfigurationRsp.new(CompletionCode, ManufactureId, Data)
    return TGetIPMCConfigurationRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Data = Data
    })
end
---@param obj NetworkAdapterIpmiCmds.GetIPMCConfigurationRsp
function TGetIPMCConfigurationRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Data = obj.Data
end

function TGetIPMCConfigurationRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetIPMCConfigurationRsp.group)
end

TGetIPMCConfigurationRsp.from_obj = TGetIPMCConfigurationRsp_from_obj

TGetIPMCConfigurationRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Data'}

TGetIPMCConfigurationRsp.default = {0, 0, {}}

TGetIPMCConfigurationRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Data', is_array = true, struct = nil}
}

function TGetIPMCConfigurationRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'Data', self.Data, 'uint8', false, errs, need_convert)

    TGetIPMCConfigurationRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetIPMCConfigurationRsp.proto_property, errs, need_convert)
    return self
end

function TGetIPMCConfigurationRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Data
end

GetIPMCConfiguration.GetIPMCConfigurationRsp = TGetIPMCConfigurationRsp

return GetIPMCConfiguration
