--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetBusinessPortInfo = {}

---@class NetworkAdapterIpmiCmds.GetBusinessPortInfoReq
---@field ManuId integer
---@field Reserved integer
---@field PortNo integer
local TGetBusinessPortInfoReq = {}
TGetBusinessPortInfoReq.__index = TGetBusinessPortInfoReq
TGetBusinessPortInfoReq.group = {}

local function TGetBusinessPortInfoReq_from_obj(obj)
    return setmetatable(obj, TGetBusinessPortInfoReq)
end

function TGetBusinessPortInfoReq.new(ManuId, Reserved, PortNo)
    return TGetBusinessPortInfoReq_from_obj({ManuId = ManuId, Reserved = Reserved, PortNo = PortNo})
end
---@param obj NetworkAdapterIpmiCmds.GetBusinessPortInfoReq
function TGetBusinessPortInfoReq:init_from_obj(obj)
    self.ManuId = obj.ManuId
    self.Reserved = obj.Reserved
    self.PortNo = obj.PortNo
end

function TGetBusinessPortInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetBusinessPortInfoReq.group)
end

TGetBusinessPortInfoReq.from_obj = TGetBusinessPortInfoReq_from_obj

TGetBusinessPortInfoReq.proto_property = {'ManuId', 'Reserved', 'PortNo'}

TGetBusinessPortInfoReq.default = {0, 0, 0}

TGetBusinessPortInfoReq.struct = {
    {name = 'ManuId', is_array = false, struct = nil}, {name = 'Reserved', is_array = false, struct = nil},
    {name = 'PortNo', is_array = false, struct = nil}
}

function TGetBusinessPortInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManuId', self.ManuId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PortNo', self.PortNo, 'uint16', false, errs, need_convert)

    TGetBusinessPortInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetBusinessPortInfoReq.proto_property, errs, need_convert)
    return self
end

function TGetBusinessPortInfoReq:unpack(_)
    return self.ManuId, self.Reserved, self.PortNo
end

GetBusinessPortInfo.GetBusinessPortInfoReq = TGetBusinessPortInfoReq

---@class NetworkAdapterIpmiCmds.GetBusinessPortInfoRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field PortNo integer
---@field TotalLen integer
---@field Data string
local TGetBusinessPortInfoRsp = {}
TGetBusinessPortInfoRsp.__index = TGetBusinessPortInfoRsp
TGetBusinessPortInfoRsp.group = {}

local function TGetBusinessPortInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetBusinessPortInfoRsp)
end

function TGetBusinessPortInfoRsp.new(CompletionCode, ManufactureId, PortNo, TotalLen, Data)
    return TGetBusinessPortInfoRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        PortNo = PortNo,
        TotalLen = TotalLen,
        Data = Data
    })
end
---@param obj NetworkAdapterIpmiCmds.GetBusinessPortInfoRsp
function TGetBusinessPortInfoRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.PortNo = obj.PortNo
    self.TotalLen = obj.TotalLen
    self.Data = obj.Data
end

function TGetBusinessPortInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetBusinessPortInfoRsp.group)
end

TGetBusinessPortInfoRsp.from_obj = TGetBusinessPortInfoRsp_from_obj

TGetBusinessPortInfoRsp.proto_property = {'CompletionCode', 'ManufactureId', 'PortNo', 'TotalLen', 'Data'}

TGetBusinessPortInfoRsp.default = {0, 0, 0, 0, ''}

TGetBusinessPortInfoRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'PortNo', is_array = false, struct = nil}, {name = 'TotalLen', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TGetBusinessPortInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'PortNo', self.PortNo, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'TotalLen', self.TotalLen, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetBusinessPortInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetBusinessPortInfoRsp.proto_property, errs, need_convert)
    return self
end

function TGetBusinessPortInfoRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.PortNo, self.TotalLen, self.Data
end

GetBusinessPortInfo.GetBusinessPortInfoRsp = TGetBusinessPortInfoRsp

return GetBusinessPortInfo
