-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MVLANIPv4Address = {}

---@class MVLANIPv4Address.NetworkPortObjectName
---@field NetworkPortObjectName string
local TNetworkPortObjectName = {}
TNetworkPortObjectName.__index = TNetworkPortObjectName
TNetworkPortObjectName.group = {}

local function TNetworkPortObjectName_from_obj(obj)
    return setmetatable(obj, TNetworkPortObjectName)
end

function TNetworkPortObjectName.new(NetworkPortObjectName)
    return TNetworkPortObjectName_from_obj({NetworkPortObjectName = NetworkPortObjectName or [=[]=]})
end
---@param obj MVLANIPv4Address.NetworkPortObjectName
function TNetworkPortObjectName:init_from_obj(obj)
    self.NetworkPortObjectName = obj.NetworkPortObjectName or [=[]=]
end

function TNetworkPortObjectName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNetworkPortObjectName.group)
end

TNetworkPortObjectName.from_obj = TNetworkPortObjectName_from_obj

TNetworkPortObjectName.proto_property = {'NetworkPortObjectName'}

TNetworkPortObjectName.default = {''}

TNetworkPortObjectName.struct = {{name = 'NetworkPortObjectName', is_array = false, struct = nil}}

function TNetworkPortObjectName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NetworkPortObjectName', self.NetworkPortObjectName, 'string', false, errs, need_convert)

    TNetworkPortObjectName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNetworkPortObjectName.proto_property, errs, need_convert)
    return self
end

function TNetworkPortObjectName:unpack(_)
    return self.NetworkPortObjectName
end

MVLANIPv4Address.NetworkPortObjectName = TNetworkPortObjectName

---@class MVLANIPv4Address.NetworkAdapterObjectName
---@field NetworkAdapterObjectName string
local TNetworkAdapterObjectName = {}
TNetworkAdapterObjectName.__index = TNetworkAdapterObjectName
TNetworkAdapterObjectName.group = {}

local function TNetworkAdapterObjectName_from_obj(obj)
    return setmetatable(obj, TNetworkAdapterObjectName)
end

function TNetworkAdapterObjectName.new(NetworkAdapterObjectName)
    return TNetworkAdapterObjectName_from_obj({NetworkAdapterObjectName = NetworkAdapterObjectName or [=[]=]})
end
---@param obj MVLANIPv4Address.NetworkAdapterObjectName
function TNetworkAdapterObjectName:init_from_obj(obj)
    self.NetworkAdapterObjectName = obj.NetworkAdapterObjectName or [=[]=]
end

function TNetworkAdapterObjectName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNetworkAdapterObjectName.group)
end

TNetworkAdapterObjectName.from_obj = TNetworkAdapterObjectName_from_obj

TNetworkAdapterObjectName.proto_property = {'NetworkAdapterObjectName'}

TNetworkAdapterObjectName.default = {''}

TNetworkAdapterObjectName.struct = {{name = 'NetworkAdapterObjectName', is_array = false, struct = nil}}

function TNetworkAdapterObjectName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NetworkAdapterObjectName', self.NetworkAdapterObjectName, 'string', false, errs,
        need_convert)

    TNetworkAdapterObjectName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNetworkAdapterObjectName.proto_property, errs, need_convert)
    return self
end

function TNetworkAdapterObjectName:unpack(_)
    return self.NetworkAdapterObjectName
end

MVLANIPv4Address.NetworkAdapterObjectName = TNetworkAdapterObjectName

---@class MVLANIPv4Address.VLANId
---@field VLANId integer
local TVLANId = {}
TVLANId.__index = TVLANId
TVLANId.group = {}

local function TVLANId_from_obj(obj)
    return setmetatable(obj, TVLANId)
end

function TVLANId.new(VLANId)
    return TVLANId_from_obj({VLANId = VLANId})
end
---@param obj MVLANIPv4Address.VLANId
function TVLANId:init_from_obj(obj)
    self.VLANId = obj.VLANId
end

function TVLANId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVLANId.group)
end

TVLANId.from_obj = TVLANId_from_obj

TVLANId.proto_property = {'VLANId'}

TVLANId.default = {0}

TVLANId.struct = {{name = 'VLANId', is_array = false, struct = nil}}

function TVLANId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'VLANId', self.VLANId, 'uint16', false, errs, need_convert)

    TVLANId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVLANId.proto_property, errs, need_convert)
    return self
end

function TVLANId:unpack(_)
    return self.VLANId
end

MVLANIPv4Address.VLANId = TVLANId

---@class MVLANIPv4Address.NetworkAdapterId
---@field NetworkAdapterId string
local TNetworkAdapterId = {}
TNetworkAdapterId.__index = TNetworkAdapterId
TNetworkAdapterId.group = {}

local function TNetworkAdapterId_from_obj(obj)
    return setmetatable(obj, TNetworkAdapterId)
end

function TNetworkAdapterId.new(NetworkAdapterId)
    return TNetworkAdapterId_from_obj({NetworkAdapterId = NetworkAdapterId})
end
---@param obj MVLANIPv4Address.NetworkAdapterId
function TNetworkAdapterId:init_from_obj(obj)
    self.NetworkAdapterId = obj.NetworkAdapterId
end

function TNetworkAdapterId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNetworkAdapterId.group)
end

TNetworkAdapterId.from_obj = TNetworkAdapterId_from_obj

TNetworkAdapterId.proto_property = {'NetworkAdapterId'}

TNetworkAdapterId.default = {''}

TNetworkAdapterId.struct = {{name = 'NetworkAdapterId', is_array = false, struct = nil}}

function TNetworkAdapterId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'NetworkAdapterId', self.NetworkAdapterId, 'string', false, errs, need_convert)

    TNetworkAdapterId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNetworkAdapterId.proto_property, errs, need_convert)
    return self
end

function TNetworkAdapterId:unpack(_)
    return self.NetworkAdapterId
end

MVLANIPv4Address.NetworkAdapterId = TNetworkAdapterId

---@class MVLANIPv4Address.PortID
---@field PortID integer
local TPortID = {}
TPortID.__index = TPortID
TPortID.group = {}

local function TPortID_from_obj(obj)
    return setmetatable(obj, TPortID)
end

function TPortID.new(PortID)
    return TPortID_from_obj({PortID = PortID})
end
---@param obj MVLANIPv4Address.PortID
function TPortID:init_from_obj(obj)
    self.PortID = obj.PortID
end

function TPortID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPortID.group)
end

TPortID.from_obj = TPortID_from_obj

TPortID.proto_property = {'PortID'}

TPortID.default = {0}

TPortID.struct = {{name = 'PortID', is_array = false, struct = nil}}

function TPortID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'PortID', self.PortID, 'uint8', false, errs, need_convert)

    TPortID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPortID.proto_property, errs, need_convert)
    return self
end

function TPortID:unpack(_)
    return self.PortID
end

MVLANIPv4Address.PortID = TPortID

return MVLANIPv4Address
