-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MNetworkBonding = {}

---@class MNetworkBonding.Ports
---@field Ports string[]
local TPorts = {}
TPorts.__index = TPorts
TPorts.group = {}

local function TPorts_from_obj(obj)
    return setmetatable(obj, TPorts)
end

function TPorts.new(Ports)
    return TPorts_from_obj({Ports = Ports})
end
---@param obj MNetworkBonding.Ports
function TPorts:init_from_obj(obj)
    self.Ports = obj.Ports
end

function TPorts:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPorts.group)
end

TPorts.from_obj = TPorts_from_obj

TPorts.proto_property = {'Ports'}

TPorts.default = {{}}

TPorts.struct = {{name = 'Ports', is_array = true, struct = nil}}

function TPorts:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'Ports', self.Ports, 'string', false, errs, need_convert)

    TPorts:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPorts.proto_property, errs, need_convert)
    return self
end

function TPorts:unpack(_)
    return self.Ports
end

MNetworkBonding.Ports = TPorts

return MNetworkBonding
