-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MNcsiNCInfo = {}

---@class MNcsiNCInfo.NcsiEthId
---@field NcsiEthId integer
local TNcsiEthId = {}
TNcsiEthId.__index = TNcsiEthId
TNcsiEthId.group = {}

local function TNcsiEthId_from_obj(obj)
    return setmetatable(obj, TNcsiEthId)
end

function TNcsiEthId.new(NcsiEthId)
    return TNcsiEthId_from_obj({NcsiEthId = NcsiEthId})
end
---@param obj MNcsiNCInfo.NcsiEthId
function TNcsiEthId:init_from_obj(obj)
    self.NcsiEthId = obj.NcsiEthId
end

function TNcsiEthId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNcsiEthId.group)
end

TNcsiEthId.from_obj = TNcsiEthId_from_obj

TNcsiEthId.proto_property = {'NcsiEthId'}

TNcsiEthId.default = {0}

TNcsiEthId.struct = {{name = 'NcsiEthId', is_array = false, struct = nil}}

function TNcsiEthId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NcsiEthId', self.NcsiEthId, 'uint8', false, errs, need_convert)

    TNcsiEthId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNcsiEthId.proto_property, errs, need_convert)
    return self
end

function TNcsiEthId:unpack(_)
    return self.NcsiEthId
end

MNcsiNCInfo.NcsiEthId = TNcsiEthId

---@class MNcsiNCInfo.MultiVlanState
---@field MultiVlanState boolean
local TMultiVlanState = {}
TMultiVlanState.__index = TMultiVlanState
TMultiVlanState.group = {}

local function TMultiVlanState_from_obj(obj)
    return setmetatable(obj, TMultiVlanState)
end

function TMultiVlanState.new(MultiVlanState)
    return TMultiVlanState_from_obj({MultiVlanState = MultiVlanState})
end
---@param obj MNcsiNCInfo.MultiVlanState
function TMultiVlanState:init_from_obj(obj)
    self.MultiVlanState = obj.MultiVlanState
end

function TMultiVlanState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMultiVlanState.group)
end

TMultiVlanState.from_obj = TMultiVlanState_from_obj

TMultiVlanState.proto_property = {'MultiVlanState'}

TMultiVlanState.default = {false}

TMultiVlanState.struct = {{name = 'MultiVlanState', is_array = false, struct = nil}}

function TMultiVlanState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MultiVlanState', self.MultiVlanState, 'bool', false, errs, need_convert)

    TMultiVlanState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMultiVlanState.proto_property, errs, need_convert)
    return self
end

function TMultiVlanState:unpack(_)
    return self.MultiVlanState
end

MNcsiNCInfo.MultiVlanState = TMultiVlanState

---@class MNcsiNCInfo.NcsiCableSwitch
---@field NcsiCableSwitch integer
local TNcsiCableSwitch = {}
TNcsiCableSwitch.__index = TNcsiCableSwitch
TNcsiCableSwitch.group = {}

local function TNcsiCableSwitch_from_obj(obj)
    return setmetatable(obj, TNcsiCableSwitch)
end

function TNcsiCableSwitch.new(NcsiCableSwitch)
    return TNcsiCableSwitch_from_obj({NcsiCableSwitch = NcsiCableSwitch})
end
---@param obj MNcsiNCInfo.NcsiCableSwitch
function TNcsiCableSwitch:init_from_obj(obj)
    self.NcsiCableSwitch = obj.NcsiCableSwitch
end

function TNcsiCableSwitch:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNcsiCableSwitch.group)
end

TNcsiCableSwitch.from_obj = TNcsiCableSwitch_from_obj

TNcsiCableSwitch.proto_property = {'NcsiCableSwitch'}

TNcsiCableSwitch.default = {0}

TNcsiCableSwitch.struct = {{name = 'NcsiCableSwitch', is_array = false, struct = nil}}

function TNcsiCableSwitch:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NcsiCableSwitch', self.NcsiCableSwitch, 'uint8', false, errs, need_convert)

    TNcsiCableSwitch:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNcsiCableSwitch.proto_property, errs, need_convert)
    return self
end

function TNcsiCableSwitch:unpack(_)
    return self.NcsiCableSwitch
end

MNcsiNCInfo.NcsiCableSwitch = TNcsiCableSwitch

---@class MNcsiNCInfo.NcsiCablePresent
---@field NcsiCablePresent integer
local TNcsiCablePresent = {}
TNcsiCablePresent.__index = TNcsiCablePresent
TNcsiCablePresent.group = {}

local function TNcsiCablePresent_from_obj(obj)
    return setmetatable(obj, TNcsiCablePresent)
end

function TNcsiCablePresent.new(NcsiCablePresent)
    return TNcsiCablePresent_from_obj({NcsiCablePresent = NcsiCablePresent})
end
---@param obj MNcsiNCInfo.NcsiCablePresent
function TNcsiCablePresent:init_from_obj(obj)
    self.NcsiCablePresent = obj.NcsiCablePresent
end

function TNcsiCablePresent:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNcsiCablePresent.group)
end

TNcsiCablePresent.from_obj = TNcsiCablePresent_from_obj

TNcsiCablePresent.proto_property = {'NcsiCablePresent'}

TNcsiCablePresent.default = {0}

TNcsiCablePresent.struct = {{name = 'NcsiCablePresent', is_array = false, struct = nil}}

function TNcsiCablePresent:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NcsiCablePresent', self.NcsiCablePresent, 'uint8', false, errs, need_convert)

    TNcsiCablePresent:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNcsiCablePresent.proto_property, errs, need_convert)
    return self
end

function TNcsiCablePresent:unpack(_)
    return self.NcsiCablePresent
end

MNcsiNCInfo.NcsiCablePresent = TNcsiCablePresent

---@class MNcsiNCInfo.VlanId
---@field VlanId integer
local TVlanId = {}
TVlanId.__index = TVlanId
TVlanId.group = {}

local function TVlanId_from_obj(obj)
    return setmetatable(obj, TVlanId)
end

function TVlanId.new(VlanId)
    return TVlanId_from_obj({VlanId = VlanId})
end
---@param obj MNcsiNCInfo.VlanId
function TVlanId:init_from_obj(obj)
    self.VlanId = obj.VlanId
end

function TVlanId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVlanId.group)
end

TVlanId.from_obj = TVlanId_from_obj

TVlanId.proto_property = {'VlanId'}

TVlanId.default = {0}

TVlanId.struct = {{name = 'VlanId', is_array = false, struct = nil}}

function TVlanId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'VlanId', self.VlanId, 'uint16', false, errs, need_convert)

    TVlanId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVlanId.proto_property, errs, need_convert)
    return self
end

function TVlanId:unpack(_)
    return self.VlanId
end

MNcsiNCInfo.VlanId = TVlanId

---@class MNcsiNCInfo.VlanState
---@field VlanState boolean
local TVlanState = {}
TVlanState.__index = TVlanState
TVlanState.group = {}

local function TVlanState_from_obj(obj)
    return setmetatable(obj, TVlanState)
end

function TVlanState.new(VlanState)
    return TVlanState_from_obj({VlanState = VlanState})
end
---@param obj MNcsiNCInfo.VlanState
function TVlanState:init_from_obj(obj)
    self.VlanState = obj.VlanState
end

function TVlanState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVlanState.group)
end

TVlanState.from_obj = TVlanState_from_obj

TVlanState.proto_property = {'VlanState'}

TVlanState.default = {false}

TVlanState.struct = {{name = 'VlanState', is_array = false, struct = nil}}

function TVlanState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'VlanState', self.VlanState, 'bool', false, errs, need_convert)

    TVlanState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVlanState.proto_property, errs, need_convert)
    return self
end

function TVlanState:unpack(_)
    return self.VlanState
end

MNcsiNCInfo.VlanState = TVlanState

---@class MNcsiNCInfo.Mac
---@field Mac string
local TMac = {}
TMac.__index = TMac
TMac.group = {}

local function TMac_from_obj(obj)
    return setmetatable(obj, TMac)
end

function TMac.new(Mac)
    return TMac_from_obj({Mac = Mac})
end
---@param obj MNcsiNCInfo.Mac
function TMac:init_from_obj(obj)
    self.Mac = obj.Mac
end

function TMac:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMac.group)
end

TMac.from_obj = TMac_from_obj

TMac.proto_property = {'Mac'}

TMac.default = {''}

TMac.struct = {{name = 'Mac', is_array = false, struct = nil}}

function TMac:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Mac', self.Mac, 'string', false, errs, need_convert)

    TMac:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMac.proto_property, errs, need_convert)
    return self
end

function TMac:unpack(_)
    return self.Mac
end

MNcsiNCInfo.Mac = TMac

---@class MNcsiNCInfo.ActivePort
---@field ActivePort integer
local TActivePort = {}
TActivePort.__index = TActivePort
TActivePort.group = {}

local function TActivePort_from_obj(obj)
    return setmetatable(obj, TActivePort)
end

function TActivePort.new(ActivePort)
    return TActivePort_from_obj({ActivePort = ActivePort})
end
---@param obj MNcsiNCInfo.ActivePort
function TActivePort:init_from_obj(obj)
    self.ActivePort = obj.ActivePort
end

function TActivePort:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TActivePort.group)
end

TActivePort.from_obj = TActivePort_from_obj

TActivePort.proto_property = {'ActivePort'}

TActivePort.default = {0}

TActivePort.struct = {{name = 'ActivePort', is_array = false, struct = nil}}

function TActivePort:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ActivePort', self.ActivePort, 'uint8', false, errs, need_convert)

    TActivePort:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TActivePort.proto_property, errs, need_convert)
    return self
end

function TActivePort:unpack(_)
    return self.ActivePort
end

MNcsiNCInfo.ActivePort = TActivePort

---@class MNcsiNCInfo.PortNum
---@field PortNum integer
local TPortNum = {}
TPortNum.__index = TPortNum
TPortNum.group = {}

local function TPortNum_from_obj(obj)
    return setmetatable(obj, TPortNum)
end

function TPortNum.new(PortNum)
    return TPortNum_from_obj({PortNum = PortNum})
end
---@param obj MNcsiNCInfo.PortNum
function TPortNum:init_from_obj(obj)
    self.PortNum = obj.PortNum
end

function TPortNum:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPortNum.group)
end

TPortNum.from_obj = TPortNum_from_obj

TPortNum.proto_property = {'PortNum'}

TPortNum.default = {0}

TPortNum.struct = {{name = 'PortNum', is_array = false, struct = nil}}

function TPortNum:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PortNum', self.PortNum, 'uint8', false, errs, need_convert)

    TPortNum:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPortNum.proto_property, errs, need_convert)
    return self
end

function TPortNum:unpack(_)
    return self.PortNum
end

MNcsiNCInfo.PortNum = TPortNum

---@class MNcsiNCInfo.ActiveStatus
---@field ActiveStatus boolean
local TActiveStatus = {}
TActiveStatus.__index = TActiveStatus
TActiveStatus.group = {}

local function TActiveStatus_from_obj(obj)
    return setmetatable(obj, TActiveStatus)
end

function TActiveStatus.new(ActiveStatus)
    return TActiveStatus_from_obj({ActiveStatus = ActiveStatus})
end
---@param obj MNcsiNCInfo.ActiveStatus
function TActiveStatus:init_from_obj(obj)
    self.ActiveStatus = obj.ActiveStatus
end

function TActiveStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TActiveStatus.group)
end

TActiveStatus.from_obj = TActiveStatus_from_obj

TActiveStatus.proto_property = {'ActiveStatus'}

TActiveStatus.default = {false}

TActiveStatus.struct = {{name = 'ActiveStatus', is_array = false, struct = nil}}

function TActiveStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ActiveStatus', self.ActiveStatus, 'bool', false, errs, need_convert)

    TActiveStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TActiveStatus.proto_property, errs, need_convert)
    return self
end

function TActiveStatus:unpack(_)
    return self.ActiveStatus
end

MNcsiNCInfo.ActiveStatus = TActiveStatus

---@class MNcsiNCInfo.EthId
---@field EthId integer
local TEthId = {}
TEthId.__index = TEthId
TEthId.group = {}

local function TEthId_from_obj(obj)
    return setmetatable(obj, TEthId)
end

function TEthId.new(EthId)
    return TEthId_from_obj({EthId = EthId})
end
---@param obj MNcsiNCInfo.EthId
function TEthId:init_from_obj(obj)
    self.EthId = obj.EthId
end

function TEthId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEthId.group)
end

TEthId.from_obj = TEthId_from_obj

TEthId.proto_property = {'EthId'}

TEthId.default = {0}

TEthId.struct = {{name = 'EthId', is_array = false, struct = nil}}

function TEthId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EthId', self.EthId, 'uint8', false, errs, need_convert)

    TEthId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEthId.proto_property, errs, need_convert)
    return self
end

function TEthId:unpack(_)
    return self.EthId
end

MNcsiNCInfo.EthId = TEthId

---@class MNcsiNCInfo.Type
---@field Type string
local TType = {}
TType.__index = TType
TType.group = {}

local function TType_from_obj(obj)
    return setmetatable(obj, TType)
end

function TType.new(Type)
    return TType_from_obj({Type = Type})
end
---@param obj MNcsiNCInfo.Type
function TType:init_from_obj(obj)
    self.Type = obj.Type
end

function TType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TType.group)
end

TType.from_obj = TType_from_obj

TType.proto_property = {'Type'}

TType.default = {''}

TType.struct = {{name = 'Type', is_array = false, struct = nil}}

function TType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Type', self.Type, 'string', false, errs, need_convert)

    TType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TType.proto_property, errs, need_convert)
    return self
end

function TType:unpack(_)
    return self.Type
end

MNcsiNCInfo.Type = TType

---@class MNcsiNCInfo.DeviceType
---@field DeviceType integer
local TDeviceType = {}
TDeviceType.__index = TDeviceType
TDeviceType.group = {}

local function TDeviceType_from_obj(obj)
    return setmetatable(obj, TDeviceType)
end

function TDeviceType.new(DeviceType)
    return TDeviceType_from_obj({DeviceType = DeviceType})
end
---@param obj MNcsiNCInfo.DeviceType
function TDeviceType:init_from_obj(obj)
    self.DeviceType = obj.DeviceType
end

function TDeviceType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeviceType.group)
end

TDeviceType.from_obj = TDeviceType_from_obj

TDeviceType.proto_property = {'DeviceType'}

TDeviceType.default = {0}

TDeviceType.struct = {{name = 'DeviceType', is_array = false, struct = nil}}

function TDeviceType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DeviceType', self.DeviceType, 'uint8', false, errs, need_convert)

    TDeviceType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeviceType.proto_property, errs, need_convert)
    return self
end

function TDeviceType:unpack(_)
    return self.DeviceType
end

MNcsiNCInfo.DeviceType = TDeviceType

---@class MNcsiNCInfo.SlotId
---@field SlotId integer
local TSlotId = {}
TSlotId.__index = TSlotId
TSlotId.group = {}

local function TSlotId_from_obj(obj)
    return setmetatable(obj, TSlotId)
end

function TSlotId.new(SlotId)
    return TSlotId_from_obj({SlotId = SlotId})
end
---@param obj MNcsiNCInfo.SlotId
function TSlotId:init_from_obj(obj)
    self.SlotId = obj.SlotId
end

function TSlotId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlotId.group)
end

TSlotId.from_obj = TSlotId_from_obj

TSlotId.proto_property = {'SlotId'}

TSlotId.default = {0}

TSlotId.struct = {{name = 'SlotId', is_array = false, struct = nil}}

function TSlotId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SlotId', self.SlotId, 'uint8', false, errs, need_convert)

    TSlotId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlotId.proto_property, errs, need_convert)
    return self
end

function TSlotId:unpack(_)
    return self.SlotId
end

MNcsiNCInfo.SlotId = TSlotId

---@class MNcsiNCInfo.SystemId
---@field SystemId integer
local TSystemId = {}
TSystemId.__index = TSystemId
TSystemId.group = {}

local function TSystemId_from_obj(obj)
    return setmetatable(obj, TSystemId)
end

function TSystemId.new(SystemId)
    return TSystemId_from_obj({SystemId = SystemId})
end
---@param obj MNcsiNCInfo.SystemId
function TSystemId:init_from_obj(obj)
    self.SystemId = obj.SystemId
end

function TSystemId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSystemId.group)
end

TSystemId.from_obj = TSystemId_from_obj

TSystemId.proto_property = {'SystemId'}

TSystemId.default = {0}

TSystemId.struct = {{name = 'SystemId', is_array = false, struct = nil}}

function TSystemId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemId', self.SystemId, 'uint8', false, errs, need_convert)

    TSystemId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSystemId.proto_property, errs, need_convert)
    return self
end

function TSystemId:unpack(_)
    return self.SystemId
end

MNcsiNCInfo.SystemId = TSystemId

---@class MNcsiNCInfo.Enable
---@field Enable boolean
local TEnable = {}
TEnable.__index = TEnable
TEnable.group = {}

local function TEnable_from_obj(obj)
    return setmetatable(obj, TEnable)
end

function TEnable.new(Enable)
    return TEnable_from_obj({Enable = Enable})
end
---@param obj MNcsiNCInfo.Enable
function TEnable:init_from_obj(obj)
    self.Enable = obj.Enable
end

function TEnable:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEnable.group)
end

TEnable.from_obj = TEnable_from_obj

TEnable.proto_property = {'Enable'}

TEnable.default = {false}

TEnable.struct = {{name = 'Enable', is_array = false, struct = nil}}

function TEnable:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Enable', self.Enable, 'bool', false, errs, need_convert)

    TEnable:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEnable.proto_property, errs, need_convert)
    return self
end

function TEnable:unpack(_)
    return self.Enable
end

MNcsiNCInfo.Enable = TEnable

---@class MNcsiNCInfo.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj MNcsiNCInfo.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'uint8', false, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

MNcsiNCInfo.Id = TId

return MNcsiNCInfo
