-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MNCSIChannelMgmt = {}

---@class MNCSIChannelMgmt.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj MNCSIChannelMgmt.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'uint8', false, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

MNCSIChannelMgmt.Id = TId

---@class MNCSIChannelMgmt.NCSIChannel
---@field NCSIChannel integer
local TNCSIChannel = {}
TNCSIChannel.__index = TNCSIChannel
TNCSIChannel.group = {}

local function TNCSIChannel_from_obj(obj)
    return setmetatable(obj, TNCSIChannel)
end

function TNCSIChannel.new(NCSIChannel)
    return TNCSIChannel_from_obj({NCSIChannel = NCSIChannel})
end
---@param obj MNCSIChannelMgmt.NCSIChannel
function TNCSIChannel:init_from_obj(obj)
    self.NCSIChannel = obj.NCSIChannel
end

function TNCSIChannel:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNCSIChannel.group)
end

TNCSIChannel.from_obj = TNCSIChannel_from_obj

TNCSIChannel.proto_property = {'NCSIChannel'}

TNCSIChannel.default = {0}

TNCSIChannel.struct = {{name = 'NCSIChannel', is_array = false, struct = nil}}

function TNCSIChannel:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NCSIChannel', self.NCSIChannel, 'uint8', false, errs, need_convert)

    TNCSIChannel:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNCSIChannel.proto_property, errs, need_convert)
    return self
end

function TNCSIChannel:unpack(_)
    return self.NCSIChannel
end

MNCSIChannelMgmt.NCSIChannel = TNCSIChannel

---@class MNCSIChannelMgmt.OCP2Presence
---@field OCP2Presence integer
local TOCP2Presence = {}
TOCP2Presence.__index = TOCP2Presence
TOCP2Presence.group = {}

local function TOCP2Presence_from_obj(obj)
    return setmetatable(obj, TOCP2Presence)
end

function TOCP2Presence.new(OCP2Presence)
    return TOCP2Presence_from_obj({OCP2Presence = OCP2Presence})
end
---@param obj MNCSIChannelMgmt.OCP2Presence
function TOCP2Presence:init_from_obj(obj)
    self.OCP2Presence = obj.OCP2Presence
end

function TOCP2Presence:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOCP2Presence.group)
end

TOCP2Presence.from_obj = TOCP2Presence_from_obj

TOCP2Presence.proto_property = {'OCP2Presence'}

TOCP2Presence.default = {0}

TOCP2Presence.struct = {{name = 'OCP2Presence', is_array = false, struct = nil}}

function TOCP2Presence:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OCP2Presence', self.OCP2Presence, 'uint8', false, errs, need_convert)

    TOCP2Presence:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOCP2Presence.proto_property, errs, need_convert)
    return self
end

function TOCP2Presence:unpack(_)
    return self.OCP2Presence
end

MNCSIChannelMgmt.OCP2Presence = TOCP2Presence

---@class MNCSIChannelMgmt.OCP1Presence
---@field OCP1Presence integer
local TOCP1Presence = {}
TOCP1Presence.__index = TOCP1Presence
TOCP1Presence.group = {}

local function TOCP1Presence_from_obj(obj)
    return setmetatable(obj, TOCP1Presence)
end

function TOCP1Presence.new(OCP1Presence)
    return TOCP1Presence_from_obj({OCP1Presence = OCP1Presence})
end
---@param obj MNCSIChannelMgmt.OCP1Presence
function TOCP1Presence:init_from_obj(obj)
    self.OCP1Presence = obj.OCP1Presence
end

function TOCP1Presence:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOCP1Presence.group)
end

TOCP1Presence.from_obj = TOCP1Presence_from_obj

TOCP1Presence.proto_property = {'OCP1Presence'}

TOCP1Presence.default = {0}

TOCP1Presence.struct = {{name = 'OCP1Presence', is_array = false, struct = nil}}

function TOCP1Presence:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OCP1Presence', self.OCP1Presence, 'uint8', false, errs, need_convert)

    TOCP1Presence:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOCP1Presence.proto_property, errs, need_convert)
    return self
end

function TOCP1Presence:unpack(_)
    return self.OCP1Presence
end

MNCSIChannelMgmt.OCP1Presence = TOCP1Presence

---@class MNCSIChannelMgmt.PCIePresence
---@field PCIePresence integer
local TPCIePresence = {}
TPCIePresence.__index = TPCIePresence
TPCIePresence.group = {}

local function TPCIePresence_from_obj(obj)
    return setmetatable(obj, TPCIePresence)
end

function TPCIePresence.new(PCIePresence)
    return TPCIePresence_from_obj({PCIePresence = PCIePresence})
end
---@param obj MNCSIChannelMgmt.PCIePresence
function TPCIePresence:init_from_obj(obj)
    self.PCIePresence = obj.PCIePresence
end

function TPCIePresence:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPCIePresence.group)
end

TPCIePresence.from_obj = TPCIePresence_from_obj

TPCIePresence.proto_property = {'PCIePresence'}

TPCIePresence.default = {0}

TPCIePresence.struct = {{name = 'PCIePresence', is_array = false, struct = nil}}

function TPCIePresence:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PCIePresence', self.PCIePresence, 'uint8', false, errs, need_convert)

    TPCIePresence:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPCIePresence.proto_property, errs, need_convert)
    return self
end

function TPCIePresence:unpack(_)
    return self.PCIePresence
end

MNCSIChannelMgmt.PCIePresence = TPCIePresence

return MNCSIChannelMgmt
