# network_adapter

## 1 功能简介
network_adapter主要负责网卡信息的获取与管理，网口的NCSI功能；
网卡信息的获取来源分为两种：1、带外通过mctp、smbus等协议获取 2、带内通过iBMA上报的信息获取；
网口的NCSI功能主要是对支持NCSI功能的网卡进行NCSI channel相关的配置，使得BMC能通过网卡的NCSI通路与外界通信.

### 1.1 代码目录结构

```
├── src
│   ├── lualib
│   │   ├── bma
│   │   │   ├── handles
│   │   │   │   ├── handler_base.lua               -- 处理BMA上报信息的基本函数
│   │   │   │   ├── handler_eth_statistics.lua     -- 处理BMA上报的网口统计信息，包含添加、更新、重置等操作
│   │   │   │   ├── handler_eth.lua                -- 处理BMA上报的网口基本信息，包含添加、更新、重置等操作
│   │   │   │   ├── handler_optical_diag.lua       -- 处理BMA上报的光模块诊断信息，包含添加、更新、重置等操作
│   │   │   │   ├── handler_optical.lua            -- 处理BMA上报的光模块基本信息，包含添加、更新、重置等操作
│   │   │   │   ├── handler_vlan.lua               -- 处理BMA上报的vlan信息，包含添加、更新、重置等操作
│   │   │   │   └── init.lua
│   │   │   ├── bma_mdb_mgmt.lua                   -- BMA资源管理的基本函数
│   │   │   └── init.lua
│   │   ├── debug
│   │   │   └── init.lua                           -- Ncsi over mctp的调试命令接口函数
│   │   ├── device
│   │   │   ├── class
│   │   │   │   ├── vlan
│   │   │   │   │   ├── init.lua                   -- VLAN对象的生成和基本信息获取设置
│   │   │   │   │   ├── ipv4_address.lua           -- VLAN的ipv4对象的生成和基本信息获取设置
│   │   │   │   │   └── ipv6_address.lua           -- VLAN的ipv6对象的生成和基本信息获取设置
│   │   │   │   ├── ipv4_address.lua               -- ipv4对象的生成和基本信息获取设置，对比上面少了VLAN
│   │   │   │   ├── ipv6_address.lua               -- ipv6对象的生成和基本信息获取设置，对比上面少了VLAN
│   │   │   │   ├── log_collector.lua              -- 日志收集相关，包含创建删除日志路径，日志收集信号触发
│   │   │   │   ├── network_adapter.lua            -- 网卡相关业务代码
│   │   │   │   ├── network_port.lua               -- 网口相关业务代码
│   │   │   │   └── optical_module.lua             -- 光模块相关业务代码
│   │   │   └── device_manager.lua                 -- 设备管理相关，包含method、ipmi命令的实现
│   │   ├── hardware_config
│   │   │   ├── CX4.lua                            -- CX4型号网卡（例如SP333、SP380）协议的使用，当前仅支持ncsi over mctp
│   │   │   ├── CX5.lua                            -- CX5型号网卡（例如SP351、SP382）协议的使用，当前仅支持ncsi over mctp，比CX4少了lldp
│   │   │   ├── CX6-DX.lua                         -- CX6-DX型号网卡（例如MCX623105AN-VDAT）协议的使用，与CX5完全一致
│   │   │   ├── Gemini.lua                         -- 尝试实现的SDI卡协议使用，std_smbus
│   │   │   ├── Hi182X.lua                         -- 182X系列网卡（SP580）协议的使用，支持smbus、ncsi/pldm over mctp
│   │   ├── imu
│   │   │   └── init.lua                           -- 从IMU获取PCI配置（含四元组）信息
│   │   ├── infrastructure
│   │   │   └── fructl.lua                         -- 获取fructl相关属性
│   │   ├── ncsi
│   │   │   ├── ncsi_comm.lua                      -- ncsi数据处理
│   │   │   ├── ncsi_core.lua                      -- ncsi协议接口，lua层处理c库接口
│   │   │   ├── ncsi_info.lua                      -- ncsi数据处理
│   │   │   ├── ncsi_lldp.lua                      -- lldp相关
│   │   │   ├── ncsi_service.lua                   -- ncsi初始化
│   │   │   └── ncsi_worker.lua                    -- 接收ncsi报文
│   │   ├── network_adapter_app.lua
│   ├── lualib-src
│   │   ├── ncsi_protocol
│   │   │   ├── CMakeLists.txt
│   │   │   ├── l_ncsi_protocol.c
│   │   └── CMakeLists.txt
│   └── service
│       └── main.lua
```
### 1.2 组件内主要类

1. NetworkAdapter：网卡设备信息
2. NetworkPort：网口设备信息
3. OpticalModule：光模块设备信息

NetworkAdapter拥有N个NetworkPort,
每个NetworkPort拥有0/1个OpticalModule,
通过 "@Parent"属性关联上

### 1.3 已适配网卡

1. NIC卡：板载网卡（Lom卡），灵活IO插卡
2. PCIE标卡：pcie网卡，需要Riser卡
3. SDI卡：比较特殊的智能网卡
4. OCP卡：由Open Compute Project（开放计算项目）推出的一种服务器网络接口卡
5. FC卡：光纤通道网卡

------------

## 2 关键特性
### 2.1 带外协议获取网卡信息
网卡协议：
[NCSI标准协议](https://www.dmtf.org/sites/default/files/standards/documents/DSP0222_1.0.0.pdf)
[mctp标准协议](https://www.dmtf.org/sites/default/files/standards/documents/DSP0236_1.3.1.pdf)
[LLDP官方网站](https://lldpd.github.io/)
[smbus协议](http://www.smbus.org/specs/)
**ncsi over mctp over pcie**
绝大多数网卡都支持该协议，可以获取以下信息：网卡的厂商信息、网卡芯片温度、网卡支持的最大带宽能力、网卡支持的最大速率能力、网卡实际带宽、网卡实际速率、网卡故障状态、网口的报文收发信息、网口的链路状态、网口总线信息、光模块温度、网口工作的mac地址、网口的永久mac地址、光模块信息等
**pldm over mctp over pcie**
仅涉及SDI5x/SDI6x收集黑匣子日志，未来计划FC卡通过该协议获取带外信息
**smbus**
仅182x网卡支持，可以获取以下信息：网卡健康状态、网卡故障状态、网卡芯片温度、网卡错误日志、网卡临终遗言日志、网卡运行日志、光模块温度、网口链接状态、网口mac地址等
**std_smbus**
当前预留，给后续SDI的mcu交互使用
**lldp**
接收LLDP信息，获取以下信息：从网络交换机接收到的Chassis ID、从网络交换机接收到的Chassis ID类型、从网络交换机接收到的端口ID、从网络交换机接收到的端口ID类型、网络交换机名称、从网络交换机接收到的VLAN ID
### 2.2 带内iBMA获取网卡信息
网口信息通过以下路径传递到network_adapter：带内->sms接口->host_agent->network_adapter，network_adapter通过监听host_agent与网口相关的资源树对象的变化，包括上树、修改、下树等信号，对网口信息进行汇总管理，其中信息包括但不限于网口连接状态、网口速率、网口IPv4、IPv6、mac地址、BDF、网卡固件版本、bond网口、bridge网口、光模块相关信息等

------------

### 2.3 网卡NCSI功能
部分网卡（PCIe卡、OCP卡）具备[NCSI](https://www.cnblogs.com/servlet-context/p/18317045)功能，简单理解即BMC可通过NCSI通道与网卡相连，实现BMC的带外通信。NCSI通道的报文分为两种：NCSI控制报文和网络透传报文，BMC想实现NCSI网口的带外通信功能，需要发送NCSI控制报文对网卡进行NCSI相关配置，以实现NCSI通道可以进行网络透传报文传输，另外还需要与bmc_network组件进行交互实现BMC的NCSI网口带外通信，主要分为以下几点：
1、初始化时识别网卡是否具备NCSI功能，识别到NCSI网口后上报给bmc_network注册一个NCSI网口，并实时更新NCSI网口的link状态变化
2、bmc_network切换到NCSI网口时发送信号给network_adapter，network_adapter将使能网口对应的NCSI通道的Tx，从NCSI网口切换回专用网口时，关闭原NCSI通道的Tx
3、bmc_network设置NCSI的VLAN后发送信号给network_adapter，network_adapter配置NCSI通道的vlan_filter，允许该VLAN的报文在NCSI通道传输

------------

## 3 对外接口
### 3.1 RPC方法
| 接口                                  | 方法                    | 描述                            |
| :----------------------------------: | :--------------------: | :----------------------------: |
| bmc.kepler.Systems.NetworkAdapters   | GetNetCardPortNum      | 获取网卡对应的网口数量             |
| bmc.kepler.Systems.NetworkAdapters   | GetPortSpeed           | 获取网口速率                     |
| bmc.kepler.Systems.NetworkAdapters   | GetNetworkAdapterNum   | 获取网卡数量                     |
| bmc.kepler.Systems.NetworkAdapters   | GetNetworkPortNum      | 获取网口总数量                    |
| bmc.kepler.Systems.NetworkAdapters   | GetPortSpeed           | 获取网口速率                     |
| bmc.kepler.Systems.NetworkAdapters   | GetBandwidthHistory    | 获取各个网卡的端口带宽占用率历史数据 |
| bmc.kepler.Systems.NetworkAdapters   | ClearBandwidthHistory  | 清空各个网卡的端口带宽占用率历史数据 |
| bmc.kepler.Systems.NetworkAdapters   | SetBandwidthThreshold  | 设置网络带宽占用率门限             |
| bmc.kepler.Systems.NetworkAdapter    | StartRemovingDevice    | 热拔出网卡                       |
| bmc.kepler.Systems.NetworkAdapter    | DumpBlackBox           | 收集SDI卡黑匣子日志               |
| bmc.kepler.Systems.NetworkPort       | Configure              | 配置网口信息                     |
| bmc.kepler.Systems.NetworkPort.VLANs | CreateVLAN             | 创建网口VLAN                     |
| bmc.kepler.Systems.NetworkPort.VLAN  | ConfigureVLAN          | 修改VLAN配置                     |
| bmc.kepler.Systems.NetworkPort.VLAN  | DeleteVLAN             | 删除VLAN                        |
| bmc.kepler.Systems.NetworkBondings   | CreateBond             | 创建bond                        |
| bmc.kepler.Systems.NetworkBondings   | DeleteBond             | 删除bond                        |
| bmc.kepler.Systems.NetworkBondings   | SetLinkMonitorPeriodMS | 设置连接状态检测周期               |
| bmc.kepler.Debug.Systems.NCSI        | SendCmdOverMCTP        | 用于调试NCSIoverMCTP命令         |
### 3.2 IPMI命令
| 命令                             | 描述                            |
| :-----------------------------: | :-----------------------------: |
| WriteMacAddress                 | 设置网口的mac地址你，通常是bios调用 |
| GetMacAddress                   | 获取网口的mac地址                 |
| GetBusinessPortInfo             | 查询网口的信息                    |
| SetIPMCConfiguration            | 设置NCSI channel的Rx             |
| GetIPMCConfiguration            | 获取NCSI channel的Rx             |
| GetNetworkAdapterModelByLOM     | 通过BDF进行板载网卡芯片型号查询     |
| GetNetworkAdapterModelByOCPCard | 通过BDF进行OCP扣卡芯片型号查询      |

## 4 配置介绍
### 4.1 关键类定义
#### 4.1.1 NetworkAdapter（网卡类）
| 属性                    | 说明                                                  |
| ---------------------- | ---------------------------------------------------- |
| ID                     | 全局唯一                                               |
| NodeId                 | 与ID相同，全局唯一                                      |
| SlotNumber             | 槽位号                                                |
| Name                   | 网卡名称                                               |
| Manufacturer           | 厂商名称                                               |
| Description            | 网卡描述                                               |
| DeviceLocator          | 网卡丝印信息                                           |
| Type                   | 网卡类型:1-Lom,3-PCIe,10-OCP                           |
| <strong>Model</strong> | <strong>芯片型号，芯片型号决定了该网卡支持哪些协议</strong> |
| ChipManufacturer       | 芯片厂商                                               |
| VendorID               | 厂商ID                                                |
| DeviceID               | 设备ID                                                |
| SubsystemVendorID      | 子系统厂商ID                                           |
| SubsystemDeviceID      | 子系统设备ID                                           |
| PCBVersion             | PCB版本                                               |
#### 4.1.1 NetworkPort（网口类）
| 属性                      | 说明                                                |
| ------------------------ | --------------------------------------------------- |
| <strong>@Parent</strong> | <strong>父对象（即网卡），表示该网口属于哪张网卡</strong> |
| NodeId                   | 全局唯一                                             |
| Name                     | 网口名称                                             |
| Type                     | 网口类型                                             |
| Name                     | 网卡名称                                             |
| PortID                   | 网口ID                                              |
| MACAddress               | MAC地址                                             |
| PermanentMACAddress      | 永久MAC地址                                          |
| LinkStatus               | 网口状态                                             |
