-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class thermal_mgmt.SetFanPWMRsp
---@field Result integer
local TSetFanPWMRsp = {}
TSetFanPWMRsp.__index = TSetFanPWMRsp
TSetFanPWMRsp.group = {}

local function TSetFanPWMRsp_from_obj(obj)
    return setmetatable(obj, TSetFanPWMRsp)
end

function TSetFanPWMRsp.new(Result)
    return TSetFanPWMRsp_from_obj({Result = Result})
end
---@param obj thermal_mgmt.SetFanPWMRsp
function TSetFanPWMRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TSetFanPWMRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetFanPWMRsp.group)
end

TSetFanPWMRsp.from_obj = TSetFanPWMRsp_from_obj

TSetFanPWMRsp.proto_property = {'Result'}

TSetFanPWMRsp.default = {0}

TSetFanPWMRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TSetFanPWMRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Result', self.Result, 'uint8', false, errs)

    TSetFanPWMRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetFanPWMRsp.proto_property, errs)
    return self
end

function TSetFanPWMRsp:unpack(_)
    return self.Result
end

msg.SetFanPWMRsp = TSetFanPWMRsp

---@class thermal_mgmt.SetFanPWMReq
---@field SystemId integer
---@field FanId integer
---@field PWM number
local TSetFanPWMReq = {}
TSetFanPWMReq.__index = TSetFanPWMReq
TSetFanPWMReq.group = {}

local function TSetFanPWMReq_from_obj(obj)
    return setmetatable(obj, TSetFanPWMReq)
end

function TSetFanPWMReq.new(SystemId, FanId, PWM)
    return TSetFanPWMReq_from_obj({SystemId = SystemId, FanId = FanId, PWM = PWM})
end
---@param obj thermal_mgmt.SetFanPWMReq
function TSetFanPWMReq:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.FanId = obj.FanId
    self.PWM = obj.PWM
end

function TSetFanPWMReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetFanPWMReq.group)
end

TSetFanPWMReq.from_obj = TSetFanPWMReq_from_obj

TSetFanPWMReq.proto_property = {'SystemId', 'FanId', 'PWM'}

TSetFanPWMReq.default = {0, 0, 0}

TSetFanPWMReq.struct = {
    {name = 'SystemId', is_array = false, struct = nil},
    {name = 'FanId', is_array = false, struct = nil}, {name = 'PWM', is_array = false, struct = nil}
}

function TSetFanPWMReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'SystemId', self.SystemId, 'uint8', false, errs)
    validate.Required(prefix .. 'FanId', self.FanId, 'uint8', false, errs)
    validate.Required(prefix .. 'PWM', self.PWM, 'double', false, errs)

    TSetFanPWMReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetFanPWMReq.proto_property, errs)
    return self
end

function TSetFanPWMReq:unpack(_)
    return self.SystemId, self.FanId, self.PWM
end

msg.SetFanPWMReq = TSetFanPWMReq

local thermal_mgmt = {}

local Mdb = require 'mc.mdb'

---@class thermal_mgmt: Table
thermal_mgmt.thermal_mgmt = Mdb.register_interface('bmc.kepler.thermal_mgmt', {}, {
    SetFanPWM = {'a{ss}yyd', 'y', msg.SetFanPWMReq, msg.SetFanPWMRsp}
}, {})
return thermal_mgmt
