-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class pcie_device.GetPCIeCardNumRsp
---@field PCIeCardNum integer
local TGetPCIeCardNumRsp = {}
TGetPCIeCardNumRsp.__index = TGetPCIeCardNumRsp
TGetPCIeCardNumRsp.group = {}

local function TGetPCIeCardNumRsp_from_obj(obj)
    return setmetatable(obj, TGetPCIeCardNumRsp)
end

function TGetPCIeCardNumRsp.new(PCIeCardNum)
    return TGetPCIeCardNumRsp_from_obj({PCIeCardNum = PCIeCardNum})
end
---@param obj pcie_device.GetPCIeCardNumRsp
function TGetPCIeCardNumRsp:init_from_obj(obj)
    self.PCIeCardNum = obj.PCIeCardNum
end

function TGetPCIeCardNumRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPCIeCardNumRsp.group)
end

TGetPCIeCardNumRsp.from_obj = TGetPCIeCardNumRsp_from_obj

TGetPCIeCardNumRsp.proto_property = {'PCIeCardNum'}

TGetPCIeCardNumRsp.default = {0}

TGetPCIeCardNumRsp.struct = {{name = 'PCIeCardNum', is_array = false, struct = nil}}

function TGetPCIeCardNumRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'PCIeCardNum', self.PCIeCardNum, 'uint32', false, errs)

    TGetPCIeCardNumRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPCIeCardNumRsp.proto_property, errs)
    return self
end

function TGetPCIeCardNumRsp:unpack(_)
    return self.PCIeCardNum
end

msg.GetPCIeCardNumRsp = TGetPCIeCardNumRsp

---@class pcie_device.GetPCIeCardNumReq
local TGetPCIeCardNumReq = {}
TGetPCIeCardNumReq.__index = TGetPCIeCardNumReq
TGetPCIeCardNumReq.group = {}

local function TGetPCIeCardNumReq_from_obj(obj)
    return setmetatable(obj, TGetPCIeCardNumReq)
end

function TGetPCIeCardNumReq.new()
    return TGetPCIeCardNumReq_from_obj({})
end
---@param obj pcie_device.GetPCIeCardNumReq
function TGetPCIeCardNumReq:init_from_obj(obj)

end

function TGetPCIeCardNumReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPCIeCardNumReq.group)
end

TGetPCIeCardNumReq.from_obj = TGetPCIeCardNumReq_from_obj

TGetPCIeCardNumReq.proto_property = {}

TGetPCIeCardNumReq.default = {}

TGetPCIeCardNumReq.struct = {}

function TGetPCIeCardNumReq:validate(prefix, errs)
    prefix = prefix or ''

    TGetPCIeCardNumReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPCIeCardNumReq.proto_property, errs)
    return self
end

function TGetPCIeCardNumReq:unpack(_)
end

msg.GetPCIeCardNumReq = TGetPCIeCardNumReq

---@class pcie_device.GetDeviceNameRsp
---@field Status integer
---@field DeviceName string
local TGetDeviceNameRsp = {}
TGetDeviceNameRsp.__index = TGetDeviceNameRsp
TGetDeviceNameRsp.group = {}

local function TGetDeviceNameRsp_from_obj(obj)
    return setmetatable(obj, TGetDeviceNameRsp)
end

function TGetDeviceNameRsp.new(Status, DeviceName)
    return TGetDeviceNameRsp_from_obj({Status = Status, DeviceName = DeviceName})
end
---@param obj pcie_device.GetDeviceNameRsp
function TGetDeviceNameRsp:init_from_obj(obj)
    self.Status = obj.Status
    self.DeviceName = obj.DeviceName
end

function TGetDeviceNameRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDeviceNameRsp.group)
end

TGetDeviceNameRsp.from_obj = TGetDeviceNameRsp_from_obj

TGetDeviceNameRsp.proto_property = {'Status', 'DeviceName'}

TGetDeviceNameRsp.default = {0, ''}

TGetDeviceNameRsp.struct = {
    {name = 'Status', is_array = false, struct = nil},
    {name = 'DeviceName', is_array = false, struct = nil}
}

function TGetDeviceNameRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Status', self.Status, 'uint8', false, errs)
    validate.Required(prefix .. 'DeviceName', self.DeviceName, 'string', false, errs)

    TGetDeviceNameRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDeviceNameRsp.proto_property, errs)
    return self
end

function TGetDeviceNameRsp:unpack(_)
    return self.Status, self.DeviceName
end

msg.GetDeviceNameRsp = TGetDeviceNameRsp

---@class pcie_device.GetDeviceNameReq
---@field Segment integer
---@field SocketID integer
---@field Bus integer
---@field Device integer
---@field Function integer
local TGetDeviceNameReq = {}
TGetDeviceNameReq.__index = TGetDeviceNameReq
TGetDeviceNameReq.group = {}

local function TGetDeviceNameReq_from_obj(obj)
    return setmetatable(obj, TGetDeviceNameReq)
end

function TGetDeviceNameReq.new(Segment, SocketID, Bus, Device, Function)
    return TGetDeviceNameReq_from_obj({
        Segment = Segment,
        SocketID = SocketID,
        Bus = Bus,
        Device = Device,
        Function = Function
    })
end
---@param obj pcie_device.GetDeviceNameReq
function TGetDeviceNameReq:init_from_obj(obj)
    self.Segment = obj.Segment
    self.SocketID = obj.SocketID
    self.Bus = obj.Bus
    self.Device = obj.Device
    self.Function = obj.Function
end

function TGetDeviceNameReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDeviceNameReq.group)
end

TGetDeviceNameReq.from_obj = TGetDeviceNameReq_from_obj

TGetDeviceNameReq.proto_property = {'Segment', 'SocketID', 'Bus', 'Device', 'Function'}

TGetDeviceNameReq.default = {0, 0, 0, 0, 0}

TGetDeviceNameReq.struct = {
    {name = 'Segment', is_array = false, struct = nil},
    {name = 'SocketID', is_array = false, struct = nil},
    {name = 'Bus', is_array = false, struct = nil},
    {name = 'Device', is_array = false, struct = nil},
    {name = 'Function', is_array = false, struct = nil}
}

function TGetDeviceNameReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Segment', self.Segment, 'uint8', false, errs)
    validate.Required(prefix .. 'SocketID', self.SocketID, 'uint8', false, errs)
    validate.Required(prefix .. 'Bus', self.Bus, 'uint8', false, errs)
    validate.Required(prefix .. 'Device', self.Device, 'uint8', false, errs)
    validate.Required(prefix .. 'Function', self.Function, 'uint8', false, errs)

    TGetDeviceNameReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDeviceNameReq.proto_property, errs)
    return self
end

function TGetDeviceNameReq:unpack(_)
    return self.Segment, self.SocketID, self.Bus, self.Device, self.Function
end

msg.GetDeviceNameReq = TGetDeviceNameReq

---@class pcie_device.SetPredictiveFaultRsp
---@field Status integer
local TSetPredictiveFaultRsp = {}
TSetPredictiveFaultRsp.__index = TSetPredictiveFaultRsp
TSetPredictiveFaultRsp.group = {}

local function TSetPredictiveFaultRsp_from_obj(obj)
    return setmetatable(obj, TSetPredictiveFaultRsp)
end

function TSetPredictiveFaultRsp.new(Status)
    return TSetPredictiveFaultRsp_from_obj({Status = Status})
end
---@param obj pcie_device.SetPredictiveFaultRsp
function TSetPredictiveFaultRsp:init_from_obj(obj)
    self.Status = obj.Status
end

function TSetPredictiveFaultRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPredictiveFaultRsp.group)
end

TSetPredictiveFaultRsp.from_obj = TSetPredictiveFaultRsp_from_obj

TSetPredictiveFaultRsp.proto_property = {'Status'}

TSetPredictiveFaultRsp.default = {0}

TSetPredictiveFaultRsp.struct = {{name = 'Status', is_array = false, struct = nil}}

function TSetPredictiveFaultRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Status', self.Status, 'uint8', false, errs)

    TSetPredictiveFaultRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPredictiveFaultRsp.proto_property, errs)
    return self
end

function TSetPredictiveFaultRsp:unpack(_)
    return self.Status
end

msg.SetPredictiveFaultRsp = TSetPredictiveFaultRsp

---@class pcie_device.SetPredictiveFaultReq
---@field Segment integer
---@field SocketID integer
---@field Bus integer
---@field Device integer
---@field Function integer
---@field Value integer
local TSetPredictiveFaultReq = {}
TSetPredictiveFaultReq.__index = TSetPredictiveFaultReq
TSetPredictiveFaultReq.group = {}

local function TSetPredictiveFaultReq_from_obj(obj)
    return setmetatable(obj, TSetPredictiveFaultReq)
end

function TSetPredictiveFaultReq.new(Segment, SocketID, Bus, Device, Function, Value)
    return TSetPredictiveFaultReq_from_obj({
        Segment = Segment,
        SocketID = SocketID,
        Bus = Bus,
        Device = Device,
        Function = Function,
        Value = Value
    })
end
---@param obj pcie_device.SetPredictiveFaultReq
function TSetPredictiveFaultReq:init_from_obj(obj)
    self.Segment = obj.Segment
    self.SocketID = obj.SocketID
    self.Bus = obj.Bus
    self.Device = obj.Device
    self.Function = obj.Function
    self.Value = obj.Value
end

function TSetPredictiveFaultReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPredictiveFaultReq.group)
end

TSetPredictiveFaultReq.from_obj = TSetPredictiveFaultReq_from_obj

TSetPredictiveFaultReq.proto_property = {
    'Segment', 'SocketID', 'Bus', 'Device', 'Function', 'Value'
}

TSetPredictiveFaultReq.default = {0, 0, 0, 0, 0, 0}

TSetPredictiveFaultReq.struct = {
    {name = 'Segment', is_array = false, struct = nil},
    {name = 'SocketID', is_array = false, struct = nil},
    {name = 'Bus', is_array = false, struct = nil},
    {name = 'Device', is_array = false, struct = nil},
    {name = 'Function', is_array = false, struct = nil},
    {name = 'Value', is_array = false, struct = nil}
}

function TSetPredictiveFaultReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Segment', self.Segment, 'uint8', false, errs)
    validate.Required(prefix .. 'SocketID', self.SocketID, 'uint8', false, errs)
    validate.Required(prefix .. 'Bus', self.Bus, 'uint8', false, errs)
    validate.Required(prefix .. 'Device', self.Device, 'uint8', false, errs)
    validate.Required(prefix .. 'Function', self.Function, 'uint8', false, errs)
    validate.Required(prefix .. 'Value', self.Value, 'uint8', false, errs)

    TSetPredictiveFaultReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPredictiveFaultReq.proto_property, errs)
    return self
end

function TSetPredictiveFaultReq:unpack(_)
    return self.Segment, self.SocketID, self.Bus, self.Device, self.Function, self.Value
end

msg.SetPredictiveFaultReq = TSetPredictiveFaultReq

---@class pcie_device.SetDiagnosticFaultRsp
---@field Status integer
local TSetDiagnosticFaultRsp = {}
TSetDiagnosticFaultRsp.__index = TSetDiagnosticFaultRsp
TSetDiagnosticFaultRsp.group = {}

local function TSetDiagnosticFaultRsp_from_obj(obj)
    return setmetatable(obj, TSetDiagnosticFaultRsp)
end

function TSetDiagnosticFaultRsp.new(Status)
    return TSetDiagnosticFaultRsp_from_obj({Status = Status})
end
---@param obj pcie_device.SetDiagnosticFaultRsp
function TSetDiagnosticFaultRsp:init_from_obj(obj)
    self.Status = obj.Status
end

function TSetDiagnosticFaultRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDiagnosticFaultRsp.group)
end

TSetDiagnosticFaultRsp.from_obj = TSetDiagnosticFaultRsp_from_obj

TSetDiagnosticFaultRsp.proto_property = {'Status'}

TSetDiagnosticFaultRsp.default = {0}

TSetDiagnosticFaultRsp.struct = {{name = 'Status', is_array = false, struct = nil}}

function TSetDiagnosticFaultRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Status', self.Status, 'uint8', false, errs)

    TSetDiagnosticFaultRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDiagnosticFaultRsp.proto_property, errs)
    return self
end

function TSetDiagnosticFaultRsp:unpack(_)
    return self.Status
end

msg.SetDiagnosticFaultRsp = TSetDiagnosticFaultRsp

---@class pcie_device.SetDiagnosticFaultReq
---@field Segment integer
---@field SocketID integer
---@field Bus integer
---@field Device integer
---@field Function integer
---@field Value integer
local TSetDiagnosticFaultReq = {}
TSetDiagnosticFaultReq.__index = TSetDiagnosticFaultReq
TSetDiagnosticFaultReq.group = {}

local function TSetDiagnosticFaultReq_from_obj(obj)
    return setmetatable(obj, TSetDiagnosticFaultReq)
end

function TSetDiagnosticFaultReq.new(Segment, SocketID, Bus, Device, Function, Value)
    return TSetDiagnosticFaultReq_from_obj({
        Segment = Segment,
        SocketID = SocketID,
        Bus = Bus,
        Device = Device,
        Function = Function,
        Value = Value
    })
end
---@param obj pcie_device.SetDiagnosticFaultReq
function TSetDiagnosticFaultReq:init_from_obj(obj)
    self.Segment = obj.Segment
    self.SocketID = obj.SocketID
    self.Bus = obj.Bus
    self.Device = obj.Device
    self.Function = obj.Function
    self.Value = obj.Value
end

function TSetDiagnosticFaultReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDiagnosticFaultReq.group)
end

TSetDiagnosticFaultReq.from_obj = TSetDiagnosticFaultReq_from_obj

TSetDiagnosticFaultReq.proto_property = {
    'Segment', 'SocketID', 'Bus', 'Device', 'Function', 'Value'
}

TSetDiagnosticFaultReq.default = {0, 0, 0, 0, 0, 0}

TSetDiagnosticFaultReq.struct = {
    {name = 'Segment', is_array = false, struct = nil},
    {name = 'SocketID', is_array = false, struct = nil},
    {name = 'Bus', is_array = false, struct = nil},
    {name = 'Device', is_array = false, struct = nil},
    {name = 'Function', is_array = false, struct = nil},
    {name = 'Value', is_array = false, struct = nil}
}

function TSetDiagnosticFaultReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Segment', self.Segment, 'uint8', false, errs)
    validate.Required(prefix .. 'SocketID', self.SocketID, 'uint8', false, errs)
    validate.Required(prefix .. 'Bus', self.Bus, 'uint8', false, errs)
    validate.Required(prefix .. 'Device', self.Device, 'uint8', false, errs)
    validate.Required(prefix .. 'Function', self.Function, 'uint8', false, errs)
    validate.Required(prefix .. 'Value', self.Value, 'uint8', false, errs)

    TSetDiagnosticFaultReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDiagnosticFaultReq.proto_property, errs)
    return self
end

function TSetDiagnosticFaultReq:unpack(_)
    return self.Segment, self.SocketID, self.Bus, self.Device, self.Function, self.Value
end

msg.SetDiagnosticFaultReq = TSetDiagnosticFaultReq

local pcie_device = {}

local Mdb = require 'mc.mdb'

---@class pcie_device: Table
pcie_device.pcie_device = Mdb.register_interface('bmc.kepler.pcie_device', {}, {
    SetDiagnosticFault = {'a{ss}yyyyyy', 'y', msg.SetDiagnosticFaultReq, msg.SetDiagnosticFaultRsp},
    SetPredictiveFault = {'a{ss}yyyyyy', 'y', msg.SetPredictiveFaultReq, msg.SetPredictiveFaultRsp},
    GetDeviceName = {'a{ss}yyyyy', 'ys', msg.GetDeviceNameReq, msg.GetDeviceNameRsp},
    GetPCIeCardNum = {'a{ss}', 'u', msg.GetPCIeCardNumReq, msg.GetPCIeCardNumRsp}
}, {})
return pcie_device
