-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class network_adapter.GetNetworkPortNumRsp
---@field NetworkPortNum integer
local TGetNetworkPortNumRsp = {}
TGetNetworkPortNumRsp.__index = TGetNetworkPortNumRsp
TGetNetworkPortNumRsp.group = {}

local function TGetNetworkPortNumRsp_from_obj(obj)
    return setmetatable(obj, TGetNetworkPortNumRsp)
end

function TGetNetworkPortNumRsp.new(NetworkPortNum)
    return TGetNetworkPortNumRsp_from_obj({NetworkPortNum = NetworkPortNum})
end
---@param obj network_adapter.GetNetworkPortNumRsp
function TGetNetworkPortNumRsp:init_from_obj(obj)
    self.NetworkPortNum = obj.NetworkPortNum
end

function TGetNetworkPortNumRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetNetworkPortNumRsp.group)
end

TGetNetworkPortNumRsp.from_obj = TGetNetworkPortNumRsp_from_obj

TGetNetworkPortNumRsp.proto_property = {'NetworkPortNum'}

TGetNetworkPortNumRsp.default = {0}

TGetNetworkPortNumRsp.struct = {{name = 'NetworkPortNum', is_array = false, struct = nil}}

function TGetNetworkPortNumRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'NetworkPortNum', self.NetworkPortNum, 'uint8', false, errs)

    TGetNetworkPortNumRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetNetworkPortNumRsp.proto_property, errs)
    return self
end

function TGetNetworkPortNumRsp:unpack(_)
    return self.NetworkPortNum
end

msg.GetNetworkPortNumRsp = TGetNetworkPortNumRsp

---@class network_adapter.GetNetworkPortNumReq
local TGetNetworkPortNumReq = {}
TGetNetworkPortNumReq.__index = TGetNetworkPortNumReq
TGetNetworkPortNumReq.group = {}

local function TGetNetworkPortNumReq_from_obj(obj)
    return setmetatable(obj, TGetNetworkPortNumReq)
end

function TGetNetworkPortNumReq.new()
    return TGetNetworkPortNumReq_from_obj({})
end
---@param obj network_adapter.GetNetworkPortNumReq
function TGetNetworkPortNumReq:init_from_obj(obj)

end

function TGetNetworkPortNumReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetNetworkPortNumReq.group)
end

TGetNetworkPortNumReq.from_obj = TGetNetworkPortNumReq_from_obj

TGetNetworkPortNumReq.proto_property = {}

TGetNetworkPortNumReq.default = {}

TGetNetworkPortNumReq.struct = {}

function TGetNetworkPortNumReq:validate(prefix, errs)
    prefix = prefix or ''

    TGetNetworkPortNumReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetNetworkPortNumReq.proto_property, errs)
    return self
end

function TGetNetworkPortNumReq:unpack(_)
end

msg.GetNetworkPortNumReq = TGetNetworkPortNumReq

---@class network_adapter.GetNetworkAdapterNumRsp
---@field NetworkAdapterNum integer
local TGetNetworkAdapterNumRsp = {}
TGetNetworkAdapterNumRsp.__index = TGetNetworkAdapterNumRsp
TGetNetworkAdapterNumRsp.group = {}

local function TGetNetworkAdapterNumRsp_from_obj(obj)
    return setmetatable(obj, TGetNetworkAdapterNumRsp)
end

function TGetNetworkAdapterNumRsp.new(NetworkAdapterNum)
    return TGetNetworkAdapterNumRsp_from_obj({NetworkAdapterNum = NetworkAdapterNum})
end
---@param obj network_adapter.GetNetworkAdapterNumRsp
function TGetNetworkAdapterNumRsp:init_from_obj(obj)
    self.NetworkAdapterNum = obj.NetworkAdapterNum
end

function TGetNetworkAdapterNumRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetNetworkAdapterNumRsp.group)
end

TGetNetworkAdapterNumRsp.from_obj = TGetNetworkAdapterNumRsp_from_obj

TGetNetworkAdapterNumRsp.proto_property = {'NetworkAdapterNum'}

TGetNetworkAdapterNumRsp.default = {0}

TGetNetworkAdapterNumRsp.struct = {{name = 'NetworkAdapterNum', is_array = false, struct = nil}}

function TGetNetworkAdapterNumRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'NetworkAdapterNum', self.NetworkAdapterNum, 'uint8', false, errs)

    TGetNetworkAdapterNumRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetNetworkAdapterNumRsp.proto_property, errs)
    return self
end

function TGetNetworkAdapterNumRsp:unpack(_)
    return self.NetworkAdapterNum
end

msg.GetNetworkAdapterNumRsp = TGetNetworkAdapterNumRsp

---@class network_adapter.GetNetworkAdapterNumReq
local TGetNetworkAdapterNumReq = {}
TGetNetworkAdapterNumReq.__index = TGetNetworkAdapterNumReq
TGetNetworkAdapterNumReq.group = {}

local function TGetNetworkAdapterNumReq_from_obj(obj)
    return setmetatable(obj, TGetNetworkAdapterNumReq)
end

function TGetNetworkAdapterNumReq.new()
    return TGetNetworkAdapterNumReq_from_obj({})
end
---@param obj network_adapter.GetNetworkAdapterNumReq
function TGetNetworkAdapterNumReq:init_from_obj(obj)

end

function TGetNetworkAdapterNumReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetNetworkAdapterNumReq.group)
end

TGetNetworkAdapterNumReq.from_obj = TGetNetworkAdapterNumReq_from_obj

TGetNetworkAdapterNumReq.proto_property = {}

TGetNetworkAdapterNumReq.default = {}

TGetNetworkAdapterNumReq.struct = {}

function TGetNetworkAdapterNumReq:validate(prefix, errs)
    prefix = prefix or ''

    TGetNetworkAdapterNumReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetNetworkAdapterNumReq.proto_property, errs)
    return self
end

function TGetNetworkAdapterNumReq:unpack(_)
end

msg.GetNetworkAdapterNumReq = TGetNetworkAdapterNumReq

---@class network_adapter.GetPortSpeedRsp
---@field Status integer
---@field Speed integer
local TGetPortSpeedRsp = {}
TGetPortSpeedRsp.__index = TGetPortSpeedRsp
TGetPortSpeedRsp.group = {}

local function TGetPortSpeedRsp_from_obj(obj)
    return setmetatable(obj, TGetPortSpeedRsp)
end

function TGetPortSpeedRsp.new(Status, Speed)
    return TGetPortSpeedRsp_from_obj({Status = Status, Speed = Speed})
end
---@param obj network_adapter.GetPortSpeedRsp
function TGetPortSpeedRsp:init_from_obj(obj)
    self.Status = obj.Status
    self.Speed = obj.Speed
end

function TGetPortSpeedRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPortSpeedRsp.group)
end

TGetPortSpeedRsp.from_obj = TGetPortSpeedRsp_from_obj

TGetPortSpeedRsp.proto_property = {'Status', 'Speed'}

TGetPortSpeedRsp.default = {0, 0}

TGetPortSpeedRsp.struct = {
    {name = 'Status', is_array = false, struct = nil},
    {name = 'Speed', is_array = false, struct = nil}
}

function TGetPortSpeedRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Status', self.Status, 'uint8', false, errs)
    validate.Required(prefix .. 'Speed', self.Speed, 'uint32', false, errs)

    TGetPortSpeedRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPortSpeedRsp.proto_property, errs)
    return self
end

function TGetPortSpeedRsp:unpack(_)
    return self.Status, self.Speed
end

msg.GetPortSpeedRsp = TGetPortSpeedRsp

---@class network_adapter.GetPortSpeedReq
---@field Slot integer
---@field PortID integer
local TGetPortSpeedReq = {}
TGetPortSpeedReq.__index = TGetPortSpeedReq
TGetPortSpeedReq.group = {}

local function TGetPortSpeedReq_from_obj(obj)
    return setmetatable(obj, TGetPortSpeedReq)
end

function TGetPortSpeedReq.new(Slot, PortID)
    return TGetPortSpeedReq_from_obj({Slot = Slot, PortID = PortID})
end
---@param obj network_adapter.GetPortSpeedReq
function TGetPortSpeedReq:init_from_obj(obj)
    self.Slot = obj.Slot
    self.PortID = obj.PortID
end

function TGetPortSpeedReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPortSpeedReq.group)
end

TGetPortSpeedReq.from_obj = TGetPortSpeedReq_from_obj

TGetPortSpeedReq.proto_property = {'Slot', 'PortID'}

TGetPortSpeedReq.default = {0, 0}

TGetPortSpeedReq.struct = {
    {name = 'Slot', is_array = false, struct = nil},
    {name = 'PortID', is_array = false, struct = nil}
}

function TGetPortSpeedReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Slot', self.Slot, 'uint8', false, errs)
    validate.Required(prefix .. 'PortID', self.PortID, 'uint8', false, errs)

    TGetPortSpeedReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPortSpeedReq.proto_property, errs)
    return self
end

function TGetPortSpeedReq:unpack(_)
    return self.Slot, self.PortID
end

msg.GetPortSpeedReq = TGetPortSpeedReq

---@class network_adapter.GetNetCardPortNumRsp
---@field NetcardExist integer
---@field PortNum integer
local TGetNetCardPortNumRsp = {}
TGetNetCardPortNumRsp.__index = TGetNetCardPortNumRsp
TGetNetCardPortNumRsp.group = {}

local function TGetNetCardPortNumRsp_from_obj(obj)
    return setmetatable(obj, TGetNetCardPortNumRsp)
end

function TGetNetCardPortNumRsp.new(NetcardExist, PortNum)
    return TGetNetCardPortNumRsp_from_obj({NetcardExist = NetcardExist, PortNum = PortNum})
end
---@param obj network_adapter.GetNetCardPortNumRsp
function TGetNetCardPortNumRsp:init_from_obj(obj)
    self.NetcardExist = obj.NetcardExist
    self.PortNum = obj.PortNum
end

function TGetNetCardPortNumRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetNetCardPortNumRsp.group)
end

TGetNetCardPortNumRsp.from_obj = TGetNetCardPortNumRsp_from_obj

TGetNetCardPortNumRsp.proto_property = {'NetcardExist', 'PortNum'}

TGetNetCardPortNumRsp.default = {0, 0}

TGetNetCardPortNumRsp.struct = {
    {name = 'NetcardExist', is_array = false, struct = nil},
    {name = 'PortNum', is_array = false, struct = nil}
}

function TGetNetCardPortNumRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'NetcardExist', self.NetcardExist, 'uint8', false, errs)
    validate.Required(prefix .. 'PortNum', self.PortNum, 'uint8', false, errs)

    TGetNetCardPortNumRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetNetCardPortNumRsp.proto_property, errs)
    return self
end

function TGetNetCardPortNumRsp:unpack(_)
    return self.NetcardExist, self.PortNum
end

msg.GetNetCardPortNumRsp = TGetNetCardPortNumRsp

---@class network_adapter.GetNetCardPortNumReq
---@field Type integer
---@field SystemID integer
---@field SlotID integer
local TGetNetCardPortNumReq = {}
TGetNetCardPortNumReq.__index = TGetNetCardPortNumReq
TGetNetCardPortNumReq.group = {}

local function TGetNetCardPortNumReq_from_obj(obj)
    return setmetatable(obj, TGetNetCardPortNumReq)
end

function TGetNetCardPortNumReq.new(Type, SystemID, SlotID)
    return TGetNetCardPortNumReq_from_obj({Type = Type, SystemID = SystemID, SlotID = SlotID})
end
---@param obj network_adapter.GetNetCardPortNumReq
function TGetNetCardPortNumReq:init_from_obj(obj)
    self.Type = obj.Type
    self.SystemID = obj.SystemID
    self.SlotID = obj.SlotID
end

function TGetNetCardPortNumReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetNetCardPortNumReq.group)
end

TGetNetCardPortNumReq.from_obj = TGetNetCardPortNumReq_from_obj

TGetNetCardPortNumReq.proto_property = {'Type', 'SystemID', 'SlotID'}

TGetNetCardPortNumReq.default = {0, 0, 0}

TGetNetCardPortNumReq.struct = {
    {name = 'Type', is_array = false, struct = nil},
    {name = 'SystemID', is_array = false, struct = nil},
    {name = 'SlotID', is_array = false, struct = nil}
}

function TGetNetCardPortNumReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Type', self.Type, 'uint8', false, errs)
    validate.Required(prefix .. 'SystemID', self.SystemID, 'uint8', false, errs)
    validate.Required(prefix .. 'SlotID', self.SlotID, 'uint8', false, errs)

    TGetNetCardPortNumReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetNetCardPortNumReq.proto_property, errs)
    return self
end

function TGetNetCardPortNumReq:unpack(_)
    return self.Type, self.SystemID, self.SlotID
end

msg.GetNetCardPortNumReq = TGetNetCardPortNumReq

local network_adapter = {}

local Mdb = require 'mc.mdb'

---@class network_adapter: Table
network_adapter.network_adapter = Mdb.register_interface('bmc.kepler.network_adapter', {}, {
    GetNetCardPortNum = {'a{ss}yyy', 'yy', msg.GetNetCardPortNumReq, msg.GetNetCardPortNumRsp},
    GetPortSpeed = {'a{ss}yy', 'yu', msg.GetPortSpeedReq, msg.GetPortSpeedRsp},
    GetNetworkAdapterNum = {'a{ss}', 'y', msg.GetNetworkAdapterNumReq, msg.GetNetworkAdapterNumRsp},
    GetNetworkPortNum = {'a{ss}', 'y', msg.GetNetworkPortNumReq, msg.GetNetworkPortNumRsp}
}, {})
return network_adapter
