-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local ErrorInterface = require 'mdb.bmc.kepler.error_interfaceInterface'

local childs = {}
local Error = {childs = childs}

local Mdb = require 'mc.mdb'

local TError = Mdb.register_object('/bmc/kepler/Error/:appname/:errtype',
    {{name = 'Error', interface = ErrorInterface.IError}})
Error.Error = TError

function TError:ctor(appname, errtype)
    self.path = '/bmc/kepler/Error/' .. appname .. '/' .. errtype .. ''
end

return Error
