-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class chassis.SetUIDLedIdentifyRsp
---@field State integer
---@field OnDuration integer
---@field OffDuration integer
local TSetUIDLedIdentifyRsp = {}
TSetUIDLedIdentifyRsp.__index = TSetUIDLedIdentifyRsp
TSetUIDLedIdentifyRsp.group = {}

local function TSetUIDLedIdentifyRsp_from_obj(obj)
    return setmetatable(obj, TSetUIDLedIdentifyRsp)
end

function TSetUIDLedIdentifyRsp.new(State, OnDuration, OffDuration)
    return TSetUIDLedIdentifyRsp_from_obj({
        State = State,
        OnDuration = OnDuration,
        OffDuration = OffDuration
    })
end
---@param obj chassis.SetUIDLedIdentifyRsp
function TSetUIDLedIdentifyRsp:init_from_obj(obj)
    self.State = obj.State
    self.OnDuration = obj.OnDuration
    self.OffDuration = obj.OffDuration
end

function TSetUIDLedIdentifyRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetUIDLedIdentifyRsp.group)
end

TSetUIDLedIdentifyRsp.from_obj = TSetUIDLedIdentifyRsp_from_obj

TSetUIDLedIdentifyRsp.proto_property = {'State', 'OnDuration', 'OffDuration'}

TSetUIDLedIdentifyRsp.default = {0, 0, 0}

TSetUIDLedIdentifyRsp.struct = {
    {name = 'State', is_array = false, struct = nil},
    {name = 'OnDuration', is_array = false, struct = nil},
    {name = 'OffDuration', is_array = false, struct = nil}
}

function TSetUIDLedIdentifyRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'State', self.State, 'uint8', false, errs)
    validate.Required(prefix .. 'OnDuration', self.OnDuration, 'uint8', false, errs)
    validate.Required(prefix .. 'OffDuration', self.OffDuration, 'uint8', false, errs)

    TSetUIDLedIdentifyRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetUIDLedIdentifyRsp.proto_property, errs)
    return self
end

function TSetUIDLedIdentifyRsp:unpack(_)
    return self.State, self.OnDuration, self.OffDuration
end

msg.SetUIDLedIdentifyRsp = TSetUIDLedIdentifyRsp

---@class chassis.SetUIDLedIdentifyReq
---@field State integer
---@field Interval integer
local TSetUIDLedIdentifyReq = {}
TSetUIDLedIdentifyReq.__index = TSetUIDLedIdentifyReq
TSetUIDLedIdentifyReq.group = {}

local function TSetUIDLedIdentifyReq_from_obj(obj)
    return setmetatable(obj, TSetUIDLedIdentifyReq)
end

function TSetUIDLedIdentifyReq.new(State, Interval)
    return TSetUIDLedIdentifyReq_from_obj({State = State, Interval = Interval})
end
---@param obj chassis.SetUIDLedIdentifyReq
function TSetUIDLedIdentifyReq:init_from_obj(obj)
    self.State = obj.State
    self.Interval = obj.Interval
end

function TSetUIDLedIdentifyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetUIDLedIdentifyReq.group)
end

TSetUIDLedIdentifyReq.from_obj = TSetUIDLedIdentifyReq_from_obj

TSetUIDLedIdentifyReq.proto_property = {'State', 'Interval'}

TSetUIDLedIdentifyReq.default = {0, 0}

TSetUIDLedIdentifyReq.struct = {
    {name = 'State', is_array = false, struct = nil},
    {name = 'Interval', is_array = false, struct = nil}
}

function TSetUIDLedIdentifyReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'State', self.State, 'uint8', false, errs)
    validate.Required(prefix .. 'Interval', self.Interval, 'uint8', false, errs)

    TSetUIDLedIdentifyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetUIDLedIdentifyReq.proto_property, errs)
    return self
end

function TSetUIDLedIdentifyReq:unpack(_)
    return self.State, self.Interval
end

msg.SetUIDLedIdentifyReq = TSetUIDLedIdentifyReq

local chassis = {}

local Mdb = require 'mc.mdb'

---@class chassis: Table
chassis.chassis = Mdb.register_interface('bmc.kepler.chassis', {}, {
    SetUIDLedIdentify = {'a{ss}yy', 'yyy', msg.SetUIDLedIdentifyReq, msg.SetUIDLedIdentifyRsp}
}, {})
return chassis
