-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class bios.SetBootModeRsp
---@field RespCode integer
local TSetBootModeRsp = {}
TSetBootModeRsp.__index = TSetBootModeRsp
TSetBootModeRsp.group = {}

local function TSetBootModeRsp_from_obj(obj)
    return setmetatable(obj, TSetBootModeRsp)
end

function TSetBootModeRsp.new(RespCode)
    return TSetBootModeRsp_from_obj({RespCode = RespCode})
end
---@param obj bios.SetBootModeRsp
function TSetBootModeRsp:init_from_obj(obj)
    self.RespCode = obj.RespCode
end

function TSetBootModeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBootModeRsp.group)
end

TSetBootModeRsp.from_obj = TSetBootModeRsp_from_obj

TSetBootModeRsp.proto_property = {'RespCode'}

TSetBootModeRsp.default = {0}

TSetBootModeRsp.struct = {{name = 'RespCode', is_array = false, struct = nil}}

function TSetBootModeRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'RespCode', self.RespCode, 'int32', false, errs)

    TSetBootModeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBootModeRsp.proto_property, errs)
    return self
end

function TSetBootModeRsp:unpack(_)
    return self.RespCode
end

msg.SetBootModeRsp = TSetBootModeRsp

---@class bios.SetBootModeReq
---@field mode integer
local TSetBootModeReq = {}
TSetBootModeReq.__index = TSetBootModeReq
TSetBootModeReq.group = {}

local function TSetBootModeReq_from_obj(obj)
    return setmetatable(obj, TSetBootModeReq)
end

function TSetBootModeReq.new(mode)
    return TSetBootModeReq_from_obj({mode = mode})
end
---@param obj bios.SetBootModeReq
function TSetBootModeReq:init_from_obj(obj)
    self.mode = obj.mode
end

function TSetBootModeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBootModeReq.group)
end

TSetBootModeReq.from_obj = TSetBootModeReq_from_obj

TSetBootModeReq.proto_property = {'mode'}

TSetBootModeReq.default = {0}

TSetBootModeReq.struct = {{name = 'mode', is_array = false, struct = nil}}

function TSetBootModeReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'mode', self.mode, 'uint8', false, errs)

    TSetBootModeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBootModeReq.proto_property, errs)
    return self
end

function TSetBootModeReq:unpack(_)
    return self.mode
end

msg.SetBootModeReq = TSetBootModeReq

---@class bios.SetStartOptionFlagRsp
---@field Result integer
local TSetStartOptionFlagRsp = {}
TSetStartOptionFlagRsp.__index = TSetStartOptionFlagRsp
TSetStartOptionFlagRsp.group = {}

local function TSetStartOptionFlagRsp_from_obj(obj)
    return setmetatable(obj, TSetStartOptionFlagRsp)
end

function TSetStartOptionFlagRsp.new(Result)
    return TSetStartOptionFlagRsp_from_obj({Result = Result})
end
---@param obj bios.SetStartOptionFlagRsp
function TSetStartOptionFlagRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TSetStartOptionFlagRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetStartOptionFlagRsp.group)
end

TSetStartOptionFlagRsp.from_obj = TSetStartOptionFlagRsp_from_obj

TSetStartOptionFlagRsp.proto_property = {'Result'}

TSetStartOptionFlagRsp.default = {0}

TSetStartOptionFlagRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TSetStartOptionFlagRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Result', self.Result, 'int32', false, errs)

    TSetStartOptionFlagRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetStartOptionFlagRsp.proto_property, errs)
    return self
end

function TSetStartOptionFlagRsp:unpack(_)
    return self.Result
end

msg.SetStartOptionFlagRsp = TSetStartOptionFlagRsp

---@class bios.SetStartOptionFlagReq
---@field StartOptionFlag integer
local TSetStartOptionFlagReq = {}
TSetStartOptionFlagReq.__index = TSetStartOptionFlagReq
TSetStartOptionFlagReq.group = {}

local function TSetStartOptionFlagReq_from_obj(obj)
    return setmetatable(obj, TSetStartOptionFlagReq)
end

function TSetStartOptionFlagReq.new(StartOptionFlag)
    return TSetStartOptionFlagReq_from_obj({StartOptionFlag = StartOptionFlag})
end
---@param obj bios.SetStartOptionFlagReq
function TSetStartOptionFlagReq:init_from_obj(obj)
    self.StartOptionFlag = obj.StartOptionFlag
end

function TSetStartOptionFlagReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetStartOptionFlagReq.group)
end

TSetStartOptionFlagReq.from_obj = TSetStartOptionFlagReq_from_obj

TSetStartOptionFlagReq.proto_property = {'StartOptionFlag'}

TSetStartOptionFlagReq.default = {0}

TSetStartOptionFlagReq.struct = {{name = 'StartOptionFlag', is_array = false, struct = nil}}

function TSetStartOptionFlagReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'StartOptionFlag', self.StartOptionFlag, 'uint8', false, errs)

    TSetStartOptionFlagReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetStartOptionFlagReq.proto_property, errs)
    return self
end

function TSetStartOptionFlagReq:unpack(_)
    return self.StartOptionFlag
end

msg.SetStartOptionFlagReq = TSetStartOptionFlagReq

---@class bios.SetStartOptionRsp
---@field Result integer
local TSetStartOptionRsp = {}
TSetStartOptionRsp.__index = TSetStartOptionRsp
TSetStartOptionRsp.group = {}

local function TSetStartOptionRsp_from_obj(obj)
    return setmetatable(obj, TSetStartOptionRsp)
end

function TSetStartOptionRsp.new(Result)
    return TSetStartOptionRsp_from_obj({Result = Result})
end
---@param obj bios.SetStartOptionRsp
function TSetStartOptionRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TSetStartOptionRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetStartOptionRsp.group)
end

TSetStartOptionRsp.from_obj = TSetStartOptionRsp_from_obj

TSetStartOptionRsp.proto_property = {'Result'}

TSetStartOptionRsp.default = {0}

TSetStartOptionRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TSetStartOptionRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Result', self.Result, 'int32', false, errs)

    TSetStartOptionRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetStartOptionRsp.proto_property, errs)
    return self
end

function TSetStartOptionRsp:unpack(_)
    return self.Result
end

msg.SetStartOptionRsp = TSetStartOptionRsp

---@class bios.SetStartOptionReq
---@field StartOption integer
local TSetStartOptionReq = {}
TSetStartOptionReq.__index = TSetStartOptionReq
TSetStartOptionReq.group = {}

local function TSetStartOptionReq_from_obj(obj)
    return setmetatable(obj, TSetStartOptionReq)
end

function TSetStartOptionReq.new(StartOption)
    return TSetStartOptionReq_from_obj({StartOption = StartOption})
end
---@param obj bios.SetStartOptionReq
function TSetStartOptionReq:init_from_obj(obj)
    self.StartOption = obj.StartOption
end

function TSetStartOptionReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetStartOptionReq.group)
end

TSetStartOptionReq.from_obj = TSetStartOptionReq_from_obj

TSetStartOptionReq.proto_property = {'StartOption'}

TSetStartOptionReq.default = {0}

TSetStartOptionReq.struct = {{name = 'StartOption', is_array = false, struct = nil}}

function TSetStartOptionReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'StartOption', self.StartOption, 'uint8', false, errs)

    TSetStartOptionReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetStartOptionReq.proto_property, errs)
    return self
end

function TSetStartOptionReq:unpack(_)
    return self.StartOption
end

msg.SetStartOptionReq = TSetStartOptionReq

---@class bios.SetBootOrderRsp
---@field OutCode integer
---@field ErrName string
---@field ErrValue string
local TSetBootOrderRsp = {}
TSetBootOrderRsp.__index = TSetBootOrderRsp
TSetBootOrderRsp.group = {}

local function TSetBootOrderRsp_from_obj(obj)
    return setmetatable(obj, TSetBootOrderRsp)
end

function TSetBootOrderRsp.new(OutCode, ErrName, ErrValue)
    return TSetBootOrderRsp_from_obj({OutCode = OutCode, ErrName = ErrName, ErrValue = ErrValue})
end
---@param obj bios.SetBootOrderRsp
function TSetBootOrderRsp:init_from_obj(obj)
    self.OutCode = obj.OutCode
    self.ErrName = obj.ErrName
    self.ErrValue = obj.ErrValue
end

function TSetBootOrderRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBootOrderRsp.group)
end

TSetBootOrderRsp.from_obj = TSetBootOrderRsp_from_obj

TSetBootOrderRsp.proto_property = {'OutCode', 'ErrName', 'ErrValue'}

TSetBootOrderRsp.default = {0, '', ''}

TSetBootOrderRsp.struct = {
    {name = 'OutCode', is_array = false, struct = nil},
    {name = 'ErrName', is_array = false, struct = nil},
    {name = 'ErrValue', is_array = false, struct = nil}
}

function TSetBootOrderRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'OutCode', self.OutCode, 'int32', false, errs)
    validate.Required(prefix .. 'ErrName', self.ErrName, 'string', false, errs)
    validate.Required(prefix .. 'ErrValue', self.ErrValue, 'string', false, errs)

    TSetBootOrderRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBootOrderRsp.proto_property, errs)
    return self
end

function TSetBootOrderRsp:unpack(_)
    return self.OutCode, self.ErrName, self.ErrValue
end

msg.SetBootOrderRsp = TSetBootOrderRsp

---@class bios.SetBootOrderReq
---@field BootOrderJson string
local TSetBootOrderReq = {}
TSetBootOrderReq.__index = TSetBootOrderReq
TSetBootOrderReq.group = {}

local function TSetBootOrderReq_from_obj(obj)
    return setmetatable(obj, TSetBootOrderReq)
end

function TSetBootOrderReq.new(BootOrderJson)
    return TSetBootOrderReq_from_obj({BootOrderJson = BootOrderJson})
end
---@param obj bios.SetBootOrderReq
function TSetBootOrderReq:init_from_obj(obj)
    self.BootOrderJson = obj.BootOrderJson
end

function TSetBootOrderReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBootOrderReq.group)
end

TSetBootOrderReq.from_obj = TSetBootOrderReq_from_obj

TSetBootOrderReq.proto_property = {'BootOrderJson'}

TSetBootOrderReq.default = {''}

TSetBootOrderReq.struct = {{name = 'BootOrderJson', is_array = false, struct = nil}}

function TSetBootOrderReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'BootOrderJson', self.BootOrderJson, 'string', false, errs)

    TSetBootOrderReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBootOrderReq.proto_property, errs)
    return self
end

function TSetBootOrderReq:unpack(_)
    return self.BootOrderJson
end

msg.SetBootOrderReq = TSetBootOrderReq

---@class bios.ImportBiosConfigRsp
---@field ExportFlag integer
---@field ExportResult string
local TImportBiosConfigRsp = {}
TImportBiosConfigRsp.__index = TImportBiosConfigRsp
TImportBiosConfigRsp.group = {}

local function TImportBiosConfigRsp_from_obj(obj)
    return setmetatable(obj, TImportBiosConfigRsp)
end

function TImportBiosConfigRsp.new(ExportFlag, ExportResult)
    return TImportBiosConfigRsp_from_obj({ExportFlag = ExportFlag, ExportResult = ExportResult})
end
---@param obj bios.ImportBiosConfigRsp
function TImportBiosConfigRsp:init_from_obj(obj)
    self.ExportFlag = obj.ExportFlag
    self.ExportResult = obj.ExportResult
end

function TImportBiosConfigRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportBiosConfigRsp.group)
end

TImportBiosConfigRsp.from_obj = TImportBiosConfigRsp_from_obj

TImportBiosConfigRsp.proto_property = {'ExportFlag', 'ExportResult'}

TImportBiosConfigRsp.default = {0, ''}

TImportBiosConfigRsp.struct = {
    {name = 'ExportFlag', is_array = false, struct = nil},
    {name = 'ExportResult', is_array = false, struct = nil}
}

function TImportBiosConfigRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'ExportFlag', self.ExportFlag, 'uint8', false, errs)
    validate.Required(prefix .. 'ExportResult', self.ExportResult, 'string', false, errs)

    TImportBiosConfigRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportBiosConfigRsp.proto_property, errs)
    return self
end

function TImportBiosConfigRsp:unpack(_)
    return self.ExportFlag, self.ExportResult
end

msg.ImportBiosConfigRsp = TImportBiosConfigRsp

---@class bios.ImportBiosConfigReq
local TImportBiosConfigReq = {}
TImportBiosConfigReq.__index = TImportBiosConfigReq
TImportBiosConfigReq.group = {}

local function TImportBiosConfigReq_from_obj(obj)
    return setmetatable(obj, TImportBiosConfigReq)
end

function TImportBiosConfigReq.new()
    return TImportBiosConfigReq_from_obj({})
end
---@param obj bios.ImportBiosConfigReq
function TImportBiosConfigReq:init_from_obj(obj)

end

function TImportBiosConfigReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportBiosConfigReq.group)
end

TImportBiosConfigReq.from_obj = TImportBiosConfigReq_from_obj

TImportBiosConfigReq.proto_property = {}

TImportBiosConfigReq.default = {}

TImportBiosConfigReq.struct = {}

function TImportBiosConfigReq:validate(prefix, errs)
    prefix = prefix or ''

    TImportBiosConfigReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportBiosConfigReq.proto_property, errs)
    return self
end

function TImportBiosConfigReq:unpack(_)
end

msg.ImportBiosConfigReq = TImportBiosConfigReq

---@class bios.ExportBiosConfigRsp
---@field ExportFlag integer
local TExportBiosConfigRsp = {}
TExportBiosConfigRsp.__index = TExportBiosConfigRsp
TExportBiosConfigRsp.group = {}

local function TExportBiosConfigRsp_from_obj(obj)
    return setmetatable(obj, TExportBiosConfigRsp)
end

function TExportBiosConfigRsp.new(ExportFlag)
    return TExportBiosConfigRsp_from_obj({ExportFlag = ExportFlag})
end
---@param obj bios.ExportBiosConfigRsp
function TExportBiosConfigRsp:init_from_obj(obj)
    self.ExportFlag = obj.ExportFlag
end

function TExportBiosConfigRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExportBiosConfigRsp.group)
end

TExportBiosConfigRsp.from_obj = TExportBiosConfigRsp_from_obj

TExportBiosConfigRsp.proto_property = {'ExportFlag'}

TExportBiosConfigRsp.default = {0}

TExportBiosConfigRsp.struct = {{name = 'ExportFlag', is_array = false, struct = nil}}

function TExportBiosConfigRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'ExportFlag', self.ExportFlag, 'uint8', false, errs)

    TExportBiosConfigRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExportBiosConfigRsp.proto_property, errs)
    return self
end

function TExportBiosConfigRsp:unpack(_)
    return self.ExportFlag
end

msg.ExportBiosConfigRsp = TExportBiosConfigRsp

---@class bios.ExportBiosConfigReq
---@field ConfigPath string
local TExportBiosConfigReq = {}
TExportBiosConfigReq.__index = TExportBiosConfigReq
TExportBiosConfigReq.group = {}

local function TExportBiosConfigReq_from_obj(obj)
    return setmetatable(obj, TExportBiosConfigReq)
end

function TExportBiosConfigReq.new(ConfigPath)
    return TExportBiosConfigReq_from_obj({ConfigPath = ConfigPath})
end
---@param obj bios.ExportBiosConfigReq
function TExportBiosConfigReq:init_from_obj(obj)
    self.ConfigPath = obj.ConfigPath
end

function TExportBiosConfigReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExportBiosConfigReq.group)
end

TExportBiosConfigReq.from_obj = TExportBiosConfigReq_from_obj

TExportBiosConfigReq.proto_property = {'ConfigPath'}

TExportBiosConfigReq.default = {''}

TExportBiosConfigReq.struct = {{name = 'ConfigPath', is_array = false, struct = nil}}

function TExportBiosConfigReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'ConfigPath', self.ConfigPath, 'string', false, errs)

    TExportBiosConfigReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExportBiosConfigReq.proto_property, errs)
    return self
end

function TExportBiosConfigReq:unpack(_)
    return self.ConfigPath
end

msg.ExportBiosConfigReq = TExportBiosConfigReq

---@class bios.GetCurrentValueSettingRsp
---@field RespValue string
local TGetCurrentValueSettingRsp = {}
TGetCurrentValueSettingRsp.__index = TGetCurrentValueSettingRsp
TGetCurrentValueSettingRsp.group = {}

local function TGetCurrentValueSettingRsp_from_obj(obj)
    return setmetatable(obj, TGetCurrentValueSettingRsp)
end

function TGetCurrentValueSettingRsp.new(RespValue)
    return TGetCurrentValueSettingRsp_from_obj({RespValue = RespValue})
end
---@param obj bios.GetCurrentValueSettingRsp
function TGetCurrentValueSettingRsp:init_from_obj(obj)
    self.RespValue = obj.RespValue
end

function TGetCurrentValueSettingRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetCurrentValueSettingRsp.group)
end

TGetCurrentValueSettingRsp.from_obj = TGetCurrentValueSettingRsp_from_obj

TGetCurrentValueSettingRsp.proto_property = {'RespValue'}

TGetCurrentValueSettingRsp.default = {''}

TGetCurrentValueSettingRsp.struct = {{name = 'RespValue', is_array = false, struct = nil}}

function TGetCurrentValueSettingRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'RespValue', self.RespValue, 'string', false, errs)

    TGetCurrentValueSettingRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetCurrentValueSettingRsp.proto_property, errs)
    return self
end

function TGetCurrentValueSettingRsp:unpack(_)
    return self.RespValue
end

msg.GetCurrentValueSettingRsp = TGetCurrentValueSettingRsp

---@class bios.GetCurrentValueSettingReq
---@field ReqKey string
local TGetCurrentValueSettingReq = {}
TGetCurrentValueSettingReq.__index = TGetCurrentValueSettingReq
TGetCurrentValueSettingReq.group = {}

local function TGetCurrentValueSettingReq_from_obj(obj)
    return setmetatable(obj, TGetCurrentValueSettingReq)
end

function TGetCurrentValueSettingReq.new(ReqKey)
    return TGetCurrentValueSettingReq_from_obj({ReqKey = ReqKey})
end
---@param obj bios.GetCurrentValueSettingReq
function TGetCurrentValueSettingReq:init_from_obj(obj)
    self.ReqKey = obj.ReqKey
end

function TGetCurrentValueSettingReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetCurrentValueSettingReq.group)
end

TGetCurrentValueSettingReq.from_obj = TGetCurrentValueSettingReq_from_obj

TGetCurrentValueSettingReq.proto_property = {'ReqKey'}

TGetCurrentValueSettingReq.default = {''}

TGetCurrentValueSettingReq.struct = {{name = 'ReqKey', is_array = false, struct = nil}}

function TGetCurrentValueSettingReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'ReqKey', self.ReqKey, 'string', false, errs)

    TGetCurrentValueSettingReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetCurrentValueSettingReq.proto_property, errs)
    return self
end

function TGetCurrentValueSettingReq:unpack(_)
    return self.ReqKey
end

msg.GetCurrentValueSettingReq = TGetCurrentValueSettingReq

local bios = {}

local Mdb = require 'mc.mdb'

---@class bios: Table
bios.bios = Mdb.register_interface('bmc.kepler.bios', {}, {
    GetCurrentValueSetting = {
        'a{ss}s', 's', msg.GetCurrentValueSettingReq, msg.GetCurrentValueSettingRsp
    },
    ExportBiosConfig = {'a{ss}s', 'y', msg.ExportBiosConfigReq, msg.ExportBiosConfigRsp},
    ImportBiosConfig = {'a{ss}', 'ys', msg.ImportBiosConfigReq, msg.ImportBiosConfigRsp},
    SetBootOrder = {'a{ss}s', 'iss', msg.SetBootOrderReq, msg.SetBootOrderRsp},
    SetStartOption = {'a{ss}y', 'i', msg.SetStartOptionReq, msg.SetStartOptionRsp},
    SetStartOptionFlag = {'a{ss}y', 'i', msg.SetStartOptionFlagReq, msg.SetStartOptionFlagRsp},
    SetBootMode = {'a{ss}y', 'i', msg.SetBootModeReq, msg.SetBootModeRsp}
}, {})
return bios
