-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'
local create_enum_type = require 'mc.enum'

local msg = {}
local defs = {}

---@class defs.ActiveStatus: Enum
local EActiveStatus = create_enum_type('ActiveStatus')
EActiveStatus.default = EActiveStatus.new(0)
EActiveStatus.struct = nil
EActiveStatus.AS_IDLE = EActiveStatus.new(1)
EActiveStatus.AS_APPLY = EActiveStatus.new(2)
EActiveStatus.AS_SUSPEND = EActiveStatus.new(3)
EActiveStatus.AS_READY = EActiveStatus.new(4)

defs.ActiveStatus = EActiveStatus

---@class defs.ActiveAction: Enum
local EActiveAction = create_enum_type('ActiveAction')
EActiveAction.default = EActiveAction.new(0)
EActiveAction.struct = nil
EActiveAction.AC_CYCLE = EActiveAction.new(1)
EActiveAction.BMC_RESET = EActiveAction.new(2)
EActiveAction.NONE_ACTION = EActiveAction.new(3)

defs.ActiveAction = EActiveAction

---@class UpdateService.ExportRsp
local TExportRsp = {}
TExportRsp.__index = TExportRsp
TExportRsp.group = {}

local function TExportRsp_from_obj(obj)
    return setmetatable(obj, TExportRsp)
end

function TExportRsp.new()
    return TExportRsp_from_obj({})
end
---@param obj UpdateService.ExportRsp
function TExportRsp:init_from_obj(obj)

end

function TExportRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExportRsp.group)
end

TExportRsp.from_obj = TExportRsp_from_obj

TExportRsp.proto_property = {}

TExportRsp.default = {}

TExportRsp.struct = {}

function TExportRsp:validate(prefix, errs)
    prefix = prefix or ''

    TExportRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExportRsp.proto_property, errs)
    return self
end

function TExportRsp:unpack(_)
end

msg.ExportRsp = TExportRsp

---@class UpdateService.ExportReq
---@field SystemId integer
---@field Id string
local TExportReq = {}
TExportReq.__index = TExportReq
TExportReq.group = {}

local function TExportReq_from_obj(obj)
    return setmetatable(obj, TExportReq)
end

function TExportReq.new(SystemId, Id)
    return TExportReq_from_obj({SystemId = SystemId, Id = Id})
end
---@param obj UpdateService.ExportReq
function TExportReq:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.Id = obj.Id
end

function TExportReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExportReq.group)
end

TExportReq.from_obj = TExportReq_from_obj

TExportReq.proto_property = {'SystemId', 'Id'}

TExportReq.default = {0, ''}

TExportReq.struct = {
    {name = 'SystemId', is_array = false, struct = nil},
    {name = 'Id', is_array = false, struct = nil}
}

function TExportReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'SystemId', self.SystemId, 'int32', false, errs)
    validate.Required(prefix .. 'Id', self.Id, 'string', false, errs)

    TExportReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExportReq.proto_property, errs)
    return self
end

function TExportReq:unpack(_)
    return self.SystemId, self.Id
end

msg.ExportReq = TExportReq

---@class UpdateService.RollbackRsp
local TRollbackRsp = {}
TRollbackRsp.__index = TRollbackRsp
TRollbackRsp.group = {}

local function TRollbackRsp_from_obj(obj)
    return setmetatable(obj, TRollbackRsp)
end

function TRollbackRsp.new()
    return TRollbackRsp_from_obj({})
end
---@param obj UpdateService.RollbackRsp
function TRollbackRsp:init_from_obj(obj)

end

function TRollbackRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRollbackRsp.group)
end

TRollbackRsp.from_obj = TRollbackRsp_from_obj

TRollbackRsp.proto_property = {}

TRollbackRsp.default = {}

TRollbackRsp.struct = {}

function TRollbackRsp:validate(prefix, errs)
    prefix = prefix or ''

    TRollbackRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRollbackRsp.proto_property, errs)
    return self
end

function TRollbackRsp:unpack(_)
end

msg.RollbackRsp = TRollbackRsp

---@class UpdateService.RollbackReq
---@field SystemId integer
---@field Id string
local TRollbackReq = {}
TRollbackReq.__index = TRollbackReq
TRollbackReq.group = {}

local function TRollbackReq_from_obj(obj)
    return setmetatable(obj, TRollbackReq)
end

function TRollbackReq.new(SystemId, Id)
    return TRollbackReq_from_obj({SystemId = SystemId, Id = Id})
end
---@param obj UpdateService.RollbackReq
function TRollbackReq:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.Id = obj.Id
end

function TRollbackReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRollbackReq.group)
end

TRollbackReq.from_obj = TRollbackReq_from_obj

TRollbackReq.proto_property = {'SystemId', 'Id'}

TRollbackReq.default = {0, ''}

TRollbackReq.struct = {
    {name = 'SystemId', is_array = false, struct = nil},
    {name = 'Id', is_array = false, struct = nil}
}

function TRollbackReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'SystemId', self.SystemId, 'int32', false, errs)
    validate.Required(prefix .. 'Id', self.Id, 'string', false, errs)

    TRollbackReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRollbackReq.proto_property, errs)
    return self
end

function TRollbackReq:unpack(_)
    return self.SystemId, self.Id
end

msg.RollbackReq = TRollbackReq

---@class UpdateService.RequestActiveActionRsp
local TRequestActiveActionRsp = {}
TRequestActiveActionRsp.__index = TRequestActiveActionRsp
TRequestActiveActionRsp.group = {}

local function TRequestActiveActionRsp_from_obj(obj)
    return setmetatable(obj, TRequestActiveActionRsp)
end

function TRequestActiveActionRsp.new()
    return TRequestActiveActionRsp_from_obj({})
end
---@param obj UpdateService.RequestActiveActionRsp
function TRequestActiveActionRsp:init_from_obj(obj)

end

function TRequestActiveActionRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRequestActiveActionRsp.group)
end

TRequestActiveActionRsp.from_obj = TRequestActiveActionRsp_from_obj

TRequestActiveActionRsp.proto_property = {}

TRequestActiveActionRsp.default = {}

TRequestActiveActionRsp.struct = {}

function TRequestActiveActionRsp:validate(prefix, errs)
    prefix = prefix or ''

    TRequestActiveActionRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRequestActiveActionRsp.proto_property, errs)
    return self
end

function TRequestActiveActionRsp:unpack(_)
end

msg.RequestActiveActionRsp = TRequestActiveActionRsp

---@class UpdateService.RequestActiveActionReq
---@field Id string
---@field Action defs.ActiveAction
local TRequestActiveActionReq = {}
TRequestActiveActionReq.__index = TRequestActiveActionReq
TRequestActiveActionReq.group = {}

local function TRequestActiveActionReq_from_obj(obj)
    obj.Action = obj.Action and defs.ActiveAction.new(obj.Action)
    return setmetatable(obj, TRequestActiveActionReq)
end

function TRequestActiveActionReq.new(Id, Action)
    return TRequestActiveActionReq_from_obj({Id = Id, Action = Action})
end
---@param obj UpdateService.RequestActiveActionReq
function TRequestActiveActionReq:init_from_obj(obj)
    self.Id = obj.Id
    self.Action = obj.Action
end

function TRequestActiveActionReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRequestActiveActionReq.group)
end

TRequestActiveActionReq.from_obj = TRequestActiveActionReq_from_obj

TRequestActiveActionReq.proto_property = {'Id', 'Action'}

TRequestActiveActionReq.default = {'', defs.ActiveAction.default}

TRequestActiveActionReq.struct = {
    {name = 'Id', is_array = false, struct = nil},
    {name = 'Action', is_array = false, struct = defs.ActiveAction.struct}
}

function TRequestActiveActionReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'string', false, errs)
    validate.Required(prefix .. 'Action', self.Action, 'defs.ActiveAction', false, errs)

    TRequestActiveActionReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRequestActiveActionReq.proto_property, errs)
    return self
end

function TRequestActiveActionReq:unpack(raw)
    local Action = utils.unpack_enum(raw, self.Action)
    return self.Id, Action
end

msg.RequestActiveActionReq = TRequestActiveActionReq

---@class UpdateService.UpdateActiveStatusRsp
local TUpdateActiveStatusRsp = {}
TUpdateActiveStatusRsp.__index = TUpdateActiveStatusRsp
TUpdateActiveStatusRsp.group = {}

local function TUpdateActiveStatusRsp_from_obj(obj)
    return setmetatable(obj, TUpdateActiveStatusRsp)
end

function TUpdateActiveStatusRsp.new()
    return TUpdateActiveStatusRsp_from_obj({})
end
---@param obj UpdateService.UpdateActiveStatusRsp
function TUpdateActiveStatusRsp:init_from_obj(obj)

end

function TUpdateActiveStatusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpdateActiveStatusRsp.group)
end

TUpdateActiveStatusRsp.from_obj = TUpdateActiveStatusRsp_from_obj

TUpdateActiveStatusRsp.proto_property = {}

TUpdateActiveStatusRsp.default = {}

TUpdateActiveStatusRsp.struct = {}

function TUpdateActiveStatusRsp:validate(prefix, errs)
    prefix = prefix or ''

    TUpdateActiveStatusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpdateActiveStatusRsp.proto_property, errs)
    return self
end

function TUpdateActiveStatusRsp:unpack(_)
end

msg.UpdateActiveStatusRsp = TUpdateActiveStatusRsp

---@class UpdateService.UpdateActiveStatusReq
---@field Id string
---@field Status defs.ActiveStatus
local TUpdateActiveStatusReq = {}
TUpdateActiveStatusReq.__index = TUpdateActiveStatusReq
TUpdateActiveStatusReq.group = {}

local function TUpdateActiveStatusReq_from_obj(obj)
    obj.Status = obj.Status and defs.ActiveStatus.new(obj.Status)
    return setmetatable(obj, TUpdateActiveStatusReq)
end

function TUpdateActiveStatusReq.new(Id, Status)
    return TUpdateActiveStatusReq_from_obj({Id = Id, Status = Status})
end
---@param obj UpdateService.UpdateActiveStatusReq
function TUpdateActiveStatusReq:init_from_obj(obj)
    self.Id = obj.Id
    self.Status = obj.Status
end

function TUpdateActiveStatusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpdateActiveStatusReq.group)
end

TUpdateActiveStatusReq.from_obj = TUpdateActiveStatusReq_from_obj

TUpdateActiveStatusReq.proto_property = {'Id', 'Status'}

TUpdateActiveStatusReq.default = {'', defs.ActiveStatus.default}

TUpdateActiveStatusReq.struct = {
    {name = 'Id', is_array = false, struct = nil},
    {name = 'Status', is_array = false, struct = defs.ActiveStatus.struct}
}

function TUpdateActiveStatusReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'string', false, errs)
    validate.Required(prefix .. 'Status', self.Status, 'defs.ActiveStatus', false, errs)

    TUpdateActiveStatusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpdateActiveStatusReq.proto_property, errs)
    return self
end

function TUpdateActiveStatusReq:unpack(raw)
    local Status = utils.unpack_enum(raw, self.Status)
    return self.Id, Status
end

msg.UpdateActiveStatusReq = TUpdateActiveStatusReq

---@class UpdateService.GetUpgradeStatusRsp
---@field FirmwareType string
---@field ResultCode integer
---@field Progress integer
---@field ResultDetail string
local TGetUpgradeStatusRsp = {}
TGetUpgradeStatusRsp.__index = TGetUpgradeStatusRsp
TGetUpgradeStatusRsp.group = {}

local function TGetUpgradeStatusRsp_from_obj(obj)
    return setmetatable(obj, TGetUpgradeStatusRsp)
end

function TGetUpgradeStatusRsp.new(FirmwareType, ResultCode, Progress, ResultDetail)
    return TGetUpgradeStatusRsp_from_obj({
        FirmwareType = FirmwareType,
        ResultCode = ResultCode,
        Progress = Progress,
        ResultDetail = ResultDetail
    })
end
---@param obj UpdateService.GetUpgradeStatusRsp
function TGetUpgradeStatusRsp:init_from_obj(obj)
    self.FirmwareType = obj.FirmwareType
    self.ResultCode = obj.ResultCode
    self.Progress = obj.Progress
    self.ResultDetail = obj.ResultDetail
end

function TGetUpgradeStatusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetUpgradeStatusRsp.group)
end

TGetUpgradeStatusRsp.from_obj = TGetUpgradeStatusRsp_from_obj

TGetUpgradeStatusRsp.proto_property = {'FirmwareType', 'ResultCode', 'Progress', 'ResultDetail'}

TGetUpgradeStatusRsp.default = {'', 0, 0, ''}

TGetUpgradeStatusRsp.struct = {
    {name = 'FirmwareType', is_array = false, struct = nil},
    {name = 'ResultCode', is_array = false, struct = nil},
    {name = 'Progress', is_array = false, struct = nil},
    {name = 'ResultDetail', is_array = false, struct = nil}
}

function TGetUpgradeStatusRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'FirmwareType', self.FirmwareType, 'string', false, errs)
    validate.Required(prefix .. 'ResultCode', self.ResultCode, 'int32', false, errs)
    validate.Required(prefix .. 'Progress', self.Progress, 'int32', false, errs)
    validate.Required(prefix .. 'ResultDetail', self.ResultDetail, 'string', false, errs)

    validate.ranges(prefix .. 'Progress', self.Progress, 0, 100, errs)
    validate.lens(prefix .. 'ResultDetail', self.ResultDetail, nil, 512, errs)

    TGetUpgradeStatusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetUpgradeStatusRsp.proto_property, errs)
    return self
end

function TGetUpgradeStatusRsp:unpack(_)
    return self.FirmwareType, self.ResultCode, self.Progress, self.ResultDetail
end

msg.GetUpgradeStatusRsp = TGetUpgradeStatusRsp

---@class UpdateService.GetUpgradeStatusReq
---@field TaskId integer
local TGetUpgradeStatusReq = {}
TGetUpgradeStatusReq.__index = TGetUpgradeStatusReq
TGetUpgradeStatusReq.group = {}

local function TGetUpgradeStatusReq_from_obj(obj)
    return setmetatable(obj, TGetUpgradeStatusReq)
end

function TGetUpgradeStatusReq.new(TaskId)
    return TGetUpgradeStatusReq_from_obj({TaskId = TaskId})
end
---@param obj UpdateService.GetUpgradeStatusReq
function TGetUpgradeStatusReq:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TGetUpgradeStatusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetUpgradeStatusReq.group)
end

TGetUpgradeStatusReq.from_obj = TGetUpgradeStatusReq_from_obj

TGetUpgradeStatusReq.proto_property = {'TaskId'}

TGetUpgradeStatusReq.default = {0}

TGetUpgradeStatusReq.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TGetUpgradeStatusReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs)

    TGetUpgradeStatusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetUpgradeStatusReq.proto_property, errs)
    return self
end

function TGetUpgradeStatusReq:unpack(_)
    return self.TaskId
end

msg.GetUpgradeStatusReq = TGetUpgradeStatusReq

---@class UpdateService.UpdateUpgradeStatusRsp
local TUpdateUpgradeStatusRsp = {}
TUpdateUpgradeStatusRsp.__index = TUpdateUpgradeStatusRsp
TUpdateUpgradeStatusRsp.group = {}

local function TUpdateUpgradeStatusRsp_from_obj(obj)
    return setmetatable(obj, TUpdateUpgradeStatusRsp)
end

function TUpdateUpgradeStatusRsp.new()
    return TUpdateUpgradeStatusRsp_from_obj({})
end
---@param obj UpdateService.UpdateUpgradeStatusRsp
function TUpdateUpgradeStatusRsp:init_from_obj(obj)

end

function TUpdateUpgradeStatusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpdateUpgradeStatusRsp.group)
end

TUpdateUpgradeStatusRsp.from_obj = TUpdateUpgradeStatusRsp_from_obj

TUpdateUpgradeStatusRsp.proto_property = {}

TUpdateUpgradeStatusRsp.default = {}

TUpdateUpgradeStatusRsp.struct = {}

function TUpdateUpgradeStatusRsp:validate(prefix, errs)
    prefix = prefix or ''

    TUpdateUpgradeStatusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpdateUpgradeStatusRsp.proto_property, errs)
    return self
end

function TUpdateUpgradeStatusRsp:unpack(_)
end

msg.UpdateUpgradeStatusRsp = TUpdateUpgradeStatusRsp

---@class UpdateService.UpdateUpgradeStatusReq
---@field SystemId integer
---@field FirmwareType string
---@field ResultCode integer
---@field Progress integer
---@field ResultDetail string
local TUpdateUpgradeStatusReq = {}
TUpdateUpgradeStatusReq.__index = TUpdateUpgradeStatusReq
TUpdateUpgradeStatusReq.group = {}

local function TUpdateUpgradeStatusReq_from_obj(obj)
    return setmetatable(obj, TUpdateUpgradeStatusReq)
end

function TUpdateUpgradeStatusReq.new(SystemId, FirmwareType, ResultCode, Progress, ResultDetail)
    return TUpdateUpgradeStatusReq_from_obj({
        SystemId = SystemId,
        FirmwareType = FirmwareType,
        ResultCode = ResultCode,
        Progress = Progress,
        ResultDetail = ResultDetail
    })
end
---@param obj UpdateService.UpdateUpgradeStatusReq
function TUpdateUpgradeStatusReq:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.FirmwareType = obj.FirmwareType
    self.ResultCode = obj.ResultCode
    self.Progress = obj.Progress
    self.ResultDetail = obj.ResultDetail
end

function TUpdateUpgradeStatusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpdateUpgradeStatusReq.group)
end

TUpdateUpgradeStatusReq.from_obj = TUpdateUpgradeStatusReq_from_obj

TUpdateUpgradeStatusReq.proto_property = {
    'SystemId', 'FirmwareType', 'ResultCode', 'Progress', 'ResultDetail'
}

TUpdateUpgradeStatusReq.default = {0, '', 0, 0, ''}

TUpdateUpgradeStatusReq.struct = {
    {name = 'SystemId', is_array = false, struct = nil},
    {name = 'FirmwareType', is_array = false, struct = nil},
    {name = 'ResultCode', is_array = false, struct = nil},
    {name = 'Progress', is_array = false, struct = nil},
    {name = 'ResultDetail', is_array = false, struct = nil}
}

function TUpdateUpgradeStatusReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'SystemId', self.SystemId, 'int32', false, errs)
    validate.Required(prefix .. 'FirmwareType', self.FirmwareType, 'string', false, errs)
    validate.Required(prefix .. 'ResultCode', self.ResultCode, 'int32', false, errs)
    validate.Required(prefix .. 'Progress', self.Progress, 'int32', false, errs)
    validate.Required(prefix .. 'ResultDetail', self.ResultDetail, 'string', false, errs)

    validate.ranges(prefix .. 'Progress', self.Progress, 0, 100, errs)
    validate.lens(prefix .. 'ResultDetail', self.ResultDetail, nil, 512, errs)

    TUpdateUpgradeStatusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpdateUpgradeStatusReq.proto_property, errs)
    return self
end

function TUpdateUpgradeStatusReq:unpack(_)
    return self.SystemId, self.FirmwareType, self.ResultCode, self.Progress, self.ResultDetail
end

msg.UpdateUpgradeStatusReq = TUpdateUpgradeStatusReq

---@class UpdateService.FinishReplyRsp
local TFinishReplyRsp = {}
TFinishReplyRsp.__index = TFinishReplyRsp
TFinishReplyRsp.group = {}

local function TFinishReplyRsp_from_obj(obj)
    return setmetatable(obj, TFinishReplyRsp)
end

function TFinishReplyRsp.new()
    return TFinishReplyRsp_from_obj({})
end
---@param obj UpdateService.FinishReplyRsp
function TFinishReplyRsp:init_from_obj(obj)

end

function TFinishReplyRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFinishReplyRsp.group)
end

TFinishReplyRsp.from_obj = TFinishReplyRsp_from_obj

TFinishReplyRsp.proto_property = {}

TFinishReplyRsp.default = {}

TFinishReplyRsp.struct = {}

function TFinishReplyRsp:validate(prefix, errs)
    prefix = prefix or ''

    TFinishReplyRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFinishReplyRsp.proto_property, errs)
    return self
end

function TFinishReplyRsp:unpack(_)
end

msg.FinishReplyRsp = TFinishReplyRsp

---@class UpdateService.FinishReplyReq
---@field SystemId integer
---@field FirmwareType string
---@field FinishResult integer
local TFinishReplyReq = {}
TFinishReplyReq.__index = TFinishReplyReq
TFinishReplyReq.group = {}

local function TFinishReplyReq_from_obj(obj)
    return setmetatable(obj, TFinishReplyReq)
end

function TFinishReplyReq.new(SystemId, FirmwareType, FinishResult)
    return TFinishReplyReq_from_obj({
        SystemId = SystemId,
        FirmwareType = FirmwareType,
        FinishResult = FinishResult
    })
end
---@param obj UpdateService.FinishReplyReq
function TFinishReplyReq:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.FirmwareType = obj.FirmwareType
    self.FinishResult = obj.FinishResult
end

function TFinishReplyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFinishReplyReq.group)
end

TFinishReplyReq.from_obj = TFinishReplyReq_from_obj

TFinishReplyReq.proto_property = {'SystemId', 'FirmwareType', 'FinishResult'}

TFinishReplyReq.default = {0, '', 0}

TFinishReplyReq.struct = {
    {name = 'SystemId', is_array = false, struct = nil},
    {name = 'FirmwareType', is_array = false, struct = nil},
    {name = 'FinishResult', is_array = false, struct = nil}
}

function TFinishReplyReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'SystemId', self.SystemId, 'int32', false, errs)
    validate.Required(prefix .. 'FirmwareType', self.FirmwareType, 'string', false, errs)
    validate.Required(prefix .. 'FinishResult', self.FinishResult, 'int32', false, errs)

    TFinishReplyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFinishReplyReq.proto_property, errs)
    return self
end

function TFinishReplyReq:unpack(_)
    return self.SystemId, self.FirmwareType, self.FinishResult
end

msg.FinishReplyReq = TFinishReplyReq

---@class UpdateService.ProcessReplyRsp
local TProcessReplyRsp = {}
TProcessReplyRsp.__index = TProcessReplyRsp
TProcessReplyRsp.group = {}

local function TProcessReplyRsp_from_obj(obj)
    return setmetatable(obj, TProcessReplyRsp)
end

function TProcessReplyRsp.new()
    return TProcessReplyRsp_from_obj({})
end
---@param obj UpdateService.ProcessReplyRsp
function TProcessReplyRsp:init_from_obj(obj)

end

function TProcessReplyRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TProcessReplyRsp.group)
end

TProcessReplyRsp.from_obj = TProcessReplyRsp_from_obj

TProcessReplyRsp.proto_property = {}

TProcessReplyRsp.default = {}

TProcessReplyRsp.struct = {}

function TProcessReplyRsp:validate(prefix, errs)
    prefix = prefix or ''

    TProcessReplyRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TProcessReplyRsp.proto_property, errs)
    return self
end

function TProcessReplyRsp:unpack(_)
end

msg.ProcessReplyRsp = TProcessReplyRsp

---@class UpdateService.ProcessReplyReq
---@field SystemId integer
---@field FirmwareType string
---@field ProcessResult integer
local TProcessReplyReq = {}
TProcessReplyReq.__index = TProcessReplyReq
TProcessReplyReq.group = {}

local function TProcessReplyReq_from_obj(obj)
    return setmetatable(obj, TProcessReplyReq)
end

function TProcessReplyReq.new(SystemId, FirmwareType, ProcessResult)
    return TProcessReplyReq_from_obj({
        SystemId = SystemId,
        FirmwareType = FirmwareType,
        ProcessResult = ProcessResult
    })
end
---@param obj UpdateService.ProcessReplyReq
function TProcessReplyReq:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.FirmwareType = obj.FirmwareType
    self.ProcessResult = obj.ProcessResult
end

function TProcessReplyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TProcessReplyReq.group)
end

TProcessReplyReq.from_obj = TProcessReplyReq_from_obj

TProcessReplyReq.proto_property = {'SystemId', 'FirmwareType', 'ProcessResult'}

TProcessReplyReq.default = {0, '', 0}

TProcessReplyReq.struct = {
    {name = 'SystemId', is_array = false, struct = nil},
    {name = 'FirmwareType', is_array = false, struct = nil},
    {name = 'ProcessResult', is_array = false, struct = nil}
}

function TProcessReplyReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'SystemId', self.SystemId, 'int32', false, errs)
    validate.Required(prefix .. 'FirmwareType', self.FirmwareType, 'string', false, errs)
    validate.Required(prefix .. 'ProcessResult', self.ProcessResult, 'int32', false, errs)

    TProcessReplyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TProcessReplyReq.proto_property, errs)
    return self
end

function TProcessReplyReq:unpack(_)
    return self.SystemId, self.FirmwareType, self.ProcessResult
end

msg.ProcessReplyReq = TProcessReplyReq

---@class UpdateService.PrepareReplyRsp
local TPrepareReplyRsp = {}
TPrepareReplyRsp.__index = TPrepareReplyRsp
TPrepareReplyRsp.group = {}

local function TPrepareReplyRsp_from_obj(obj)
    return setmetatable(obj, TPrepareReplyRsp)
end

function TPrepareReplyRsp.new()
    return TPrepareReplyRsp_from_obj({})
end
---@param obj UpdateService.PrepareReplyRsp
function TPrepareReplyRsp:init_from_obj(obj)

end

function TPrepareReplyRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPrepareReplyRsp.group)
end

TPrepareReplyRsp.from_obj = TPrepareReplyRsp_from_obj

TPrepareReplyRsp.proto_property = {}

TPrepareReplyRsp.default = {}

TPrepareReplyRsp.struct = {}

function TPrepareReplyRsp:validate(prefix, errs)
    prefix = prefix or ''

    TPrepareReplyRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPrepareReplyRsp.proto_property, errs)
    return self
end

function TPrepareReplyRsp:unpack(_)
end

msg.PrepareReplyRsp = TPrepareReplyRsp

---@class UpdateService.PrepareReplyReq
---@field SystemId integer
---@field FirmwareType string
---@field VersionStr string
---@field PrepareResult integer
local TPrepareReplyReq = {}
TPrepareReplyReq.__index = TPrepareReplyReq
TPrepareReplyReq.group = {}

local function TPrepareReplyReq_from_obj(obj)
    return setmetatable(obj, TPrepareReplyReq)
end

function TPrepareReplyReq.new(SystemId, FirmwareType, VersionStr, PrepareResult)
    return TPrepareReplyReq_from_obj({
        SystemId = SystemId,
        FirmwareType = FirmwareType,
        VersionStr = VersionStr,
        PrepareResult = PrepareResult
    })
end
---@param obj UpdateService.PrepareReplyReq
function TPrepareReplyReq:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.FirmwareType = obj.FirmwareType
    self.VersionStr = obj.VersionStr
    self.PrepareResult = obj.PrepareResult
end

function TPrepareReplyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPrepareReplyReq.group)
end

TPrepareReplyReq.from_obj = TPrepareReplyReq_from_obj

TPrepareReplyReq.proto_property = {'SystemId', 'FirmwareType', 'VersionStr', 'PrepareResult'}

TPrepareReplyReq.default = {0, '', '', 0}

TPrepareReplyReq.struct = {
    {name = 'SystemId', is_array = false, struct = nil},
    {name = 'FirmwareType', is_array = false, struct = nil},
    {name = 'VersionStr', is_array = false, struct = nil},
    {name = 'PrepareResult', is_array = false, struct = nil}
}

function TPrepareReplyReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'SystemId', self.SystemId, 'int32', false, errs)
    validate.Required(prefix .. 'FirmwareType', self.FirmwareType, 'string', false, errs)
    validate.Required(prefix .. 'VersionStr', self.VersionStr, 'string', false, errs)
    validate.Required(prefix .. 'PrepareResult', self.PrepareResult, 'int32', false, errs)

    TPrepareReplyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPrepareReplyReq.proto_property, errs)
    return self
end

function TPrepareReplyReq:unpack(_)
    return self.SystemId, self.FirmwareType, self.VersionStr, self.PrepareResult
end

msg.PrepareReplyReq = TPrepareReplyReq

---@class UpdateService.StartUpgradeRsp
---@field TaskId integer
local TStartUpgradeRsp = {}
TStartUpgradeRsp.__index = TStartUpgradeRsp
TStartUpgradeRsp.group = {}

local function TStartUpgradeRsp_from_obj(obj)
    return setmetatable(obj, TStartUpgradeRsp)
end

function TStartUpgradeRsp.new(TaskId)
    return TStartUpgradeRsp_from_obj({TaskId = TaskId})
end
---@param obj UpdateService.StartUpgradeRsp
function TStartUpgradeRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TStartUpgradeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartUpgradeRsp.group)
end

TStartUpgradeRsp.from_obj = TStartUpgradeRsp_from_obj

TStartUpgradeRsp.proto_property = {'TaskId'}

TStartUpgradeRsp.default = {0}

TStartUpgradeRsp.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TStartUpgradeRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs)

    TStartUpgradeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartUpgradeRsp.proto_property, errs)
    return self
end

function TStartUpgradeRsp:unpack(_)
    return self.TaskId
end

msg.StartUpgradeRsp = TStartUpgradeRsp

---@class UpdateService.StartUpgradeReq
---@field SystemId integer
---@field FilePath string
local TStartUpgradeReq = {}
TStartUpgradeReq.__index = TStartUpgradeReq
TStartUpgradeReq.group = {}

local function TStartUpgradeReq_from_obj(obj)
    return setmetatable(obj, TStartUpgradeReq)
end

function TStartUpgradeReq.new(SystemId, FilePath)
    return TStartUpgradeReq_from_obj({SystemId = SystemId, FilePath = FilePath})
end
---@param obj UpdateService.StartUpgradeReq
function TStartUpgradeReq:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.FilePath = obj.FilePath
end

function TStartUpgradeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartUpgradeReq.group)
end

TStartUpgradeReq.from_obj = TStartUpgradeReq_from_obj

TStartUpgradeReq.proto_property = {'SystemId', 'FilePath'}

TStartUpgradeReq.default = {0, ''}

TStartUpgradeReq.struct = {
    {name = 'SystemId', is_array = false, struct = nil},
    {name = 'FilePath', is_array = false, struct = nil}
}

function TStartUpgradeReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'SystemId', self.SystemId, 'int32', false, errs)
    validate.Required(prefix .. 'FilePath', self.FilePath, 'string', false, errs)

    TStartUpgradeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartUpgradeReq.proto_property, errs)
    return self
end

function TStartUpgradeReq:unpack(_)
    return self.SystemId, self.FilePath
end

msg.StartUpgradeReq = TStartUpgradeReq

local UpdateService = {}

local Mdb = require 'mc.mdb'

---@class UpdateService: Table
UpdateService.UpdateService = Mdb.register_interface('bmc.kepler.UpdateService', {}, {
    StartUpgrade = {'a{ss}is', 'u', msg.StartUpgradeReq, msg.StartUpgradeRsp},
    PrepareReply = {'a{ss}issi', '', msg.PrepareReplyReq, msg.PrepareReplyRsp},
    ProcessReply = {'a{ss}isi', '', msg.ProcessReplyReq, msg.ProcessReplyRsp},
    FinishReply = {'a{ss}isi', '', msg.FinishReplyReq, msg.FinishReplyRsp},
    UpdateUpgradeStatus = {'a{ss}isiis', '', msg.UpdateUpgradeStatusReq, msg.UpdateUpgradeStatusRsp},
    GetUpgradeStatus = {'a{ss}u', 'siis', msg.GetUpgradeStatusReq, msg.GetUpgradeStatusRsp},
    UpdateActiveStatus = {'a{ss}si', '', msg.UpdateActiveStatusReq, msg.UpdateActiveStatusRsp},
    RequestActiveAction = {'a{ss}si', '', msg.RequestActiveActionReq, msg.RequestActiveActionRsp},
    Rollback = {'a{ss}is', '', msg.RollbackReq, msg.RollbackRsp},
    Export = {'a{ss}is', '', msg.ExportReq, msg.ExportRsp}
}, {})
return UpdateService
