-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local FirmwareInfo = {}

local Mdb = require 'mc.mdb'

---@class FirmwareInfo: Table
---@field Id string
---@field Name string
---@field Version string
---@field BuildNum string
---@field ReleaseDate string
---@field LowestSupportedVersion string
---@field SoftwareId string
---@field Manufacturer string
---@field Updateable boolean
---@field Location string
FirmwareInfo.FirmwareInfo = Mdb.register_interface('bmc.kepler.UpdateService.FirmwareInfo', {
    Id = {'s', nil, true, nil},
    Name = {'s', nil, true, nil},
    Version = {'s', nil, false, nil},
    BuildNum = {'s', nil, true, nil},
    ReleaseDate = {'s', nil, true, nil},
    LowestSupportedVersion = {'s', nil, true, nil},
    SoftwareId = {'s', nil, true, nil},
    Manufacturer = {'s', nil, true, nil},
    Updateable = {'b', nil, true, nil},
    Location = {'s', nil, true, nil}
}, {}, {})
return FirmwareInfo
