-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local ThresholdSensor = {}

local Mdb = require 'mc.mdb'

---@class IThresholdSensor: Table
---@field OwnerId integer
---@field OwnerLun integer
---@field EntityId integer
---@field EntityInstance integer
---@field Initialization integer
---@field Capabilities integer
---@field SensorType integer
---@field ReadingType integer
---@field SensorName string
---@field AssertMask integer
---@field DeassertMask integer
---@field ReadingMask integer
---@field Unit integer
---@field BaseUnit integer
---@field ModifierUnit integer
---@field Linearization integer
---@field M integer
---@field MT integer
---@field B integer
---@field BA integer
---@field Accuracy integer
---@field RBExp integer
---@field Analog integer
---@field NormalReading integer
---@field NormalMaximum integer
---@field NormalMinimum integer
---@field MaximumReading integer
---@field MinimumReading integer
---@field UpperNonrecoverable integer
---@field UpperCritical integer
---@field UpperNoncritical integer
---@field LowerNonrecoverable integer
---@field LowerNoncritical integer
---@field LowerCritical integer
---@field PosHysteresis integer
---@field NegHysteresis integer
---@field Reading integer
---@field SensorNumber integer
---@field ReadingStatus integer
---@field Health integer
ThresholdSensor.IThresholdSensor = Mdb.register_interface('bmc.kepler.Systems.ThresholdSensor', {
    OwnerId = {'y', nil, true, nil},
    OwnerLun = {'y', nil, true, nil},
    EntityId = {'y', nil, true, nil},
    EntityInstance = {'y', nil, true, nil},
    Initialization = {'y', nil, true, nil},
    Capabilities = {'y', nil, true, nil},
    SensorType = {'y', nil, true, nil},
    ReadingType = {'y', nil, true, nil},
    SensorName = {'s', nil, true, nil},
    AssertMask = {'q', nil, true, nil},
    DeassertMask = {'q', nil, true, nil},
    ReadingMask = {'q', nil, true, nil},
    Unit = {'y', nil, true, nil},
    BaseUnit = {'y', nil, true, nil},
    ModifierUnit = {'y', nil, true, nil},
    Linearization = {'y', nil, true, nil},
    M = {'y', nil, true, nil},
    MT = {'y', nil, true, nil},
    B = {'y', nil, true, nil},
    BA = {'y', nil, true, nil},
    Accuracy = {'y', nil, true, nil},
    RBExp = {'y', nil, true, nil},
    Analog = {'y', nil, true, nil},
    NormalReading = {'y', nil, true, nil},
    NormalMaximum = {'y', nil, true, nil},
    NormalMinimum = {'y', nil, true, nil},
    MaximumReading = {'y', nil, true, nil},
    MinimumReading = {'y', nil, true, nil},
    UpperNonrecoverable = {'y', nil, true, nil},
    UpperCritical = {'y', nil, true, nil},
    UpperNoncritical = {'y', nil, true, nil},
    LowerNonrecoverable = {'y', nil, true, nil},
    LowerNoncritical = {'y', nil, true, nil},
    LowerCritical = {'y', nil, true, nil},
    PosHysteresis = {'y', nil, true, nil},
    NegHysteresis = {'y', nil, true, nil},
    Reading = {'q', nil, false, nil},
    SensorNumber = {'y', nil, true, nil},
    ReadingStatus = {'y', nil, false, nil},
    Health = {'y', nil, true, nil}
}, {}, {})

return ThresholdSensor
