-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class Drive.SetPatrolStateRsp
---@field Code integer
local TSetPatrolStateRsp = {}
TSetPatrolStateRsp.__index = TSetPatrolStateRsp
TSetPatrolStateRsp.group = {}

local function TSetPatrolStateRsp_from_obj(obj)
    return setmetatable(obj, TSetPatrolStateRsp)
end

function TSetPatrolStateRsp.new(Code)
    return TSetPatrolStateRsp_from_obj({Code = Code})
end
---@param obj Drive.SetPatrolStateRsp
function TSetPatrolStateRsp:init_from_obj(obj)
    self.Code = obj.Code
end

function TSetPatrolStateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPatrolStateRsp.group)
end

TSetPatrolStateRsp.from_obj = TSetPatrolStateRsp_from_obj

TSetPatrolStateRsp.proto_property = {'Code'}

TSetPatrolStateRsp.default = {0}

TSetPatrolStateRsp.struct = {{name = 'Code', is_array = false, struct = nil}}

function TSetPatrolStateRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Code', self.Code, 'uint8', false, errs)

    TSetPatrolStateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPatrolStateRsp.proto_property, errs)
    return self
end

function TSetPatrolStateRsp:unpack(_)
    return self.Code
end

msg.SetPatrolStateRsp = TSetPatrolStateRsp

---@class Drive.SetPatrolStateReq
---@field DriveName string
---@field PatrolState integer
local TSetPatrolStateReq = {}
TSetPatrolStateReq.__index = TSetPatrolStateReq
TSetPatrolStateReq.group = {}

local function TSetPatrolStateReq_from_obj(obj)
    return setmetatable(obj, TSetPatrolStateReq)
end

function TSetPatrolStateReq.new(DriveName, PatrolState)
    return TSetPatrolStateReq_from_obj({DriveName = DriveName, PatrolState = PatrolState})
end
---@param obj Drive.SetPatrolStateReq
function TSetPatrolStateReq:init_from_obj(obj)
    self.DriveName = obj.DriveName
    self.PatrolState = obj.PatrolState
end

function TSetPatrolStateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPatrolStateReq.group)
end

TSetPatrolStateReq.from_obj = TSetPatrolStateReq_from_obj

TSetPatrolStateReq.proto_property = {'DriveName', 'PatrolState'}

TSetPatrolStateReq.default = {'', 0}

TSetPatrolStateReq.struct = {
    {name = 'DriveName', is_array = false, struct = nil},
    {name = 'PatrolState', is_array = false, struct = nil}
}

function TSetPatrolStateReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'DriveName', self.DriveName, 'string', false, errs)
    validate.Required(prefix .. 'PatrolState', self.PatrolState, 'uint8', false, errs)

    TSetPatrolStateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPatrolStateReq.proto_property, errs)
    return self
end

function TSetPatrolStateReq:unpack(_)
    return self.DriveName, self.PatrolState
end

msg.SetPatrolStateReq = TSetPatrolStateReq

---@class Drive.SetBootPriorityRsp
---@field Code integer
local TSetBootPriorityRsp = {}
TSetBootPriorityRsp.__index = TSetBootPriorityRsp
TSetBootPriorityRsp.group = {}

local function TSetBootPriorityRsp_from_obj(obj)
    return setmetatable(obj, TSetBootPriorityRsp)
end

function TSetBootPriorityRsp.new(Code)
    return TSetBootPriorityRsp_from_obj({Code = Code})
end
---@param obj Drive.SetBootPriorityRsp
function TSetBootPriorityRsp:init_from_obj(obj)
    self.Code = obj.Code
end

function TSetBootPriorityRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBootPriorityRsp.group)
end

TSetBootPriorityRsp.from_obj = TSetBootPriorityRsp_from_obj

TSetBootPriorityRsp.proto_property = {'Code'}

TSetBootPriorityRsp.default = {0}

TSetBootPriorityRsp.struct = {{name = 'Code', is_array = false, struct = nil}}

function TSetBootPriorityRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Code', self.Code, 'uint8', false, errs)

    TSetBootPriorityRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBootPriorityRsp.proto_property, errs)
    return self
end

function TSetBootPriorityRsp:unpack(_)
    return self.Code
end

msg.SetBootPriorityRsp = TSetBootPriorityRsp

---@class Drive.SetBootPriorityReq
---@field DriveName string
---@field BootPriority integer
local TSetBootPriorityReq = {}
TSetBootPriorityReq.__index = TSetBootPriorityReq
TSetBootPriorityReq.group = {}

local function TSetBootPriorityReq_from_obj(obj)
    return setmetatable(obj, TSetBootPriorityReq)
end

function TSetBootPriorityReq.new(DriveName, BootPriority)
    return TSetBootPriorityReq_from_obj({DriveName = DriveName, BootPriority = BootPriority})
end
---@param obj Drive.SetBootPriorityReq
function TSetBootPriorityReq:init_from_obj(obj)
    self.DriveName = obj.DriveName
    self.BootPriority = obj.BootPriority
end

function TSetBootPriorityReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBootPriorityReq.group)
end

TSetBootPriorityReq.from_obj = TSetBootPriorityReq_from_obj

TSetBootPriorityReq.proto_property = {'DriveName', 'BootPriority'}

TSetBootPriorityReq.default = {'', 0}

TSetBootPriorityReq.struct = {
    {name = 'DriveName', is_array = false, struct = nil},
    {name = 'BootPriority', is_array = false, struct = nil}
}

function TSetBootPriorityReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'DriveName', self.DriveName, 'string', false, errs)
    validate.Required(prefix .. 'BootPriority', self.BootPriority, 'uint8', false, errs)

    TSetBootPriorityReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBootPriorityReq.proto_property, errs)
    return self
end

function TSetBootPriorityReq:unpack(_)
    return self.DriveName, self.BootPriority
end

msg.SetBootPriorityReq = TSetBootPriorityReq

---@class Drive.SetHotspareTypeRsp
---@field Code integer
local TSetHotspareTypeRsp = {}
TSetHotspareTypeRsp.__index = TSetHotspareTypeRsp
TSetHotspareTypeRsp.group = {}

local function TSetHotspareTypeRsp_from_obj(obj)
    return setmetatable(obj, TSetHotspareTypeRsp)
end

function TSetHotspareTypeRsp.new(Code)
    return TSetHotspareTypeRsp_from_obj({Code = Code})
end
---@param obj Drive.SetHotspareTypeRsp
function TSetHotspareTypeRsp:init_from_obj(obj)
    self.Code = obj.Code
end

function TSetHotspareTypeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetHotspareTypeRsp.group)
end

TSetHotspareTypeRsp.from_obj = TSetHotspareTypeRsp_from_obj

TSetHotspareTypeRsp.proto_property = {'Code'}

TSetHotspareTypeRsp.default = {0}

TSetHotspareTypeRsp.struct = {{name = 'Code', is_array = false, struct = nil}}

function TSetHotspareTypeRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Code', self.Code, 'uint8', false, errs)

    TSetHotspareTypeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetHotspareTypeRsp.proto_property, errs)
    return self
end

function TSetHotspareTypeRsp:unpack(_)
    return self.Code
end

msg.SetHotspareTypeRsp = TSetHotspareTypeRsp

---@class Drive.SetHotspareTypeReq
---@field DriveName string
---@field HotspareType integer
local TSetHotspareTypeReq = {}
TSetHotspareTypeReq.__index = TSetHotspareTypeReq
TSetHotspareTypeReq.group = {}

local function TSetHotspareTypeReq_from_obj(obj)
    return setmetatable(obj, TSetHotspareTypeReq)
end

function TSetHotspareTypeReq.new(DriveName, HotspareType)
    return TSetHotspareTypeReq_from_obj({DriveName = DriveName, HotspareType = HotspareType})
end
---@param obj Drive.SetHotspareTypeReq
function TSetHotspareTypeReq:init_from_obj(obj)
    self.DriveName = obj.DriveName
    self.HotspareType = obj.HotspareType
end

function TSetHotspareTypeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetHotspareTypeReq.group)
end

TSetHotspareTypeReq.from_obj = TSetHotspareTypeReq_from_obj

TSetHotspareTypeReq.proto_property = {'DriveName', 'HotspareType'}

TSetHotspareTypeReq.default = {'', 0}

TSetHotspareTypeReq.struct = {
    {name = 'DriveName', is_array = false, struct = nil},
    {name = 'HotspareType', is_array = false, struct = nil}
}

function TSetHotspareTypeReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'DriveName', self.DriveName, 'string', false, errs)
    validate.Required(prefix .. 'HotspareType', self.HotspareType, 'uint8', false, errs)

    TSetHotspareTypeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetHotspareTypeReq.proto_property, errs)
    return self
end

function TSetHotspareTypeReq:unpack(_)
    return self.DriveName, self.HotspareType
end

msg.SetHotspareTypeReq = TSetHotspareTypeReq

---@class Drive.SetFirmwareStatusRsp
---@field Code integer
local TSetFirmwareStatusRsp = {}
TSetFirmwareStatusRsp.__index = TSetFirmwareStatusRsp
TSetFirmwareStatusRsp.group = {}

local function TSetFirmwareStatusRsp_from_obj(obj)
    return setmetatable(obj, TSetFirmwareStatusRsp)
end

function TSetFirmwareStatusRsp.new(Code)
    return TSetFirmwareStatusRsp_from_obj({Code = Code})
end
---@param obj Drive.SetFirmwareStatusRsp
function TSetFirmwareStatusRsp:init_from_obj(obj)
    self.Code = obj.Code
end

function TSetFirmwareStatusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetFirmwareStatusRsp.group)
end

TSetFirmwareStatusRsp.from_obj = TSetFirmwareStatusRsp_from_obj

TSetFirmwareStatusRsp.proto_property = {'Code'}

TSetFirmwareStatusRsp.default = {0}

TSetFirmwareStatusRsp.struct = {{name = 'Code', is_array = false, struct = nil}}

function TSetFirmwareStatusRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Code', self.Code, 'uint8', false, errs)

    TSetFirmwareStatusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetFirmwareStatusRsp.proto_property, errs)
    return self
end

function TSetFirmwareStatusRsp:unpack(_)
    return self.Code
end

msg.SetFirmwareStatusRsp = TSetFirmwareStatusRsp

---@class Drive.SetFirmwareStatusReq
---@field DriveName string
---@field FirmwareStatus integer
local TSetFirmwareStatusReq = {}
TSetFirmwareStatusReq.__index = TSetFirmwareStatusReq
TSetFirmwareStatusReq.group = {}

local function TSetFirmwareStatusReq_from_obj(obj)
    return setmetatable(obj, TSetFirmwareStatusReq)
end

function TSetFirmwareStatusReq.new(DriveName, FirmwareStatus)
    return TSetFirmwareStatusReq_from_obj({DriveName = DriveName, FirmwareStatus = FirmwareStatus})
end
---@param obj Drive.SetFirmwareStatusReq
function TSetFirmwareStatusReq:init_from_obj(obj)
    self.DriveName = obj.DriveName
    self.FirmwareStatus = obj.FirmwareStatus
end

function TSetFirmwareStatusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetFirmwareStatusReq.group)
end

TSetFirmwareStatusReq.from_obj = TSetFirmwareStatusReq_from_obj

TSetFirmwareStatusReq.proto_property = {'DriveName', 'FirmwareStatus'}

TSetFirmwareStatusReq.default = {'', 0}

TSetFirmwareStatusReq.struct = {
    {name = 'DriveName', is_array = false, struct = nil},
    {name = 'FirmwareStatus', is_array = false, struct = nil}
}

function TSetFirmwareStatusReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'DriveName', self.DriveName, 'string', false, errs)
    validate.Required(prefix .. 'FirmwareStatus', self.FirmwareStatus, 'uint8', false, errs)

    TSetFirmwareStatusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetFirmwareStatusReq.proto_property, errs)
    return self
end

function TSetFirmwareStatusReq:unpack(_)
    return self.DriveName, self.FirmwareStatus
end

msg.SetFirmwareStatusReq = TSetFirmwareStatusReq

---@class Drive.SetLocationIndicatorStateRsp
---@field Code integer
local TSetLocationIndicatorStateRsp = {}
TSetLocationIndicatorStateRsp.__index = TSetLocationIndicatorStateRsp
TSetLocationIndicatorStateRsp.group = {}

local function TSetLocationIndicatorStateRsp_from_obj(obj)
    return setmetatable(obj, TSetLocationIndicatorStateRsp)
end

function TSetLocationIndicatorStateRsp.new(Code)
    return TSetLocationIndicatorStateRsp_from_obj({Code = Code})
end
---@param obj Drive.SetLocationIndicatorStateRsp
function TSetLocationIndicatorStateRsp:init_from_obj(obj)
    self.Code = obj.Code
end

function TSetLocationIndicatorStateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetLocationIndicatorStateRsp.group)
end

TSetLocationIndicatorStateRsp.from_obj = TSetLocationIndicatorStateRsp_from_obj

TSetLocationIndicatorStateRsp.proto_property = {'Code'}

TSetLocationIndicatorStateRsp.default = {0}

TSetLocationIndicatorStateRsp.struct = {{name = 'Code', is_array = false, struct = nil}}

function TSetLocationIndicatorStateRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Code', self.Code, 'uint8', false, errs)

    TSetLocationIndicatorStateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetLocationIndicatorStateRsp.proto_property, errs)
    return self
end

function TSetLocationIndicatorStateRsp:unpack(_)
    return self.Code
end

msg.SetLocationIndicatorStateRsp = TSetLocationIndicatorStateRsp

---@class Drive.SetLocationIndicatorStateReq
---@field DriveName string
---@field LocationIndicatorState integer
local TSetLocationIndicatorStateReq = {}
TSetLocationIndicatorStateReq.__index = TSetLocationIndicatorStateReq
TSetLocationIndicatorStateReq.group = {}

local function TSetLocationIndicatorStateReq_from_obj(obj)
    return setmetatable(obj, TSetLocationIndicatorStateReq)
end

function TSetLocationIndicatorStateReq.new(DriveName, LocationIndicatorState)
    return TSetLocationIndicatorStateReq_from_obj({
        DriveName = DriveName,
        LocationIndicatorState = LocationIndicatorState
    })
end
---@param obj Drive.SetLocationIndicatorStateReq
function TSetLocationIndicatorStateReq:init_from_obj(obj)
    self.DriveName = obj.DriveName
    self.LocationIndicatorState = obj.LocationIndicatorState
end

function TSetLocationIndicatorStateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetLocationIndicatorStateReq.group)
end

TSetLocationIndicatorStateReq.from_obj = TSetLocationIndicatorStateReq_from_obj

TSetLocationIndicatorStateReq.proto_property = {'DriveName', 'LocationIndicatorState'}

TSetLocationIndicatorStateReq.default = {'', 0}

TSetLocationIndicatorStateReq.struct = {
    {name = 'DriveName', is_array = false, struct = nil},
    {name = 'LocationIndicatorState', is_array = false, struct = nil}
}

function TSetLocationIndicatorStateReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'DriveName', self.DriveName, 'string', false, errs)
    validate.Required(prefix .. 'LocationIndicatorState', self.LocationIndicatorState, 'uint8',
        false, errs)

    TSetLocationIndicatorStateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetLocationIndicatorStateReq.proto_property, errs)
    return self
end

function TSetLocationIndicatorStateReq:unpack(_)
    return self.DriveName, self.LocationIndicatorState
end

msg.SetLocationIndicatorStateReq = TSetLocationIndicatorStateReq

local Drive = {}

local Mdb = require 'mc.mdb'

---@class Drive: Table
---@field Id integer
---@field SlotNumber integer
---@field Name string
---@field Presence integer
---@field CapacityMiB integer
---@field TemperatureCelsius integer
---@field Model string
---@field EnclosureId integer
---@field LocationIndicatorState integer
---@field LocateLed integer
---@field FaultLed integer
---@field Protocol integer
---@field CapableSpeedGbs integer
---@field NegotiatedSpeedGbs integer
---@field MediaType integer
---@field FirmwareStatus integer
---@field SerialNumber string
---@field Manufacturer string
---@field PowerOnHours integer
---@field Revision string
---@field RotationSpeedRPM integer
---@field BlockSizeBytes integer
---@field SASAddress1 string
---@field SASAddress2 string
---@field PredictedMediaLifeLeftPercent integer
---@field PredictedFailCount integer
---@field MediaErrorCount integer
---@field OtherErrorCount integer
---@field PatrolState integer
---@field PowerState integer
---@field RebuildState integer
---@field RebuildProgress integer
---@field BootPriority integer
---@field HotspareType integer
Drive.Drive = Mdb.register_interface('bmc.kepler.Systems.Storage.Drive', {
    Id = {'y', nil, true, nil},
    SlotNumber = {'y', nil, true, nil},
    Name = {'s', nil, true, nil},
    Presence = {'y', nil, true, nil},
    CapacityMiB = {'u', nil, true, nil},
    TemperatureCelsius = {'y', nil, true, nil},
    Model = {'s', nil, true, nil},
    EnclosureId = {'q', nil, true, nil},
    LocationIndicatorState = {'y', nil, true, nil},
    LocateLed = {'y', nil, true, nil},
    FaultLed = {'y', nil, true, nil},
    Protocol = {'y', nil, true, nil},
    CapableSpeedGbs = {'y', nil, true, nil},
    NegotiatedSpeedGbs = {'y', nil, true, nil},
    MediaType = {'y', nil, true, nil},
    FirmwareStatus = {'y', nil, true, nil},
    SerialNumber = {'s', nil, true, nil},
    Manufacturer = {'s', nil, true, nil},
    PowerOnHours = {'u', nil, true, nil},
    Revision = {'s', nil, true, nil},
    RotationSpeedRPM = {'q', nil, true, nil},
    BlockSizeBytes = {'q', nil, true, nil},
    SASAddress1 = {'s', nil, true, nil},
    SASAddress2 = {'s', nil, true, nil},
    PredictedMediaLifeLeftPercent = {'y', nil, true, nil},
    PredictedFailCount = {'u', nil, true, nil},
    MediaErrorCount = {'u', nil, true, nil},
    OtherErrorCount = {'u', nil, true, nil},
    PatrolState = {'y', nil, true, nil},
    PowerState = {'y', nil, true, nil},
    RebuildState = {'y', nil, true, nil},
    RebuildProgress = {'y', nil, true, nil},
    BootPriority = {'y', nil, true, nil},
    HotspareType = {'y', nil, true, nil}
}, {
    SetLocationIndicatorState = {
        'a{ss}sy', 'y', msg.SetLocationIndicatorStateReq, msg.SetLocationIndicatorStateRsp
    },
    SetFirmwareStatus = {'a{ss}sy', 'y', msg.SetFirmwareStatusReq, msg.SetFirmwareStatusRsp},
    SetHotspareType = {'a{ss}sy', 'y', msg.SetHotspareTypeReq, msg.SetHotspareTypeRsp},
    SetBootPriority = {'a{ss}sy', 'y', msg.SetBootPriorityReq, msg.SetBootPriorityRsp},
    SetPatrolState = {'a{ss}sy', 'y', msg.SetPatrolStateReq, msg.SetPatrolStateRsp}
}, {})
return Drive
