-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local DiskArray = {}

local Mdb = require 'mc.mdb'

---@class DiskArray: Table
---@field Id integer
---@field UsedSpaceMiB integer
---@field TotalFreeSpaceMiB integer
---@field FreeBlocksSpaceMiB integer[]
---@field RefVolumes integer[]
---@field RefDrives string[]
DiskArray.DiskArray = Mdb.register_interface('bmc.kepler.Systems.Storage.DiskArray', {
    Id = {'q', nil, true, nil},
    UsedSpaceMiB = {'u', nil, true, nil},
    TotalFreeSpaceMiB = {'u', nil, true, nil},
    FreeBlocksSpaceMiB = {'au', nil, true, nil},
    RefVolumes = {'aq', nil, true, nil},
    RefDrives = {'as', nil, true, nil}
}, {}, {})
return DiskArray
