-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local Controller = {}

local Mdb = require 'mc.mdb'

---@class Controller: Table
---@field Id integer
---@field Name string
---@field TemperatureCelsius integer
---@field OOBSupport integer
---@field FirmwareVersion string
---@field SupportedMode string[]
---@field MemorySizeMiB integer
---@field DeviceInterface string
---@field SASAddr string
---@field SerialNumber string
---@field MaxStripSizeBytes integer
---@field MinStripSizeBytes integer
---@field NVDataVersion string
---@field MaintainPDFailHistrory integer
---@field PCIeLinkWidth string
---@field UnconfiguredDriveWriteCachePolicy string
---@field HBADriveWriteCachePolicy string
---@field ConfiguredDriveWriteCachePolicy string
---@field SupportedRAIDTypes string[]
---@field SmarterCopyBackState integer
---@field CopyBackState integer
---@field ConsistencyCheckEnabled integer
---@field ConsistencyCheckPeriodOfHours integer
---@field ConsistencyCheckRate string
---@field ConsistencyCheckAutoRepairEnabled integer
---@field ConsistencyCheckRunningStatus string
---@field ConsistencyCheckTotalVolumeCounts integer
---@field ConsistencyCheckCompletedVolumeCounts integer
---@field ConsistencyCheckDelayToStart integer
---@field BootDevices string[]
---@field HardwareRevision string
---@field HotSpareActivationMode string
---@field NoBatteryWriteCacheEnabled integer
---@field ReadCachePercent integer
---@field JBODState integer
---@field CachePinnedState integer
---@field DDREccCount integer
Controller.Controller = Mdb.register_interface('bmc.kepler.Systems.Storage.Controller', {
    Id = {'y', nil, true, nil},
    Name = {'s', nil, true, nil},
    TemperatureCelsius = {'y', nil, true, nil},
    OOBSupport = {'y', nil, true, nil},
    FirmwareVersion = {'s', nil, true, nil},
    SupportedMode = {'as', nil, true, nil},
    MemorySizeMiB = {'q', nil, true, nil},
    DeviceInterface = {'s', nil, true, nil},
    SASAddr = {'s', nil, true, nil},
    SerialNumber = {'s', nil, true, nil},
    MaxStripSizeBytes = {'u', nil, true, nil},
    MinStripSizeBytes = {'u', nil, true, nil},
    NVDataVersion = {'s', nil, true, nil},
    MaintainPDFailHistrory = {'y', nil, true, nil},
    PCIeLinkWidth = {'s', nil, true, nil},
    UnconfiguredDriveWriteCachePolicy = {'s', nil, true, nil},
    HBADriveWriteCachePolicy = {'s', nil, true, nil},
    ConfiguredDriveWriteCachePolicy = {'s', nil, true, nil},
    SupportedRAIDTypes = {'as', nil, true, nil},
    SmarterCopyBackState = {'y', nil, true, nil},
    CopyBackState = {'y', nil, true, nil},
    ConsistencyCheckEnabled = {'y', nil, true, nil},
    ConsistencyCheckPeriodOfHours = {'q', nil, true, nil},
    ConsistencyCheckRate = {'s', nil, true, nil},
    ConsistencyCheckAutoRepairEnabled = {'y', nil, true, nil},
    ConsistencyCheckRunningStatus = {'s', nil, true, nil},
    ConsistencyCheckTotalVolumeCounts = {'q', nil, true, nil},
    ConsistencyCheckCompletedVolumeCounts = {'q', nil, true, nil},
    ConsistencyCheckDelayToStart = {'u', nil, true, nil},
    BootDevices = {'as', nil, true, nil},
    HardwareRevision = {'s', nil, true, nil},
    HotSpareActivationMode = {'s', nil, true, nil},
    NoBatteryWriteCacheEnabled = {'y', nil, true, nil},
    ReadCachePercent = {'y', nil, true, nil},
    JBODState = {'y', nil, true, nil},
    CachePinnedState = {'y', nil, true, nil},
    DDREccCount = {'q', nil, true, nil}
}, {}, {})
return Controller
