-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local ProcessorInterface = require 'mdb.bmc.kepler.Systems.ProcessorInterface'
local CPUInterface = require 'mdb.bmc.kepler.Systems.Processor.CPUInterface'

local childs = {}
local CPU = {childs = childs}

local Mdb = require 'mc.mdb'

local TCPU = Mdb.register_object('/bmc/kepler/Systems/:SystemId/Processors/CPU/:ID', {
    {name = 'Processor', interface = ProcessorInterface.Processor},
    {name = 'CPU', interface = CPUInterface.CPU}
})
CPU.CPU = TCPU

function TCPU:ctor(SystemId, ID)
    self.path = '/bmc/kepler/Systems/' .. SystemId .. '/Processors/CPU/' .. ID .. ''
end

return CPU
