-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local CPU = {}

local Mdb = require 'mc.mdb'

---@class CPU: Table
---@field PhysicalId integer
---@field LogicalId integer
---@field MaxSpeedMHz integer
---@field CurrentSpeedMHz integer
---@field ProcessorID integer
---@field TotalCores integer
---@field TotalEnabledCores integer
---@field TotalThreads integer
---@field L1Cache integer
---@field L2Cache integer
---@field L3Cache integer
---@field Characteristics string
---@field TemperatureCelsius number
---@field MaxMemoryTemperatureCelsius number
---@field DiagnosticFault integer
---@field PredictiveFault integer
---@field CATERR integer
CPU.CPU = Mdb.register_interface('bmc.kepler.Systems.Processor.CPU', {
    PhysicalId = {'y', nil, true, nil},
    LogicalId = {'y', nil, true, nil},
    MaxSpeedMHz = {'u', nil, true, nil},
    CurrentSpeedMHz = {'u', nil, true, nil},
    ProcessorID = {'u', nil, true, nil},
    TotalCores = {'u', nil, true, nil},
    TotalEnabledCores = {'u', nil, true, nil},
    TotalThreads = {'u', nil, true, nil},
    L1Cache = {'u', nil, true, nil},
    L2Cache = {'u', nil, true, nil},
    L3Cache = {'u', nil, true, nil},
    Characteristics = {'s', nil, true, nil},
    TemperatureCelsius = {'d', nil, false, nil},
    MaxMemoryTemperatureCelsius = {'d', nil, false, nil},
    DiagnosticFault = {'y', nil, true, 0},
    PredictiveFault = {'y', nil, true, 0},
    CATERR = {'y', nil, true, 0}
}, {}, {})
return CPU
