-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class PowerStrategy.SetPowerLimitEnabledRsp
local TSetPowerLimitEnabledRsp = {}
TSetPowerLimitEnabledRsp.__index = TSetPowerLimitEnabledRsp
TSetPowerLimitEnabledRsp.group = {}

local function TSetPowerLimitEnabledRsp_from_obj(obj)
    return setmetatable(obj, TSetPowerLimitEnabledRsp)
end

function TSetPowerLimitEnabledRsp.new()
    return TSetPowerLimitEnabledRsp_from_obj({})
end
---@param obj PowerStrategy.SetPowerLimitEnabledRsp
function TSetPowerLimitEnabledRsp:init_from_obj(obj)

end

function TSetPowerLimitEnabledRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPowerLimitEnabledRsp.group)
end

TSetPowerLimitEnabledRsp.from_obj = TSetPowerLimitEnabledRsp_from_obj

TSetPowerLimitEnabledRsp.proto_property = {}

TSetPowerLimitEnabledRsp.default = {}

TSetPowerLimitEnabledRsp.struct = {}

function TSetPowerLimitEnabledRsp:validate(prefix, errs)
    prefix = prefix or ''

    TSetPowerLimitEnabledRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPowerLimitEnabledRsp.proto_property, errs)
    return self
end

function TSetPowerLimitEnabledRsp:unpack(_)
end

msg.SetPowerLimitEnabledRsp = TSetPowerLimitEnabledRsp

---@class PowerStrategy.SetPowerLimitEnabledReq
---@field PowerLimitEnabled boolean
local TSetPowerLimitEnabledReq = {}
TSetPowerLimitEnabledReq.__index = TSetPowerLimitEnabledReq
TSetPowerLimitEnabledReq.group = {}

local function TSetPowerLimitEnabledReq_from_obj(obj)
    return setmetatable(obj, TSetPowerLimitEnabledReq)
end

function TSetPowerLimitEnabledReq.new(PowerLimitEnabled)
    return TSetPowerLimitEnabledReq_from_obj({PowerLimitEnabled = PowerLimitEnabled})
end
---@param obj PowerStrategy.SetPowerLimitEnabledReq
function TSetPowerLimitEnabledReq:init_from_obj(obj)
    self.PowerLimitEnabled = obj.PowerLimitEnabled
end

function TSetPowerLimitEnabledReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPowerLimitEnabledReq.group)
end

TSetPowerLimitEnabledReq.from_obj = TSetPowerLimitEnabledReq_from_obj

TSetPowerLimitEnabledReq.proto_property = {'PowerLimitEnabled'}

TSetPowerLimitEnabledReq.default = {false}

TSetPowerLimitEnabledReq.struct = {{name = 'PowerLimitEnabled', is_array = false, struct = nil}}

function TSetPowerLimitEnabledReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'PowerLimitEnabled', self.PowerLimitEnabled, 'bool', false, errs)

    TSetPowerLimitEnabledReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPowerLimitEnabledReq.proto_property, errs)
    return self
end

function TSetPowerLimitEnabledReq:unpack(_)
    return self.PowerLimitEnabled
end

msg.SetPowerLimitEnabledReq = TSetPowerLimitEnabledReq

---@class PowerStrategy.SetPowerLimitValueRsp
local TSetPowerLimitValueRsp = {}
TSetPowerLimitValueRsp.__index = TSetPowerLimitValueRsp
TSetPowerLimitValueRsp.group = {}

local function TSetPowerLimitValueRsp_from_obj(obj)
    return setmetatable(obj, TSetPowerLimitValueRsp)
end

function TSetPowerLimitValueRsp.new()
    return TSetPowerLimitValueRsp_from_obj({})
end
---@param obj PowerStrategy.SetPowerLimitValueRsp
function TSetPowerLimitValueRsp:init_from_obj(obj)

end

function TSetPowerLimitValueRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPowerLimitValueRsp.group)
end

TSetPowerLimitValueRsp.from_obj = TSetPowerLimitValueRsp_from_obj

TSetPowerLimitValueRsp.proto_property = {}

TSetPowerLimitValueRsp.default = {}

TSetPowerLimitValueRsp.struct = {}

function TSetPowerLimitValueRsp:validate(prefix, errs)
    prefix = prefix or ''

    TSetPowerLimitValueRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPowerLimitValueRsp.proto_property, errs)
    return self
end

function TSetPowerLimitValueRsp:unpack(_)
end

msg.SetPowerLimitValueRsp = TSetPowerLimitValueRsp

---@class PowerStrategy.SetPowerLimitValueReq
---@field PowerLimitValue integer
local TSetPowerLimitValueReq = {}
TSetPowerLimitValueReq.__index = TSetPowerLimitValueReq
TSetPowerLimitValueReq.group = {}

local function TSetPowerLimitValueReq_from_obj(obj)
    return setmetatable(obj, TSetPowerLimitValueReq)
end

function TSetPowerLimitValueReq.new(PowerLimitValue)
    return TSetPowerLimitValueReq_from_obj({PowerLimitValue = PowerLimitValue})
end
---@param obj PowerStrategy.SetPowerLimitValueReq
function TSetPowerLimitValueReq:init_from_obj(obj)
    self.PowerLimitValue = obj.PowerLimitValue
end

function TSetPowerLimitValueReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPowerLimitValueReq.group)
end

TSetPowerLimitValueReq.from_obj = TSetPowerLimitValueReq_from_obj

TSetPowerLimitValueReq.proto_property = {'PowerLimitValue'}

TSetPowerLimitValueReq.default = {0}

TSetPowerLimitValueReq.struct = {{name = 'PowerLimitValue', is_array = false, struct = nil}}

function TSetPowerLimitValueReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'PowerLimitValue', self.PowerLimitValue, 'uint32', false, errs)

    TSetPowerLimitValueReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPowerLimitValueReq.proto_property, errs)
    return self
end

function TSetPowerLimitValueReq:unpack(_)
    return self.PowerLimitValue
end

msg.SetPowerLimitValueReq = TSetPowerLimitValueReq

---@class PowerStrategy.SetPowerWorkingModeRsp
local TSetPowerWorkingModeRsp = {}
TSetPowerWorkingModeRsp.__index = TSetPowerWorkingModeRsp
TSetPowerWorkingModeRsp.group = {}

local function TSetPowerWorkingModeRsp_from_obj(obj)
    return setmetatable(obj, TSetPowerWorkingModeRsp)
end

function TSetPowerWorkingModeRsp.new()
    return TSetPowerWorkingModeRsp_from_obj({})
end
---@param obj PowerStrategy.SetPowerWorkingModeRsp
function TSetPowerWorkingModeRsp:init_from_obj(obj)

end

function TSetPowerWorkingModeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPowerWorkingModeRsp.group)
end

TSetPowerWorkingModeRsp.from_obj = TSetPowerWorkingModeRsp_from_obj

TSetPowerWorkingModeRsp.proto_property = {}

TSetPowerWorkingModeRsp.default = {}

TSetPowerWorkingModeRsp.struct = {}

function TSetPowerWorkingModeRsp:validate(prefix, errs)
    prefix = prefix or ''

    TSetPowerWorkingModeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPowerWorkingModeRsp.proto_property, errs)
    return self
end

function TSetPowerWorkingModeRsp:unpack(_)
end

msg.SetPowerWorkingModeRsp = TSetPowerWorkingModeRsp

---@class PowerStrategy.SetPowerWorkingModeReq
---@field PowerWorkingMode string
---@field ActivePowerSuppliesList integer[]
local TSetPowerWorkingModeReq = {}
TSetPowerWorkingModeReq.__index = TSetPowerWorkingModeReq
TSetPowerWorkingModeReq.group = {}

local function TSetPowerWorkingModeReq_from_obj(obj)
    return setmetatable(obj, TSetPowerWorkingModeReq)
end

function TSetPowerWorkingModeReq.new(PowerWorkingMode, ActivePowerSuppliesList)
    return TSetPowerWorkingModeReq_from_obj({
        PowerWorkingMode = PowerWorkingMode,
        ActivePowerSuppliesList = ActivePowerSuppliesList
    })
end
---@param obj PowerStrategy.SetPowerWorkingModeReq
function TSetPowerWorkingModeReq:init_from_obj(obj)
    self.PowerWorkingMode = obj.PowerWorkingMode
    self.ActivePowerSuppliesList = obj.ActivePowerSuppliesList
end

function TSetPowerWorkingModeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPowerWorkingModeReq.group)
end

TSetPowerWorkingModeReq.from_obj = TSetPowerWorkingModeReq_from_obj

TSetPowerWorkingModeReq.proto_property = {'PowerWorkingMode', 'ActivePowerSuppliesList'}

TSetPowerWorkingModeReq.default = {'', {}}

TSetPowerWorkingModeReq.struct = {
    {name = 'PowerWorkingMode', is_array = false, struct = nil},
    {name = 'ActivePowerSuppliesList', is_array = true, struct = nil}
}

function TSetPowerWorkingModeReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'PowerWorkingMode', self.PowerWorkingMode, 'string', false, errs)
    validate.RequiredArray(prefix .. 'ActivePowerSuppliesList', self.ActivePowerSuppliesList,
        'uint8', false, errs)

    validate.lens(prefix .. 'PowerWorkingMode', self.PowerWorkingMode, 1, 32, errs)
    validate.regex(prefix .. 'PowerWorkingMode', self.PowerWorkingMode, [=[[0-9a-zA-Z.-_]+]=], errs)

    TSetPowerWorkingModeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPowerWorkingModeReq.proto_property, errs)
    return self
end

function TSetPowerWorkingModeReq:unpack(_)
    return self.PowerWorkingMode, self.ActivePowerSuppliesList
end

msg.SetPowerWorkingModeReq = TSetPowerWorkingModeReq

local PowerStrategy = {}

local Mdb = require 'mc.mdb'

---@class PowerStrategy: Table
---@field PowerWorkingMode string
---@field PowerActualWorkingMode string
---@field PowerLimitValue integer
---@field PowerLimitEnabled boolean
---@field ExpectedActivePSU integer[]
---@field MaxPowerLimitInWatts integer
---@field MinPowerLimitInWatts integer
---@field WorkModeConfigurable boolean
---@field PowerLimitFailed boolean
---@field PowerLimitActivated boolean
---@field PowerLimitExceptionSupported boolean
---@field PowerLimitException string
PowerStrategy.PowerStrategy = Mdb.register_interface('bmc.kepler.Systems.PowerStrategy', {
    PowerWorkingMode = {'s', nil, true, nil},
    PowerActualWorkingMode = {'s', nil, true, nil},
    PowerLimitValue = {'u', nil, true, nil},
    PowerLimitEnabled = {'b', nil, false, nil},
    ExpectedActivePSU = {'ay', nil, true, nil},
    MaxPowerLimitInWatts = {'u', nil, true, nil},
    MinPowerLimitInWatts = {'u', nil, true, nil},
    WorkModeConfigurable = {'b', nil, true, nil},
    PowerLimitFailed = {'b', nil, true, nil},
    PowerLimitActivated = {'b', nil, true, nil},
    PowerLimitExceptionSupported = {'b', nil, true, nil},
    PowerLimitException = {'s', nil, false, nil}
}, {
    SetPowerWorkingMode = {'a{ss}say', '', msg.SetPowerWorkingModeReq, msg.SetPowerWorkingModeRsp},
    SetPowerLimitValue = {'a{ss}u', '', msg.SetPowerLimitValueReq, msg.SetPowerLimitValueRsp},
    SetPowerLimitEnabled = {'a{ss}b', '', msg.SetPowerLimitEnabledReq, msg.SetPowerLimitEnabledRsp}
}, {})
return PowerStrategy
