-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local PowerMgmt = {}

local Mdb = require 'mc.mdb'

---@class IOnePower: Table
---@field SlotNumber integer
---@field Manufacturer string
---@field Model string
---@field Version string
---@field Rate integer
---@field PowerSupplyType integer
---@field InputVoltage number
---@field OutputVoltage number
---@field Presence integer
---@field PowerSupplyChannel integer
---@field PowerInputWatts number
---@field SerialNumber string
---@field PartNum string
---@field FirmwareVersion string
---@field Protocol string
---@field PowerOutputWatts number
---@field DeviceLocator string
---@field RatedCurrent integer
---@field Status integer
---@field InletTemperatureCelsius number
---@field InnerTemperatureCelsius number
---@field ManufactureDate string
---@field InputCurrent number
---@field OutputCurrent number
---@field PowerMode string
PowerMgmt.IOnePower = Mdb.register_interface('bmc.kepler.Systems.PowerMgmt.OnePower', {
    SlotNumber = {'u', nil, true, 0},
    Manufacturer = {'s', nil, true, nil},
    Model = {'s', nil, true, nil},
    Version = {'s', nil, true, nil},
    Rate = {'q', nil, true, nil},
    PowerSupplyType = {'u', nil, true, 0},
    InputVoltage = {'d', nil, true, nil},
    OutputVoltage = {'d', nil, true, nil},
    Presence = {'y', nil, true, 0},
    PowerSupplyChannel = {'y', nil, true, 0},
    PowerInputWatts = {'d', nil, true, nil},
    SerialNumber = {'s', nil, true, nil},
    PartNum = {'s', nil, true, nil},
    FirmwareVersion = {'s', nil, true, nil},
    Protocol = {'s', nil, true, nil},
    PowerOutputWatts = {'d', nil, true, nil},
    DeviceLocator = {'s', nil, true, nil},
    RatedCurrent = {'q', nil, true, nil},
    Status = {'y', nil, true, nil},
    InletTemperatureCelsius = {'d', nil, true, nil},
    InnerTemperatureCelsius = {'d', nil, true, nil},
    ManufactureDate = {'s', nil, true, nil},
    InputCurrent = {'d', nil, true, nil},
    OutputCurrent = {'d', nil, true, nil},
    PowerMode = {'s', nil, true, nil}
}, {}, {})

return PowerMgmt
