-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class OnePower.SetPowerWorkModeRsp
---@field CmdResult integer
local TSetPowerWorkModeRsp = {}
TSetPowerWorkModeRsp.__index = TSetPowerWorkModeRsp
TSetPowerWorkModeRsp.group = {}

local function TSetPowerWorkModeRsp_from_obj(obj)
    return setmetatable(obj, TSetPowerWorkModeRsp)
end

function TSetPowerWorkModeRsp.new(CmdResult)
    return TSetPowerWorkModeRsp_from_obj({CmdResult = CmdResult})
end
---@param obj OnePower.SetPowerWorkModeRsp
function TSetPowerWorkModeRsp:init_from_obj(obj)
    self.CmdResult = obj.CmdResult
end

function TSetPowerWorkModeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPowerWorkModeRsp.group)
end

TSetPowerWorkModeRsp.from_obj = TSetPowerWorkModeRsp_from_obj

TSetPowerWorkModeRsp.proto_property = {'CmdResult'}

TSetPowerWorkModeRsp.default = {0}

TSetPowerWorkModeRsp.struct = {{name = 'CmdResult', is_array = false, struct = nil}}

function TSetPowerWorkModeRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'CmdResult', self.CmdResult, 'int32', false, errs)

    TSetPowerWorkModeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPowerWorkModeRsp.proto_property, errs)
    return self
end

function TSetPowerWorkModeRsp:unpack(_)
    return self.CmdResult
end

msg.SetPowerWorkModeRsp = TSetPowerWorkModeRsp

---@class OnePower.SetPowerWorkModeReq
---@field PowerWorkMode integer
local TSetPowerWorkModeReq = {}
TSetPowerWorkModeReq.__index = TSetPowerWorkModeReq
TSetPowerWorkModeReq.group = {}

local function TSetPowerWorkModeReq_from_obj(obj)
    return setmetatable(obj, TSetPowerWorkModeReq)
end

function TSetPowerWorkModeReq.new(PowerWorkMode)
    return TSetPowerWorkModeReq_from_obj({PowerWorkMode = PowerWorkMode})
end
---@param obj OnePower.SetPowerWorkModeReq
function TSetPowerWorkModeReq:init_from_obj(obj)
    self.PowerWorkMode = obj.PowerWorkMode
end

function TSetPowerWorkModeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPowerWorkModeReq.group)
end

TSetPowerWorkModeReq.from_obj = TSetPowerWorkModeReq_from_obj

TSetPowerWorkModeReq.proto_property = {'PowerWorkMode'}

TSetPowerWorkModeReq.default = {0}

TSetPowerWorkModeReq.struct = {{name = 'PowerWorkMode', is_array = false, struct = nil}}

function TSetPowerWorkModeReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'PowerWorkMode', self.PowerWorkMode, 'int32', false, errs)

    TSetPowerWorkModeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPowerWorkModeReq.proto_property, errs)
    return self
end

function TSetPowerWorkModeReq:unpack(_)
    return self.PowerWorkMode
end

msg.SetPowerWorkModeReq = TSetPowerWorkModeReq

local OnePower = {}

local Mdb = require 'mc.mdb'

---@class OnePower: Table
---@field SlotNumber integer
---@field Manufacturer string
---@field Model string
---@field Version string
---@field Rate integer
---@field PowerSupplyType integer
---@field InputVoltage number
---@field OutputVoltage number
---@field Presence integer
---@field PowerSupplyChannel integer
---@field PowerInputWatts number
---@field PowerOutputWatts number
---@field SerialNumber string
---@field PartNum string
---@field FirmwareVersion string
---@field Protocol string
---@field DeviceLocator string
---@field RatedCurrent integer
---@field Status integer
---@field InletTemperatureCelsius number
---@field InnerTemperatureCelsius number
---@field ManufactureDate string
---@field InputCurrent number
---@field OutputCurrent number
---@field PowerMode string
---@field EnvTemp number
---@field PrimaryChipTemp number
---@field SecondaryChipTemp number
---@field Position string
OnePower.OnePower = Mdb.register_interface('bmc.kepler.Systems.PowerMgmt.OnePower', {
    SlotNumber = {'u', nil, true, 0},
    Manufacturer = {'s', nil, true, nil},
    Model = {'s', nil, true, nil},
    Version = {'s', nil, true, nil},
    Rate = {'q', nil, true, nil},
    PowerSupplyType = {'u', nil, true, 0},
    InputVoltage = {'d', nil, true, nil},
    OutputVoltage = {'d', nil, true, nil},
    Presence = {'y', nil, true, 0},
    PowerSupplyChannel = {'y', nil, true, 0},
    PowerInputWatts = {'d', nil, true, nil},
    PowerOutputWatts = {'d', nil, true, nil},
    SerialNumber = {'s', nil, true, nil},
    PartNum = {'s', nil, true, nil},
    FirmwareVersion = {'s', nil, true, nil},
    Protocol = {'s', nil, true, nil},
    DeviceLocator = {'s', nil, true, nil},
    RatedCurrent = {'q', nil, true, nil},
    Status = {'y', nil, true, nil},
    InletTemperatureCelsius = {'d', nil, true, nil},
    InnerTemperatureCelsius = {'d', nil, true, nil},
    ManufactureDate = {'s', nil, true, nil},
    InputCurrent = {'d', nil, true, nil},
    OutputCurrent = {'d', nil, true, nil},
    PowerMode = {'s', nil, true, nil},
    EnvTemp = {'d', nil, true, nil},
    PrimaryChipTemp = {'d', nil, true, nil},
    SecondaryChipTemp = {'d', nil, true, nil},
    Position = {'s', nil, true, nil}
}, {SetPowerWorkMode = {'a{ss}i', 'i', msg.SetPowerWorkModeReq, msg.SetPowerWorkModeRsp}}, {})
return OnePower
