-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local PcieAddrInfoInterface = require 'mdb.bmc.kepler.Systems.PcieAddrInfoInterface'

local childs = {}
local PCIeDevice = {childs = childs}

local Mdb = require 'mc.mdb'

local TPcieAddrInfo = Mdb.register_object(
    '/bmc/kepler/Systems/:SystemId/PCIeDevices/PcieAddrInfo/:ID',
    {{name = 'PcieAddrInfo', interface = PcieAddrInfoInterface.PcieAddrInfo}})
PCIeDevice.PcieAddrInfo = TPcieAddrInfo

function TPcieAddrInfo:ctor(SystemId, ID)
    self.path = '/bmc/kepler/Systems/' .. SystemId .. '/PCIeDevices/PcieAddrInfo/' .. ID .. ''
end

return PCIeDevice
