-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local PCIeDevice = {}

local Mdb = require 'mc.mdb'

---@class PCIeDevice: Table
---@field SlotID integer
---@field Segment integer
---@field SocketID integer
---@field Bus integer
---@field Device integer
---@field Function integer
---@field DevBus integer
---@field DevDevice integer
---@field DevFunction integer
---@field DiagnosticFault integer
---@field PredictiveFault integer
PCIeDevice.PCIeDevice = Mdb.register_interface('bmc.kepler.Systems.PCIeDevices.PCIeDevice', {
    SlotID = {'y', nil, true, nil},
    Segment = {'y', nil, true, nil},
    SocketID = {'y', nil, true, nil},
    Bus = {'y', nil, true, nil},
    Device = {'y', nil, true, nil},
    Function = {'y', nil, true, nil},
    DevBus = {'y', nil, true, nil},
    DevDevice = {'y', nil, true, nil},
    DevFunction = {'y', nil, true, nil},
    DiagnosticFault = {'y', nil, true, nil},
    PredictiveFault = {'y', nil, true, nil}
}, {}, {})
return PCIeDevice
