-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local PCIeCard = {}

local Mdb = require 'mc.mdb'

---@class PCIeCard: Table
---@field Name string
---@field SlotID integer
---@field DeviceName string
---@field FunctionClass integer
---@field Description string
---@field PcbVersion string
---@field BoardID integer
---@field BoardName string
---@field LinkWidthAbility string
---@field LinkWidth string
---@field VendorID integer
---@field DeviceID integer
---@field SubVendorID integer
---@field SubDeviceID integer
---@field Position string
---@field Manufacturer string
---@field LaneOwner integer
---@field FirmwareVersion string
---@field PartNumber string
---@field RefComponent string
PCIeCard.PCIeCard = Mdb.register_interface('bmc.kepler.Systems.PCIeDevices.PCIeCard', {
    Name = {'s', nil, true, nil},
    SlotID = {'y', nil, true, nil},
    DeviceName = {'s', nil, true, nil},
    FunctionClass = {'y', nil, true, nil},
    Description = {'s', nil, true, nil},
    PcbVersion = {'s', nil, true, nil},
    BoardID = {'q', nil, true, nil},
    BoardName = {'s', nil, true, nil},
    LinkWidthAbility = {'s', nil, true, nil},
    LinkWidth = {'s', nil, true, nil},
    VendorID = {'q', nil, true, nil},
    DeviceID = {'q', nil, true, nil},
    SubVendorID = {'q', nil, true, nil},
    SubDeviceID = {'q', nil, true, nil},
    Position = {'s', nil, true, nil},
    Manufacturer = {'s', nil, true, nil},
    LaneOwner = {'y', nil, true, nil},
    FirmwareVersion = {'s', nil, true, nil},
    PartNumber = {'s', nil, true, nil},
    RefComponent = {'s', nil, true, nil}
}, {}, {})
return PCIeCard
