-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local Mctp = {}

local Mdb = require 'mc.mdb'

---@class Mctp: Table
---@field DiscoverFlag integer
---@field OwnerEid integer
---@field OwnerPhy integer
---@field BmcEid integer
---@field BmcPhy integer
---@field SystemId integer
---@field TableStatus integer
Mctp.Mctp = Mdb.register_interface('bmc.kepler.Systems.Mctp', {
    DiscoverFlag = {'y', nil, true, 0},
    OwnerEid = {'y', nil, true, 0},
    OwnerPhy = {'q', nil, true, 0},
    BmcEid = {'y', nil, true, 0},
    BmcPhy = {'q', nil, true, 0},
    SystemId = {'y', nil, true, 1},
    TableStatus = {'y', nil, true, 0}
}, {}, {})
return Mctp
