-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local Led = {}

local Mdb = require 'mc.mdb'

---@class Led: Table
---@field Name string
---@field OnDuration integer
---@field OffDuration integer
---@field Capability integer
---@field SystemId integer
---@field State integer
Led.Led = Mdb.register_interface('bmc.kepler.Systems.Led', {
    Name = {'s', nil, true, nil},
    OnDuration = {'y', nil, true, 0},
    OffDuration = {'y', nil, true, 0},
    Capability = {'y', nil, true, nil},
    SystemId = {'y', nil, true, nil},
    State = {'y', nil, true, nil}
}, {}, {})
return Led
