-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local OverviewInterface = require 'mdb.bmc.kepler.Systems.FruData.OverviewInterface'
local ChassisInterface = require 'mdb.bmc.kepler.Systems.FruData.ChassisInterface'
local BoardInterface = require 'mdb.bmc.kepler.Systems.FruData.BoardInterface'
local ProductInterface = require 'mdb.bmc.kepler.Systems.FruData.ProductInterface'
local SystemInterface = require 'mdb.bmc.kepler.Systems.FruData.SystemInterface'

local childs = {}
local Frus = {childs = childs}

local Mdb = require 'mc.mdb'

local TFruData = Mdb.register_object('/bmc/kepler/Systems/:SystemId/Frus/:ID', {
    {name = 'Overview', interface = OverviewInterface.Overview},
    {name = 'Chassis', interface = ChassisInterface.Chassis},
    {name = 'Board', interface = BoardInterface.Board},
    {name = 'Product', interface = ProductInterface.Product},
    {name = 'System', interface = SystemInterface.System}
})
Frus.FruData = TFruData

function TFruData:ctor(SystemId, ID)
    self.path = '/bmc/kepler/Systems/' .. SystemId .. '/Frus/' .. ID .. ''
end

return Frus
