-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local Product = {}

local Mdb = require 'mc.mdb'

---@class Product: Table
---@field ManufacturerName string
---@field ProductName string
---@field ProductPartNumber string
---@field ProductVersion string
---@field ProductSerialNumber string
---@field AssetTag string
---@field ProductFRUFileID string
---@field ProductCustomInfo string
Product.Product = Mdb.register_interface('bmc.kepler.Systems.FruData.Product', {
    ManufacturerName = {'s', nil, true, nil},
    ProductName = {'s', nil, true, nil},
    ProductPartNumber = {'s', nil, true, nil},
    ProductVersion = {'s', nil, true, nil},
    ProductSerialNumber = {'s', nil, true, nil},
    AssetTag = {'s', nil, true, nil},
    ProductFRUFileID = {'s', nil, true, nil},
    ProductCustomInfo = {'s', nil, true, nil}
}, {}, {})
return Product
