-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local PowerOnLockInterface = require 'mdb.bmc.kepler.Systems.PowerOnLockInterface'
local DelayedPowerOnPolicyInterface = require 'mdb.bmc.kepler.Systems.DelayedPowerOnPolicyInterface'
local FruCtrlInterface = require 'mdb.bmc.kepler.Systems.FruCtrlInterface'

local childs = {}
local FruCtrl = {childs = childs}

local Mdb = require 'mc.mdb'

local TFruCtrl = Mdb.register_object('/bmc/kepler/Systems/:SystemId/FruCtrl/:Id', {
    {name = 'PowerOnLock', interface = PowerOnLockInterface.PowerOnLock},
    {name = 'DelayedPowerOnPolicy', interface = DelayedPowerOnPolicyInterface.DelayedPowerOnPolicy},
    {name = 'FruCtrl', interface = FruCtrlInterface.FruCtrl}
})
FruCtrl.FruCtrl = TFruCtrl

function TFruCtrl:ctor(SystemId, Id)
    self.path = '/bmc/kepler/Systems/' .. SystemId .. '/FruCtrl/' .. Id .. ''
end

return FruCtrl
