-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class defs.EventList
---@field Severity string
---@field ComponentName string
---@field State string
---@field EventCode string
---@field Timestamp string
---@field Description string
---@field Suggestion string
---@field Cause string
---@field Influence string
---@field ActionId integer
---@field RecordId integer
---@field ReportChannel integer
---@field TriggerMode integer
local TEventList = {}
TEventList.__index = TEventList
TEventList.group = {}

local function TEventList_from_obj(obj)
    return setmetatable(obj, TEventList)
end

function TEventList.new(Severity, ComponentName, State, EventCode, Timestamp, Description,
    Suggestion, Cause, Influence, ActionId, RecordId, ReportChannel, TriggerMode)
    return TEventList_from_obj({
        Severity = Severity,
        ComponentName = ComponentName,
        State = State,
        EventCode = EventCode,
        Timestamp = Timestamp,
        Description = Description,
        Suggestion = Suggestion,
        Cause = Cause,
        Influence = Influence,
        ActionId = ActionId,
        RecordId = RecordId,
        ReportChannel = ReportChannel,
        TriggerMode = TriggerMode
    })
end
---@param obj defs.EventList
function TEventList:init_from_obj(obj)
    self.Severity = obj.Severity
    self.ComponentName = obj.ComponentName
    self.State = obj.State
    self.EventCode = obj.EventCode
    self.Timestamp = obj.Timestamp
    self.Description = obj.Description
    self.Suggestion = obj.Suggestion
    self.Cause = obj.Cause
    self.Influence = obj.Influence
    self.ActionId = obj.ActionId
    self.RecordId = obj.RecordId
    self.ReportChannel = obj.ReportChannel
    self.TriggerMode = obj.TriggerMode
end

function TEventList:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEventList.group)
end

TEventList.from_obj = TEventList_from_obj

TEventList.proto_property = {
    'Severity', 'ComponentName', 'State', 'EventCode', 'Timestamp', 'Description', 'Suggestion',
    'Cause', 'Influence', 'ActionId', 'RecordId', 'ReportChannel', 'TriggerMode'
}

TEventList.default = {'', '', '', '', '', '', '', '', '', 0, 0, 0, 0}

TEventList.struct = {
    {name = 'Severity', is_array = false, struct = nil},
    {name = 'ComponentName', is_array = false, struct = nil},
    {name = 'State', is_array = false, struct = nil},
    {name = 'EventCode', is_array = false, struct = nil},
    {name = 'Timestamp', is_array = false, struct = nil},
    {name = 'Description', is_array = false, struct = nil},
    {name = 'Suggestion', is_array = false, struct = nil},
    {name = 'Cause', is_array = false, struct = nil},
    {name = 'Influence', is_array = false, struct = nil},
    {name = 'ActionId', is_array = false, struct = nil},
    {name = 'RecordId', is_array = false, struct = nil},
    {name = 'ReportChannel', is_array = false, struct = nil},
    {name = 'TriggerMode', is_array = false, struct = nil}
}

function TEventList:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Severity', self.Severity, 'string', false, errs)
    validate.Required(prefix .. 'ComponentName', self.ComponentName, 'string', false, errs)
    validate.Required(prefix .. 'State', self.State, 'string', false, errs)
    validate.Required(prefix .. 'EventCode', self.EventCode, 'string', false, errs)
    validate.Required(prefix .. 'Timestamp', self.Timestamp, 'string', false, errs)
    validate.Required(prefix .. 'Description', self.Description, 'string', false, errs)
    validate.Required(prefix .. 'Suggestion', self.Suggestion, 'string', false, errs)
    validate.Required(prefix .. 'Cause', self.Cause, 'string', false, errs)
    validate.Required(prefix .. 'Influence', self.Influence, 'string', false, errs)
    validate.Required(prefix .. 'ActionId', self.ActionId, 'uint8', false, errs)
    validate.Required(prefix .. 'RecordId', self.RecordId, 'int32', false, errs)
    validate.Required(prefix .. 'ReportChannel', self.ReportChannel, 'uint16', false, errs)
    validate.Required(prefix .. 'TriggerMode', self.TriggerMode, 'uint8', false, errs)

    TEventList:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEventList.proto_property, errs)
    return self
end

function TEventList:unpack(_)
    return self.Severity, self.ComponentName, self.State, self.EventCode, self.Timestamp,
        self.Description, self.Suggestion, self.Cause, self.Influence, self.ActionId, self.RecordId,
        self.ReportChannel, self.TriggerMode
end

defs.EventList = TEventList

---@class Events.GetEventInfoRsp
---@field Version string
---@field CurrentEventNumber integer
---@field MaxEventNumber integer
local TGetEventInfoRsp = {}
TGetEventInfoRsp.__index = TGetEventInfoRsp
TGetEventInfoRsp.group = {}

local function TGetEventInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetEventInfoRsp)
end

function TGetEventInfoRsp.new(Version, CurrentEventNumber, MaxEventNumber)
    return TGetEventInfoRsp_from_obj({
        Version = Version,
        CurrentEventNumber = CurrentEventNumber,
        MaxEventNumber = MaxEventNumber
    })
end
---@param obj Events.GetEventInfoRsp
function TGetEventInfoRsp:init_from_obj(obj)
    self.Version = obj.Version
    self.CurrentEventNumber = obj.CurrentEventNumber
    self.MaxEventNumber = obj.MaxEventNumber
end

function TGetEventInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetEventInfoRsp.group)
end

TGetEventInfoRsp.from_obj = TGetEventInfoRsp_from_obj

TGetEventInfoRsp.proto_property = {'Version', 'CurrentEventNumber', 'MaxEventNumber'}

TGetEventInfoRsp.default = {'', 0, 0}

TGetEventInfoRsp.struct = {
    {name = 'Version', is_array = false, struct = nil},
    {name = 'CurrentEventNumber', is_array = false, struct = nil},
    {name = 'MaxEventNumber', is_array = false, struct = nil}
}

function TGetEventInfoRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Version', self.Version, 'string', false, errs)
    validate.Required(prefix .. 'CurrentEventNumber', self.CurrentEventNumber, 'uint32', false, errs)
    validate.Required(prefix .. 'MaxEventNumber', self.MaxEventNumber, 'uint32', false, errs)

    TGetEventInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetEventInfoRsp.proto_property, errs)
    return self
end

function TGetEventInfoRsp:unpack(_)
    return self.Version, self.CurrentEventNumber, self.MaxEventNumber
end

msg.GetEventInfoRsp = TGetEventInfoRsp

---@class Events.GetEventInfoReq
local TGetEventInfoReq = {}
TGetEventInfoReq.__index = TGetEventInfoReq
TGetEventInfoReq.group = {}

local function TGetEventInfoReq_from_obj(obj)
    return setmetatable(obj, TGetEventInfoReq)
end

function TGetEventInfoReq.new()
    return TGetEventInfoReq_from_obj({})
end
---@param obj Events.GetEventInfoReq
function TGetEventInfoReq:init_from_obj(obj)

end

function TGetEventInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetEventInfoReq.group)
end

TGetEventInfoReq.from_obj = TGetEventInfoReq_from_obj

TGetEventInfoReq.proto_property = {}

TGetEventInfoReq.default = {}

TGetEventInfoReq.struct = {}

function TGetEventInfoReq:validate(prefix, errs)
    prefix = prefix or ''

    TGetEventInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetEventInfoReq.proto_property, errs)
    return self
end

function TGetEventInfoReq:unpack(_)
end

msg.GetEventInfoReq = TGetEventInfoReq

---@class Events.RearmRsp
local TRearmRsp = {}
TRearmRsp.__index = TRearmRsp
TRearmRsp.group = {}

local function TRearmRsp_from_obj(obj)
    return setmetatable(obj, TRearmRsp)
end

function TRearmRsp.new()
    return TRearmRsp_from_obj({})
end
---@param obj Events.RearmRsp
function TRearmRsp:init_from_obj(obj)

end

function TRearmRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRearmRsp.group)
end

TRearmRsp.from_obj = TRearmRsp_from_obj

TRearmRsp.proto_property = {}

TRearmRsp.default = {}

TRearmRsp.struct = {}

function TRearmRsp:validate(prefix, errs)
    prefix = prefix or ''

    TRearmRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRearmRsp.proto_property, errs)
    return self
end

function TRearmRsp:unpack(_)
end

msg.RearmRsp = TRearmRsp

---@class Events.RearmReq
local TRearmReq = {}
TRearmReq.__index = TRearmReq
TRearmReq.group = {}

local function TRearmReq_from_obj(obj)
    return setmetatable(obj, TRearmReq)
end

function TRearmReq.new()
    return TRearmReq_from_obj({})
end
---@param obj Events.RearmReq
function TRearmReq:init_from_obj(obj)

end

function TRearmReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRearmReq.group)
end

TRearmReq.from_obj = TRearmReq_from_obj

TRearmReq.proto_property = {}

TRearmReq.default = {}

TRearmReq.struct = {}

function TRearmReq:validate(prefix, errs)
    prefix = prefix or ''

    TRearmReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRearmReq.proto_property, errs)
    return self
end

function TRearmReq:unpack(_)
end

msg.RearmReq = TRearmReq

---@class Events.ClearEventListRsp
local TClearEventListRsp = {}
TClearEventListRsp.__index = TClearEventListRsp
TClearEventListRsp.group = {}

local function TClearEventListRsp_from_obj(obj)
    return setmetatable(obj, TClearEventListRsp)
end

function TClearEventListRsp.new()
    return TClearEventListRsp_from_obj({})
end
---@param obj Events.ClearEventListRsp
function TClearEventListRsp:init_from_obj(obj)

end

function TClearEventListRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TClearEventListRsp.group)
end

TClearEventListRsp.from_obj = TClearEventListRsp_from_obj

TClearEventListRsp.proto_property = {}

TClearEventListRsp.default = {}

TClearEventListRsp.struct = {}

function TClearEventListRsp:validate(prefix, errs)
    prefix = prefix or ''

    TClearEventListRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TClearEventListRsp.proto_property, errs)
    return self
end

function TClearEventListRsp:unpack(_)
end

msg.ClearEventListRsp = TClearEventListRsp

---@class Events.ClearEventListReq
local TClearEventListReq = {}
TClearEventListReq.__index = TClearEventListReq
TClearEventListReq.group = {}

local function TClearEventListReq_from_obj(obj)
    return setmetatable(obj, TClearEventListReq)
end

function TClearEventListReq.new()
    return TClearEventListReq_from_obj({})
end
---@param obj Events.ClearEventListReq
function TClearEventListReq:init_from_obj(obj)

end

function TClearEventListReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TClearEventListReq.group)
end

TClearEventListReq.from_obj = TClearEventListReq_from_obj

TClearEventListReq.proto_property = {}

TClearEventListReq.default = {}

TClearEventListReq.struct = {}

function TClearEventListReq:validate(prefix, errs)
    prefix = prefix or ''

    TClearEventListReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TClearEventListReq.proto_property, errs)
    return self
end

function TClearEventListReq:unpack(_)
end

msg.ClearEventListReq = TClearEventListReq

---@class Events.GetEventListRsp
---@field EventList defs.EventList[]
local TGetEventListRsp = {}
TGetEventListRsp.__index = TGetEventListRsp
TGetEventListRsp.group = {}

local function TGetEventListRsp_from_obj(obj)
    obj.EventList = utils.from_obj(defs.EventList, obj.EventList, true)
    return setmetatable(obj, TGetEventListRsp)
end

function TGetEventListRsp.new(EventList)
    return TGetEventListRsp_from_obj({EventList = EventList})
end
---@param obj Events.GetEventListRsp
function TGetEventListRsp:init_from_obj(obj)
    self.EventList = obj.EventList
end

function TGetEventListRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetEventListRsp.group)
end

TGetEventListRsp.from_obj = TGetEventListRsp_from_obj

TGetEventListRsp.proto_property = {'EventList'}

TGetEventListRsp.default = {{}}

TGetEventListRsp.struct = {{name = 'EventList', is_array = true, struct = defs.EventList.struct}}

function TGetEventListRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.RequiredArray(prefix .. 'EventList', self.EventList, 'defs.EventList', false, errs)

    TGetEventListRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetEventListRsp.proto_property, errs)
    return self
end

function TGetEventListRsp:unpack(raw)
    return utils.unpack(raw, self.EventList, true)
end

msg.GetEventListRsp = TGetEventListRsp

---@class Events.GetEventListReq
---@field StartId integer
---@field Count integer
---@field Language integer
local TGetEventListReq = {}
TGetEventListReq.__index = TGetEventListReq
TGetEventListReq.group = {}

local function TGetEventListReq_from_obj(obj)
    return setmetatable(obj, TGetEventListReq)
end

function TGetEventListReq.new(StartId, Count, Language)
    return TGetEventListReq_from_obj({StartId = StartId, Count = Count, Language = Language})
end
---@param obj Events.GetEventListReq
function TGetEventListReq:init_from_obj(obj)
    self.StartId = obj.StartId
    self.Count = obj.Count
    self.Language = obj.Language
end

function TGetEventListReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetEventListReq.group)
end

TGetEventListReq.from_obj = TGetEventListReq_from_obj

TGetEventListReq.proto_property = {'StartId', 'Count', 'Language'}

TGetEventListReq.default = {0, 0, 0}

TGetEventListReq.struct = {
    {name = 'StartId', is_array = false, struct = nil},
    {name = 'Count', is_array = false, struct = nil},
    {name = 'Language', is_array = false, struct = nil}
}

function TGetEventListReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'StartId', self.StartId, 'uint32', false, errs)
    validate.Required(prefix .. 'Count', self.Count, 'uint32', false, errs)
    validate.Required(prefix .. 'Language', self.Language, 'uint8', false, errs)

    TGetEventListReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetEventListReq.proto_property, errs)
    return self
end

function TGetEventListReq:unpack(_)
    return self.StartId, self.Count, self.Language
end

msg.GetEventListReq = TGetEventListReq

---@class Events.GetAlarmListRsp
---@field EventList defs.EventList[]
local TGetAlarmListRsp = {}
TGetAlarmListRsp.__index = TGetAlarmListRsp
TGetAlarmListRsp.group = {}

local function TGetAlarmListRsp_from_obj(obj)
    obj.EventList = utils.from_obj(defs.EventList, obj.EventList, true)
    return setmetatable(obj, TGetAlarmListRsp)
end

function TGetAlarmListRsp.new(EventList)
    return TGetAlarmListRsp_from_obj({EventList = EventList})
end
---@param obj Events.GetAlarmListRsp
function TGetAlarmListRsp:init_from_obj(obj)
    self.EventList = obj.EventList
end

function TGetAlarmListRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetAlarmListRsp.group)
end

TGetAlarmListRsp.from_obj = TGetAlarmListRsp_from_obj

TGetAlarmListRsp.proto_property = {'EventList'}

TGetAlarmListRsp.default = {{}}

TGetAlarmListRsp.struct = {{name = 'EventList', is_array = true, struct = defs.EventList.struct}}

function TGetAlarmListRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.RequiredArray(prefix .. 'EventList', self.EventList, 'defs.EventList', false, errs)

    TGetAlarmListRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetAlarmListRsp.proto_property, errs)
    return self
end

function TGetAlarmListRsp:unpack(raw)
    return utils.unpack(raw, self.EventList, true)
end

msg.GetAlarmListRsp = TGetAlarmListRsp

---@class Events.GetAlarmListReq
---@field Language integer
local TGetAlarmListReq = {}
TGetAlarmListReq.__index = TGetAlarmListReq
TGetAlarmListReq.group = {}

local function TGetAlarmListReq_from_obj(obj)
    return setmetatable(obj, TGetAlarmListReq)
end

function TGetAlarmListReq.new(Language)
    return TGetAlarmListReq_from_obj({Language = Language})
end
---@param obj Events.GetAlarmListReq
function TGetAlarmListReq:init_from_obj(obj)
    self.Language = obj.Language
end

function TGetAlarmListReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetAlarmListReq.group)
end

TGetAlarmListReq.from_obj = TGetAlarmListReq_from_obj

TGetAlarmListReq.proto_property = {'Language'}

TGetAlarmListReq.default = {0}

TGetAlarmListReq.struct = {{name = 'Language', is_array = false, struct = nil}}

function TGetAlarmListReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Language', self.Language, 'uint8', false, errs)

    TGetAlarmListReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetAlarmListReq.proto_property, errs)
    return self
end

function TGetAlarmListReq:unpack(_)
    return self.Language
end

msg.GetAlarmListReq = TGetAlarmListReq

---@class Events.MockEventReq
---@field EventCode string
---@field Enabled integer
---@field ObjectIndex integer
---@field MockState integer
local TMockEventReq = {}
TMockEventReq.__index = TMockEventReq
TMockEventReq.group = {}

local function TMockEventReq_from_obj(obj)
    return setmetatable(obj, TMockEventReq)
end

function TMockEventReq.new(EventCode, Enabled, ObjectIndex, MockState)
    return TMockEventReq_from_obj({
        EventCode = EventCode,
        Enabled = Enabled,
        ObjectIndex = ObjectIndex,
        MockState = MockState
    })
end
---@param obj Events.MockEventReq
function TMockEventReq:init_from_obj(obj)
    self.EventCode = obj.EventCode
    self.Enabled = obj.Enabled
    self.ObjectIndex = obj.ObjectIndex
    self.MockState = obj.MockState
end

function TMockEventReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMockEventReq.group)
end

TMockEventReq.from_obj = TMockEventReq_from_obj

TMockEventReq.proto_property = {'EventCode', 'Enabled', 'ObjectIndex', 'MockState'}

TMockEventReq.default = {'', 0, 0, 0}

TMockEventReq.struct = {
    {name = 'EventCode', is_array = false, struct = nil},
    {name = 'Enabled', is_array = false, struct = nil},
    {name = 'ObjectIndex', is_array = false, struct = nil},
    {name = 'MockState', is_array = false, struct = nil}
}

function TMockEventReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'EventCode', self.EventCode, 'string', false, errs)
    validate.Required(prefix .. 'Enabled', self.Enabled, 'uint8', false, errs)
    validate.Required(prefix .. 'ObjectIndex', self.ObjectIndex, 'uint8', false, errs)
    validate.Required(prefix .. 'MockState', self.MockState, 'uint8', false, errs)

    TMockEventReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMockEventReq.proto_property, errs)
    return self
end

function TMockEventReq:unpack(_)
    return self.EventCode, self.Enabled, self.ObjectIndex, self.MockState
end

msg.MockEventReq = TMockEventReq

local Events = {}

local Mdb = require 'mc.mdb'

---@class Events: Table
Events.Events = Mdb.register_interface('bmc.kepler.Systems.Events', {}, {
    MockEvent = {'a{ss}syyy', '', msg.MockEventReq, nil},
    GetAlarmList = {'a{ss}y', 'a(sssssssssyiqy)', msg.GetAlarmListReq, msg.GetAlarmListRsp},
    GetEventList = {'a{ss}uuy', 'a(sssssssssyiqy)', msg.GetEventListReq, msg.GetEventListRsp},
    ClearEventList = {'a{ss}', '', msg.ClearEventListReq, msg.ClearEventListRsp},
    Rearm = {'a{ss}', '', msg.RearmReq, msg.RearmRsp},
    GetEventInfo = {'a{ss}', 'suu', msg.GetEventInfoReq, msg.GetEventInfoRsp}
}, {})
return Events
