-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class EnergyMetric.ResetPowerHistoryDataRsp
local TResetPowerHistoryDataRsp = {}
TResetPowerHistoryDataRsp.__index = TResetPowerHistoryDataRsp
TResetPowerHistoryDataRsp.group = {}

local function TResetPowerHistoryDataRsp_from_obj(obj)
    return setmetatable(obj, TResetPowerHistoryDataRsp)
end

function TResetPowerHistoryDataRsp.new()
    return TResetPowerHistoryDataRsp_from_obj({})
end
---@param obj EnergyMetric.ResetPowerHistoryDataRsp
function TResetPowerHistoryDataRsp:init_from_obj(obj)

end

function TResetPowerHistoryDataRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetPowerHistoryDataRsp.group)
end

TResetPowerHistoryDataRsp.from_obj = TResetPowerHistoryDataRsp_from_obj

TResetPowerHistoryDataRsp.proto_property = {}

TResetPowerHistoryDataRsp.default = {}

TResetPowerHistoryDataRsp.struct = {}

function TResetPowerHistoryDataRsp:validate(prefix, errs)
    prefix = prefix or ''

    TResetPowerHistoryDataRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetPowerHistoryDataRsp.proto_property, errs)
    return self
end

function TResetPowerHistoryDataRsp:unpack(_)
end

msg.ResetPowerHistoryDataRsp = TResetPowerHistoryDataRsp

---@class EnergyMetric.ResetPowerHistoryDataReq
local TResetPowerHistoryDataReq = {}
TResetPowerHistoryDataReq.__index = TResetPowerHistoryDataReq
TResetPowerHistoryDataReq.group = {}

local function TResetPowerHistoryDataReq_from_obj(obj)
    return setmetatable(obj, TResetPowerHistoryDataReq)
end

function TResetPowerHistoryDataReq.new()
    return TResetPowerHistoryDataReq_from_obj({})
end
---@param obj EnergyMetric.ResetPowerHistoryDataReq
function TResetPowerHistoryDataReq:init_from_obj(obj)

end

function TResetPowerHistoryDataReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetPowerHistoryDataReq.group)
end

TResetPowerHistoryDataReq.from_obj = TResetPowerHistoryDataReq_from_obj

TResetPowerHistoryDataReq.proto_property = {}

TResetPowerHistoryDataReq.default = {}

TResetPowerHistoryDataReq.struct = {}

function TResetPowerHistoryDataReq:validate(prefix, errs)
    prefix = prefix or ''

    TResetPowerHistoryDataReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetPowerHistoryDataReq.proto_property, errs)
    return self
end

function TResetPowerHistoryDataReq:unpack(_)
end

msg.ResetPowerHistoryDataReq = TResetPowerHistoryDataReq

---@class EnergyMetric.CollectPowerHistoryDataRsp
local TCollectPowerHistoryDataRsp = {}
TCollectPowerHistoryDataRsp.__index = TCollectPowerHistoryDataRsp
TCollectPowerHistoryDataRsp.group = {}

local function TCollectPowerHistoryDataRsp_from_obj(obj)
    return setmetatable(obj, TCollectPowerHistoryDataRsp)
end

function TCollectPowerHistoryDataRsp.new()
    return TCollectPowerHistoryDataRsp_from_obj({})
end
---@param obj EnergyMetric.CollectPowerHistoryDataRsp
function TCollectPowerHistoryDataRsp:init_from_obj(obj)

end

function TCollectPowerHistoryDataRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCollectPowerHistoryDataRsp.group)
end

TCollectPowerHistoryDataRsp.from_obj = TCollectPowerHistoryDataRsp_from_obj

TCollectPowerHistoryDataRsp.proto_property = {}

TCollectPowerHistoryDataRsp.default = {}

TCollectPowerHistoryDataRsp.struct = {}

function TCollectPowerHistoryDataRsp:validate(prefix, errs)
    prefix = prefix or ''

    TCollectPowerHistoryDataRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCollectPowerHistoryDataRsp.proto_property, errs)
    return self
end

function TCollectPowerHistoryDataRsp:unpack(_)
end

msg.CollectPowerHistoryDataRsp = TCollectPowerHistoryDataRsp

---@class EnergyMetric.CollectPowerHistoryDataReq
local TCollectPowerHistoryDataReq = {}
TCollectPowerHistoryDataReq.__index = TCollectPowerHistoryDataReq
TCollectPowerHistoryDataReq.group = {}

local function TCollectPowerHistoryDataReq_from_obj(obj)
    return setmetatable(obj, TCollectPowerHistoryDataReq)
end

function TCollectPowerHistoryDataReq.new()
    return TCollectPowerHistoryDataReq_from_obj({})
end
---@param obj EnergyMetric.CollectPowerHistoryDataReq
function TCollectPowerHistoryDataReq:init_from_obj(obj)

end

function TCollectPowerHistoryDataReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCollectPowerHistoryDataReq.group)
end

TCollectPowerHistoryDataReq.from_obj = TCollectPowerHistoryDataReq_from_obj

TCollectPowerHistoryDataReq.proto_property = {}

TCollectPowerHistoryDataReq.default = {}

TCollectPowerHistoryDataReq.struct = {}

function TCollectPowerHistoryDataReq:validate(prefix, errs)
    prefix = prefix or ''

    TCollectPowerHistoryDataReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCollectPowerHistoryDataReq.proto_property, errs)
    return self
end

function TCollectPowerHistoryDataReq:unpack(_)
end

msg.CollectPowerHistoryDataReq = TCollectPowerHistoryDataReq

---@class EnergyMetric.PowerResetStatisticsRsp
local TPowerResetStatisticsRsp = {}
TPowerResetStatisticsRsp.__index = TPowerResetStatisticsRsp
TPowerResetStatisticsRsp.group = {}

local function TPowerResetStatisticsRsp_from_obj(obj)
    return setmetatable(obj, TPowerResetStatisticsRsp)
end

function TPowerResetStatisticsRsp.new()
    return TPowerResetStatisticsRsp_from_obj({})
end
---@param obj EnergyMetric.PowerResetStatisticsRsp
function TPowerResetStatisticsRsp:init_from_obj(obj)

end

function TPowerResetStatisticsRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerResetStatisticsRsp.group)
end

TPowerResetStatisticsRsp.from_obj = TPowerResetStatisticsRsp_from_obj

TPowerResetStatisticsRsp.proto_property = {}

TPowerResetStatisticsRsp.default = {}

TPowerResetStatisticsRsp.struct = {}

function TPowerResetStatisticsRsp:validate(prefix, errs)
    prefix = prefix or ''

    TPowerResetStatisticsRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerResetStatisticsRsp.proto_property, errs)
    return self
end

function TPowerResetStatisticsRsp:unpack(_)
end

msg.PowerResetStatisticsRsp = TPowerResetStatisticsRsp

---@class EnergyMetric.PowerResetStatisticsReq
local TPowerResetStatisticsReq = {}
TPowerResetStatisticsReq.__index = TPowerResetStatisticsReq
TPowerResetStatisticsReq.group = {}

local function TPowerResetStatisticsReq_from_obj(obj)
    return setmetatable(obj, TPowerResetStatisticsReq)
end

function TPowerResetStatisticsReq.new()
    return TPowerResetStatisticsReq_from_obj({})
end
---@param obj EnergyMetric.PowerResetStatisticsReq
function TPowerResetStatisticsReq:init_from_obj(obj)

end

function TPowerResetStatisticsReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerResetStatisticsReq.group)
end

TPowerResetStatisticsReq.from_obj = TPowerResetStatisticsReq_from_obj

TPowerResetStatisticsReq.proto_property = {}

TPowerResetStatisticsReq.default = {}

TPowerResetStatisticsReq.struct = {}

function TPowerResetStatisticsReq:validate(prefix, errs)
    prefix = prefix or ''

    TPowerResetStatisticsReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerResetStatisticsReq.proto_property, errs)
    return self
end

function TPowerResetStatisticsReq:unpack(_)
end

msg.PowerResetStatisticsReq = TPowerResetStatisticsReq

local EnergyMetric = {}

local Mdb = require 'mc.mdb'

---@class EnergyMetric: Table
---@field SystemPower integer
---@field SystemOutputPower integer
---@field HighPowerThresholdWatts number
---@field PowerConsumption number
---@field MaxConsumedWatts integer
---@field MaxConsumedOccurredTime integer
---@field MinConsumedWatts integer
---@field StatisticsCollectedTime integer
---@field AverageConsumedWatts integer
---@field HeatKcal integer
EnergyMetric.EnergyMetric = Mdb.register_interface('bmc.kepler.Systems.EnergyMetric', {
    SystemPower = {'u', nil, true, nil},
    SystemOutputPower = {'u', nil, true, nil},
    HighPowerThresholdWatts = {'d', nil, false, nil},
    PowerConsumption = {'d', nil, true, nil},
    MaxConsumedWatts = {'u', nil, true, nil},
    MaxConsumedOccurredTime = {'u', nil, true, nil},
    MinConsumedWatts = {'u', nil, true, nil},
    StatisticsCollectedTime = {'u', nil, true, nil},
    AverageConsumedWatts = {'u', nil, true, nil},
    HeatKcal = {'u', nil, true, nil}
}, {
    PowerResetStatistics = {'a{ss}', '', msg.PowerResetStatisticsReq, msg.PowerResetStatisticsRsp},
    CollectPowerHistoryData = {
        'a{ss}', '', msg.CollectPowerHistoryDataReq, msg.CollectPowerHistoryDataRsp
    },
    ResetPowerHistoryData = {
        'a{ss}', '', msg.ResetPowerHistoryDataReq, msg.ResetPowerHistoryDataRsp
    }
}, {})
return EnergyMetric
