-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class DiscreteSensors.MockSensorRsp
local TMockSensorRsp = {}
TMockSensorRsp.__index = TMockSensorRsp
TMockSensorRsp.group = {}

local function TMockSensorRsp_from_obj(obj)
    return setmetatable(obj, TMockSensorRsp)
end

function TMockSensorRsp.new()
    return TMockSensorRsp_from_obj({})
end
---@param obj DiscreteSensors.MockSensorRsp
function TMockSensorRsp:init_from_obj(obj)

end

function TMockSensorRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMockSensorRsp.group)
end

TMockSensorRsp.from_obj = TMockSensorRsp_from_obj

TMockSensorRsp.proto_property = {}

TMockSensorRsp.default = {}

TMockSensorRsp.struct = {}

function TMockSensorRsp:validate(prefix, errs)
    prefix = prefix or ''

    TMockSensorRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMockSensorRsp.proto_property, errs)
    return self
end

function TMockSensorRsp:unpack(_)
end

msg.MockSensorRsp = TMockSensorRsp

---@class DiscreteSensors.MockSensorReq
---@field Enabled integer
---@field SensorName string
---@field Value string
local TMockSensorReq = {}
TMockSensorReq.__index = TMockSensorReq
TMockSensorReq.group = {}

local function TMockSensorReq_from_obj(obj)
    return setmetatable(obj, TMockSensorReq)
end

function TMockSensorReq.new(Enabled, SensorName, Value)
    return TMockSensorReq_from_obj({Enabled = Enabled, SensorName = SensorName, Value = Value})
end
---@param obj DiscreteSensors.MockSensorReq
function TMockSensorReq:init_from_obj(obj)
    self.Enabled = obj.Enabled
    self.SensorName = obj.SensorName
    self.Value = obj.Value
end

function TMockSensorReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMockSensorReq.group)
end

TMockSensorReq.from_obj = TMockSensorReq_from_obj

TMockSensorReq.proto_property = {'Enabled', 'SensorName', 'Value'}

TMockSensorReq.default = {0, '', ''}

TMockSensorReq.struct = {
    {name = 'Enabled', is_array = false, struct = nil},
    {name = 'SensorName', is_array = false, struct = nil},
    {name = 'Value', is_array = false, struct = nil}
}

function TMockSensorReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Enabled', self.Enabled, 'uint8', false, errs)
    validate.Required(prefix .. 'SensorName', self.SensorName, 'string', false, errs)
    validate.Required(prefix .. 'Value', self.Value, 'string', false, errs)

    validate.ranges(prefix .. 'Enabled', self.Enabled, 0, 1, errs)

    TMockSensorReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMockSensorReq.proto_property, errs)
    return self
end

function TMockSensorReq:unpack(_)
    return self.Enabled, self.SensorName, self.Value
end

msg.MockSensorReq = TMockSensorReq

local DiscreteSensors = {}

local Mdb = require 'mc.mdb'

---@class DiscreteSensors: Table
DiscreteSensors.DiscreteSensors = Mdb.register_interface('bmc.kepler.Systems.DiscreteSensors', {},
    {MockSensor = {'a{ss}yss', '', msg.MockSensorReq, msg.MockSensorRsp}}, {})
return DiscreteSensors
