-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local DiscreteSensor = {}

local Mdb = require 'mc.mdb'

---@class IDiscreteSensor: Table
---@field OwnerId integer
---@field OwnerLun integer
---@field EntityId integer
---@field EntityInstance integer
---@field Initialization integer
---@field Capabilities integer
---@field SensorType integer
---@field ReadingType integer
---@field SensorName string
---@field AssertMask integer
---@field DeassertMask integer
---@field DiscreteMask integer
---@field Unit integer
---@field BaseUnit integer
---@field ModifierUnit integer
---@field RecordSharing integer
---@field PosHysteresis integer
---@field NegHysteresis integer
---@field Reading integer
---@field SensorNumber integer
---@field ReadingStatus integer
---@field Health integer
DiscreteSensor.IDiscreteSensor = Mdb.register_interface('bmc.kepler.Systems.DiscreteSensor', {
    OwnerId = {'y', nil, true, nil},
    OwnerLun = {'y', nil, true, nil},
    EntityId = {'y', nil, true, nil},
    EntityInstance = {'y', nil, true, nil},
    Initialization = {'y', nil, true, nil},
    Capabilities = {'y', nil, true, nil},
    SensorType = {'y', nil, true, nil},
    ReadingType = {'y', nil, true, nil},
    SensorName = {'s', nil, true, nil},
    AssertMask = {'q', nil, true, nil},
    DeassertMask = {'q', nil, true, nil},
    DiscreteMask = {'q', nil, true, nil},
    Unit = {'y', nil, true, nil},
    BaseUnit = {'y', nil, true, nil},
    ModifierUnit = {'y', nil, true, nil},
    RecordSharing = {'q', nil, true, nil},
    PosHysteresis = {'y', nil, true, nil},
    NegHysteresis = {'y', nil, true, nil},
    Reading = {'q', nil, false, nil},
    SensorNumber = {'y', nil, true, nil},
    ReadingStatus = {'y', nil, false, nil},
    Health = {'y', nil, true, nil}
}, {}, {})

return DiscreteSensor
