-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class CoolingRequirement.SetTargetTemperatureReq
---@field TemperatureCelsius integer
local TSetTargetTemperatureReq = {}
TSetTargetTemperatureReq.__index = TSetTargetTemperatureReq
TSetTargetTemperatureReq.group = {}

local function TSetTargetTemperatureReq_from_obj(obj)
    return setmetatable(obj, TSetTargetTemperatureReq)
end

function TSetTargetTemperatureReq.new(TemperatureCelsius)
    return TSetTargetTemperatureReq_from_obj({TemperatureCelsius = TemperatureCelsius})
end
---@param obj CoolingRequirement.SetTargetTemperatureReq
function TSetTargetTemperatureReq:init_from_obj(obj)
    self.TemperatureCelsius = obj.TemperatureCelsius
end

function TSetTargetTemperatureReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetTargetTemperatureReq.group)
end

TSetTargetTemperatureReq.from_obj = TSetTargetTemperatureReq_from_obj

TSetTargetTemperatureReq.proto_property = {'TemperatureCelsius'}

TSetTargetTemperatureReq.default = {0}

TSetTargetTemperatureReq.struct = {{name = 'TemperatureCelsius', is_array = false, struct = nil}}

function TSetTargetTemperatureReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TemperatureCelsius', self.TemperatureCelsius, 'uint8', false, errs)

    if self.TemperatureCelsius ~= nil then
    end

    TSetTargetTemperatureReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetTargetTemperatureReq.proto_property, errs)
    return self
end

function TSetTargetTemperatureReq:unpack(_)
    return self.TemperatureCelsius
end

msg.SetTargetTemperatureReq = TSetTargetTemperatureReq

local CoolingRequirement = {}

local Mdb = require 'mc.mdb'

---@class CoolingRequirement: Table
---@field RequirementId integer
---@field TemperatureType integer
---@field ActiveInStandby boolean
---@field TargetTemperatureCelsius integer
---@field MaxAllowedTemperatureCelsius integer
---@field CustomSupported boolean
---@field CustomTargetTemperatureCelsius integer
---@field TargetTemperatureRangeCelsius integer[]
---@field MonitoringStatus integer
---@field MonitoringValue integer
---@field FailedValue integer
---@field ThresholdValue integer[]
---@field AlarmSpeed integer[]
CoolingRequirement.CoolingRequirement = Mdb.register_interface(
    'bmc.kepler.Systems.CoolingRequirement', {
        RequirementId = {'y', nil, true, nil},
        TemperatureType = {'u', nil, true, nil},
        ActiveInStandby = {'b', nil, true, nil},
        TargetTemperatureCelsius = {'y', nil, false, nil},
        MaxAllowedTemperatureCelsius = {'y', nil, true, nil},
        CustomSupported = {'b', nil, false, False},
        CustomTargetTemperatureCelsius = {'y', nil, true, nil},
        TargetTemperatureRangeCelsius = {'ay', nil, false, nil},
        MonitoringStatus = {'y', nil, false, nil},
        MonitoringValue = {'t', nil, false, nil},
        FailedValue = {'t', nil, false, nil},
        ThresholdValue = {'ay', nil, false, nil},
        AlarmSpeed = {'ay', nil, false, nil}
    }, {SetTargetTemperature = {'a{ss}y', '', msg.SetTargetTemperatureReq, nil}}, {})
return CoolingRequirement
