-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local CoolingFan = {}

local Mdb = require 'mc.mdb'

---@class CoolingFan: Table
---@field FanId integer
---@field HardwarePWM number
---@field FrontPresence integer
---@field RearPresence integer
---@field FrontStatus integer
---@field RearStatus integer
---@field FrontSpeed integer
---@field RearSpeed integer
CoolingFan.CoolingFan = Mdb.register_interface('bmc.kepler.Systems.CoolingFan', {
    FanId = {'y', nil, true, nil},
    HardwarePWM = {'d', nil, false, nil},
    FrontPresence = {'y', nil, false, nil},
    RearPresence = {'y', nil, false, nil},
    FrontStatus = {'y', nil, false, nil},
    RearStatus = {'y', nil, false, nil},
    FrontSpeed = {'q', nil, false, nil},
    RearSpeed = {'q', nil, false, nil}
}, {}, {})
return CoolingFan
