-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class CoolingConfig.SetCtrlModeReq
---@field CtrlMode string
---@field Timeout integer
local TSetCtrlModeReq = {}
TSetCtrlModeReq.__index = TSetCtrlModeReq
TSetCtrlModeReq.group = {}

local function TSetCtrlModeReq_from_obj(obj)
    return setmetatable(obj, TSetCtrlModeReq)
end

function TSetCtrlModeReq.new(CtrlMode, Timeout)
    return TSetCtrlModeReq_from_obj({CtrlMode = CtrlMode, Timeout = Timeout})
end
---@param obj CoolingConfig.SetCtrlModeReq
function TSetCtrlModeReq:init_from_obj(obj)
    self.CtrlMode = obj.CtrlMode
    self.Timeout = obj.Timeout
end

function TSetCtrlModeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCtrlModeReq.group)
end

TSetCtrlModeReq.from_obj = TSetCtrlModeReq_from_obj

TSetCtrlModeReq.proto_property = {'CtrlMode', 'Timeout'}

TSetCtrlModeReq.default = {'', 0}

TSetCtrlModeReq.struct = {
    {name = 'CtrlMode', is_array = false, struct = nil},
    {name = 'Timeout', is_array = false, struct = nil}
}

function TSetCtrlModeReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CtrlMode', self.CtrlMode, 'string', false, errs)
    validate.Optional(prefix .. 'Timeout', self.Timeout, 'uint32', false, errs)

    if self.CtrlMode ~= nil then
    end
    if self.Timeout ~= nil then
    end

    TSetCtrlModeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCtrlModeReq.proto_property, errs)
    return self
end

function TSetCtrlModeReq:unpack(_)
    return self.CtrlMode, self.Timeout
end

msg.SetCtrlModeReq = TSetCtrlModeReq

---@class CoolingConfig.SetManualLevelReq
---@field UnitId integer
---@field Level integer
local TSetManualLevelReq = {}
TSetManualLevelReq.__index = TSetManualLevelReq
TSetManualLevelReq.group = {}

local function TSetManualLevelReq_from_obj(obj)
    return setmetatable(obj, TSetManualLevelReq)
end

function TSetManualLevelReq.new(UnitId, Level)
    return TSetManualLevelReq_from_obj({UnitId = UnitId, Level = Level})
end
---@param obj CoolingConfig.SetManualLevelReq
function TSetManualLevelReq:init_from_obj(obj)
    self.UnitId = obj.UnitId
    self.Level = obj.Level
end

function TSetManualLevelReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetManualLevelReq.group)
end

TSetManualLevelReq.from_obj = TSetManualLevelReq_from_obj

TSetManualLevelReq.proto_property = {'UnitId', 'Level'}

TSetManualLevelReq.default = {0, 0}

TSetManualLevelReq.struct = {
    {name = 'UnitId', is_array = false, struct = nil},
    {name = 'Level', is_array = false, struct = nil}
}

function TSetManualLevelReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UnitId', self.UnitId, 'uint8', false, errs)
    validate.Optional(prefix .. 'Level', self.Level, 'uint8', false, errs)

    if self.UnitId ~= nil then
    end
    if self.Level ~= nil then
    end

    TSetManualLevelReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetManualLevelReq.proto_property, errs)
    return self
end

function TSetManualLevelReq:unpack(_)
    return self.UnitId, self.Level
end

msg.SetManualLevelReq = TSetManualLevelReq

---@class CoolingConfig.SetMediumRsp
---@field Result integer
local TSetMediumRsp = {}
TSetMediumRsp.__index = TSetMediumRsp
TSetMediumRsp.group = {}

local function TSetMediumRsp_from_obj(obj)
    return setmetatable(obj, TSetMediumRsp)
end

function TSetMediumRsp.new(Result)
    return TSetMediumRsp_from_obj({Result = Result})
end
---@param obj CoolingConfig.SetMediumRsp
function TSetMediumRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TSetMediumRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetMediumRsp.group)
end

TSetMediumRsp.from_obj = TSetMediumRsp_from_obj

TSetMediumRsp.proto_property = {'Result'}

TSetMediumRsp.default = {0}

TSetMediumRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TSetMediumRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'int32', false, errs)

    if self.Result ~= nil then
    end

    TSetMediumRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetMediumRsp.proto_property, errs)
    return self
end

function TSetMediumRsp:unpack(_)
    return self.Result
end

msg.SetMediumRsp = TSetMediumRsp

---@class CoolingConfig.SetMediumReq
---@field Medium string
local TSetMediumReq = {}
TSetMediumReq.__index = TSetMediumReq
TSetMediumReq.group = {}

local function TSetMediumReq_from_obj(obj)
    return setmetatable(obj, TSetMediumReq)
end

function TSetMediumReq.new(Medium)
    return TSetMediumReq_from_obj({Medium = Medium})
end
---@param obj CoolingConfig.SetMediumReq
function TSetMediumReq:init_from_obj(obj)
    self.Medium = obj.Medium
end

function TSetMediumReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetMediumReq.group)
end

TSetMediumReq.from_obj = TSetMediumReq_from_obj

TSetMediumReq.proto_property = {'Medium'}

TSetMediumReq.default = {''}

TSetMediumReq.struct = {{name = 'Medium', is_array = false, struct = nil}}

function TSetMediumReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Medium', self.Medium, 'string', false, errs)

    if self.Medium ~= nil then
        validate.regex(prefix .. 'Medium', self.Medium, [=[^(Air|Liquid)$]=], errs)
    end

    TSetMediumReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetMediumReq.proto_property, errs)
    return self
end

function TSetMediumReq:unpack(_)
    return self.Medium
end

msg.SetMediumReq = TSetMediumReq

---@class CoolingConfig.SetSmartCoolingModeRsp
---@field Result integer
local TSetSmartCoolingModeRsp = {}
TSetSmartCoolingModeRsp.__index = TSetSmartCoolingModeRsp
TSetSmartCoolingModeRsp.group = {}

local function TSetSmartCoolingModeRsp_from_obj(obj)
    return setmetatable(obj, TSetSmartCoolingModeRsp)
end

function TSetSmartCoolingModeRsp.new(Result)
    return TSetSmartCoolingModeRsp_from_obj({Result = Result})
end
---@param obj CoolingConfig.SetSmartCoolingModeRsp
function TSetSmartCoolingModeRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TSetSmartCoolingModeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSmartCoolingModeRsp.group)
end

TSetSmartCoolingModeRsp.from_obj = TSetSmartCoolingModeRsp_from_obj

TSetSmartCoolingModeRsp.proto_property = {'Result'}

TSetSmartCoolingModeRsp.default = {0}

TSetSmartCoolingModeRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TSetSmartCoolingModeRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'int32', false, errs)

    if self.Result ~= nil then
    end

    TSetSmartCoolingModeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSmartCoolingModeRsp.proto_property, errs)
    return self
end

function TSetSmartCoolingModeRsp:unpack(_)
    return self.Result
end

msg.SetSmartCoolingModeRsp = TSetSmartCoolingModeRsp

---@class CoolingConfig.SetSmartCoolingModeReq
---@field Mode string
local TSetSmartCoolingModeReq = {}
TSetSmartCoolingModeReq.__index = TSetSmartCoolingModeReq
TSetSmartCoolingModeReq.group = {}

local function TSetSmartCoolingModeReq_from_obj(obj)
    return setmetatable(obj, TSetSmartCoolingModeReq)
end

function TSetSmartCoolingModeReq.new(Mode)
    return TSetSmartCoolingModeReq_from_obj({Mode = Mode})
end
---@param obj CoolingConfig.SetSmartCoolingModeReq
function TSetSmartCoolingModeReq:init_from_obj(obj)
    self.Mode = obj.Mode
end

function TSetSmartCoolingModeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSmartCoolingModeReq.group)
end

TSetSmartCoolingModeReq.from_obj = TSetSmartCoolingModeReq_from_obj

TSetSmartCoolingModeReq.proto_property = {'Mode'}

TSetSmartCoolingModeReq.default = {''}

TSetSmartCoolingModeReq.struct = {{name = 'Mode', is_array = false, struct = nil}}

function TSetSmartCoolingModeReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Mode', self.Mode, 'string', false, errs)

    if self.Mode ~= nil then
    end

    TSetSmartCoolingModeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSmartCoolingModeReq.proto_property, errs)
    return self
end

function TSetSmartCoolingModeReq:unpack(_)
    return self.Mode
end

msg.SetSmartCoolingModeReq = TSetSmartCoolingModeReq

local CoolingConfig = {}

local Mdb = require 'mc.mdb'

---@class CoolingConfig: Table
---@field SmartCoolingState string
---@field SmartCoolingMode string
---@field Medium string
---@field CtrlMode string
---@field TimeOut integer
---@field ManualLevel integer
---@field LevelPercentRange integer[]
CoolingConfig.CoolingConfig = Mdb.register_interface('bmc.kepler.Systems.CoolingConfig', {
    SmartCoolingState = {'s', nil, false, nil},
    SmartCoolingMode = {'s', nil, true, nil},
    Medium = {'s', nil, true, nil},
    CtrlMode = {'s', nil, true, nil},
    TimeOut = {'u', nil, true, nil},
    ManualLevel = {'y', nil, true, nil},
    LevelPercentRange = {'ay', nil, true, nil}
}, {
    SetSmartCoolingMode = {'a{ss}s', 'i', msg.SetSmartCoolingModeReq, msg.SetSmartCoolingModeRsp},
    SetMedium = {'a{ss}s', 'i', msg.SetMediumReq, msg.SetMediumRsp},
    SetManualLevel = {'a{ss}yy', '', msg.SetManualLevelReq, nil},
    SetCtrlMode = {'a{ss}su', '', msg.SetCtrlModeReq, nil}
}, {})
return CoolingConfig
