-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local CoolingArea = {}

local Mdb = require 'mc.mdb'

---@class CoolingArea: Table
---@field AreaId integer
---@field RequirementIdx integer
---@field PolicyIdxGroup integer[]
---@field FanIdxGroup integer[]
CoolingArea.CoolingArea = Mdb.register_interface('bmc.kepler.Systems.CoolingArea', {
    AreaId = {'y', nil, false, nil},
    RequirementIdx = {'y', nil, false, nil},
    PolicyIdxGroup = {'ay', nil, false, nil},
    FanIdxGroup = {'ay', nil, false, nil}
}, {}, {})
return CoolingArea
