-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local BootOptions = {}

local Mdb = require 'mc.mdb'

---@class BootOptions: Table
---@field BootSourceOverrideMode string
---@field BootSourceOverrideEnabled string
---@field BootSourceOverrideTarget string
---@field BootOptionReference string[]
---@field BootOrder string[]
---@field BootModeSupport boolean
---@field BootModeIpmiSettable boolean
BootOptions.BootOptions = Mdb.register_interface('bmc.kepler.Systems.BootOptions', {
    BootSourceOverrideMode = {'s', nil, true, 'UEFI'},
    BootSourceOverrideEnabled = {'s', nil, true, 'Disabled'},
    BootSourceOverrideTarget = {'s', nil, true, 'HDD'},
    BootOptionReference = {'as', nil, true, nil},
    BootOrder = {'as', nil, true, nil},
    BootModeSupport = {'b', nil, true, true},
    BootModeIpmiSettable = {'b', nil, true, true}
}, {}, {})
return BootOptions
