-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local Bios = {}

local Mdb = require 'mc.mdb'

---@class Bios: Table
---@field SystemStartupState integer
---@field SystemId integer
---@field Version string
---@field BackupVersion string
---@field CurrentValueFileName string
---@field ResultFileName string
---@field SettingFileName string
---@field RegistryFileName string
---@field MenuData string
---@field MenuChangeFlag integer
---@field RegistryVersion string
---@field DEMTConfig integer
---@field PcieCardBDF integer[]
---@field PcieDiskBDF integer[]
---@field OCPCardBDF integer[]
---@field BiosBootStage integer
Bios.Bios = Mdb.register_interface('bmc.kepler.Systems.Bios', {
    SystemStartupState = {'y', nil, true, nil},
    SystemId = {'y', nil, true, nil},
    Version = {'s', nil, true, nil},
    BackupVersion = {'s', nil, true, nil},
    CurrentValueFileName = {'s', nil, true, nil},
    ResultFileName = {'s', nil, true, nil},
    SettingFileName = {'s', nil, true, nil},
    RegistryFileName = {'s', nil, true, nil},
    MenuData = {'s', nil, true, nil},
    MenuChangeFlag = {'y', nil, true, nil},
    RegistryVersion = {'s', nil, true, nil},
    DEMTConfig = {'y', nil, true, nil},
    PcieCardBDF = {'ay', nil, true, nil},
    PcieDiskBDF = {'ay', nil, true, nil},
    OCPCardBDF = {'ay', nil, true, nil},
    BiosBootStage = {'y', nil, true, nil}
}, {}, {})
return Bios
